var bm = require("../shared-modules/bookmarks");

const TIMEOUT = 5000;

const LOCAL_TEST_FOLDER = collector.addHttpResource('../test-files/');
const LOCAL_TEST_PAGE = LOCAL_TEST_FOLDER + 'test.html';
const LOCAL_TEST_FEED = LOCAL_TEST_FOLDER + 'feed.atom';

var setupModule = function(module) {
    module.controller = mozmill.getBrowserController();
    module.jum = {};
    module.desktopcouch = {};
    module.bindwood = {};
    Cu.import("resource://mozmill/modules/jum.js", module.jum);
    Cu.import("resource://bindwood/desktopcouch.jsm", module.desktopcouch);
    Cu.import("resource://bindwood/bindwood.jsm", module.bindwood);
    bm.clearBookmarks();
    module.couch = null;
    module.synchroniser = null;
};


var setupTest = function(test) {
    var done = false;
    desktopcouch.connect_desktopcouch("test_bookmarks", function(db) {
            couch = db;
            done = true;
        }, function (message) {});
    controller.waitFor(
        function() { return done; }, "Could not connect to CouchDB", TIMEOUT);
    jum.assertNotEquals(couch, null);

    try {
        couch.createDb();
    } catch (e) {
        if (e.error != 'file_exists')
            throw(e);
    }
};


var teardownTest = function(test) {
    //bindwood.Bindwood.uninit();
    bm.clearBookmarks();
    couch.deleteDb();
};

var test_bindwood_init = function() {
    bindwood.Bindwood.init();
    controller.waitFor(function() {
            return bindwood.Bindwood.synchroniser != null;
    }, "Bindwood did not initialise", TIMEOUT);

    // XXX: this check causes mozmill to crash.  Possibly when it
    //tries to serialise the synchroniser?
    //jum.assertNotEquals(bindwood.Bindwood.synchroniser, null);

    // The synchronisation timer has been initialised.
    jum.assertNotNull(bindwood.Bindwood.sync_timer.callback);
};

var test_bindwood_uninit = function() {
    bindwood.Bindwood.init();
    controller.waitFor(function() {
            return bindwood.Bindwood.synchroniser != null;
    }, "Bindwood did not initialise", TIMEOUT);
    bindwood.Bindwood.uninit();

    jum.assertNull(bindwood.Bindwood.sync_timer.callback);
    jum.assertNull(bindwood.Bindwood.synchroniser);
}
