/* 
 * Copyright (c) 2010 Craig Heffner
 *
 * This software is provided under the MIT license. For the full text of this license, please see
 * the COPYING file included with this code, or visit http://www.opensource.org/licenses/MIT.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "smartsig.h"
#include "common.h"

/* Checks if a match is a repeat of a previous match type */
int is_repeat_of_many(char *match)
{
	char *ptr = NULL;
	static char *last_match;

	/* If the last signature matches the current signature, return 1 */
	if(last_match && match != NULL && strcmp(match, last_match) == 0)
	{
		return 1;
	}
	else
	{
		/* Else, remove the last signature */
		if(last_match)
		{
			free(last_match);
			last_match = NULL;
		}
	}

	/* If this signature is one of many, save it as the last signature */
	if(match != NULL && (ptr = strstr(match, ONE_OF_MANY)) != NULL)
	{
		if(last_match)
		{
			free(last_match);
			last_match = NULL;
		}

		last_match = strdup(match);

		/* NULL terminate the ONE_OF_MANY keyword so it is not displayed to the end user. */
		ptr[0] = 0;
	}

	return 0;
}

/* Parses a match string for the JUMP_TO_OFFSET keyword. Returns the number of bytes to increment the offset. */
int jump_to_offset(char *match)
{
	int offset = 0;
	char *ptr = NULL;

	if((ptr = strstr(match, JUMP_TO_OFFSET)) != NULL)
	{
		offset = atoi(ptr + strlen(JUMP_TO_OFFSET));
		ptr[0] = 0;
	}

	return offset;
}
