/**
 *if a floating number is less of this value is converted to zero
 */
#define TRE_TRESHOLD 1E-5
#define TRE_POLY_RAW_FORMAT 0
#define TRE_POLY_TEX_FORMAT 1
#define TRE_POLY_OOFFICE_FORMAT 2

/**
 *Plugin to calculatethe topological resonance energy of a non-eteroatomic molecule
 *see bist_plugin.hpp
 */
class TREcalc: public bist_plugin{
public:
  /**
   *Constructor
   */
  
  TREcalc(immagine* image, string libpath);

  /**
   *Destructor
   */

  virtual ~TREcalc();
  
  virtual bool act(int e);
  
  
  virtual void register_plugin();
  virtual bool time_to_act();
  

  virtual bool need_atom();
  virtual bool need_leg();

  virtual string libpath();

  /**
   *open the dialog window
   */

  void inizialize();

  /**
   *Scan elements  of matrix and set to  zero if the value  is less of
   *TRE_TRESHOLD
   */

  void zerify(matrix<double>& m);

protected:
  void           calculateTRE();
  vector<double> calculate_characteristic_polynomial(matrix<double>& adjac_matrix);
  matrix<double> calculate_adjac_matrix(gruppo * group);

  template <class T> bool similar_to(T v, T ref, T offset);

  std::string format_polynomial(std::vector<double>& coeff_vec, int format);

  bool _has_to_act;
  bool _has_acted;

};

extern "C" bist_plugin* create_plugin(immagine* imm, string libpath);
extern "C"  void destroy_plugin(bist_plugin* j);

