The Facebook protocol plugin for bitlbee. This plugin uses the Facebook
Mobile API.

## Usage

General usage instructions are available in the bitlbee wiki:

https://wiki.bitlbee.org/HowtoFacebookMQTT

## Installing from APT repo

An APT repo for several recent debian/ubuntu versions is available here:

https://jgeboski.github.io/

## Building from source

Make sure bitlbee and its headers have been installed. If bitlbee came
from the distribution's repository, it will most likely need the
development package, usually bitlbee-dev.

If bitlbee was built by hand (or alike via a script), ensure the make
target `install-dev` is invoked. This target is not called by default,
and will install the headers that are needed.

Do *not* use the source tree headers unless you know what you are
doing. This can lead to mismatched header versions, which often times
will lead to bad things.

    $ git clone https://github.com/jgeboski/bitlbee-facebook.git
    $ cd bitlbee-facebook

With a "global" (or system) bitlbee installation:

    $ ./autogen.sh
    $ make
    $ make install

Or with a "local" bitlbee installation (location: $HOME/bitlbee):

    $ export BITLBEE_CFLAGS="-I$HOME/bitlbee/include/bitlbee"
    $ export BITLBEE_LIBS=""
    $ ./autogen.sh --with-plugindir=$HOME/bitlbee/lib
    $ make
    $ make install

## Debugging

One of the two supported environment variables can be defined to enable
debugging output. This can be used in unison with debuggers such as
GDB, which should enable easier tracing of bugs.

When posting to the issue tracker, please ensure any sensitive
information has been stripped.

For bitlbee and the plugin:

    $ export BITLBEE_DEBUG=1
    OR
    $ BITLBEE_DEBUG=1 gdb ...

For just the plugin:

    $ export BITLBEE_DEBUG_FACEBOOK=1
    OR
    $ BITLBEE_DEBUG_FACEBOOK=1 gdb ...

Obtaining a GDB backtrace:

    $ gdb \
        -ex 'handle SIGPIPE nostop noprint pass' \
        -ex 'break g_log' -ex run -ex bt \
        --args /usr/sbin/bitlbee -Dnvc /etc/bitlbee/bitlbee.conf
