//
// Author:
//   Mikael Hallendal <micke@imendio.com>
//
// (C) 2004 Imendio AB
//

using GConf;
using Gtk;
using System;
using GtkSharp;
using Gecko;
using Mono.Unix;
using System.Collections;
using System.Reflection;
using System.IO;
using System.Net;
using System.Text;

namespace Imendio.Blam {
    public class ItemView {
        private WebControl mMoz;
	private Imendio.Blam.Item currentItem;

	public bool PageLoaded;

        public event StringUpdatedHandler OnUrl;

	public Imendio.Blam.Item CurrentItem {
	    get {
		return currentItem;
	    }
	     
	    set {
		currentItem = value;
		Load ();
	    }
	}

        public WebControl Widget {
            get {
                return mMoz;
            }
        }

	public ItemView ()
        {
            this.mMoz = new WebControl ();
	   
            Conf.AddNotify (Preference.FONT_PATH,
                            new NotifyEventHandler (FontNotifyHandler));
	    SetFonts ();

            ProxyUpdatedCb ();
            Proxy.Updated += ProxyUpdatedCb;

            mMoz.OpenUri += new OpenUriHandler (LinkClickedCb);
            mMoz.DestroyBrowser += new EventHandler (TitleChangedCb);
            mMoz.NetStart += new EventHandler (NetStartCb);
            mMoz.NetStop += new EventHandler (NetStopCb);
            mMoz.LinkMsg += new EventHandler (LinkMsgCb);
            
	    mMoz.Show ();
	    PageLoaded = false;
        }
        
        private void TitleChangedCb (object obj, EventArgs args)
        {
            System.Console.WriteLine ("Title Changed: {0}", mMoz.Title);
        }

        private void LinkMsgCb (object obj, EventArgs args)
        {
            if (OnUrl != null) {
                OnUrl (mMoz.LinkMessage);
            }
        }

        private void NetStartCb (object obj, EventArgs args)
        {
            System.Console.WriteLine ("Net start");
        }

        private void NetStopCb (object obj, EventArgs args)
        {
            System.Console.WriteLine ("Net stop");
        }

        private void Load()
        {
			Theme theme = Application.TheApp.ThemeManager.CurrentTheme;

            string author  = (!"".Equals(currentItem.Author)) ? String.Format(Catalog.GetString("by {0}"), currentItem.Author) : "&nbsp;";
            string link    = Catalog.GetString("Show in browser");
            string pubdate = (!currentItem.PubDate.Equals(DateTime.MinValue)) ? currentItem.PubDate.ToLongDateString() : "&nbsp;";
            string text    = HtmlUtils.EncodeUnicode(HtmlUtils.FixMarkup(currentItem.Text));
            string title   = HtmlUtils.Escape(currentItem.Title);
            string url     = currentItem.Link;

			mMoz.OpenStream ("file://" + theme.Path + "/", "text/html");
            mMoz.AppendData (theme.Render(author, link, pubdate, 
										  text, title, url));
            mMoz.CloseStream ();
	}

	private void LinkClickedCb(object obj, OpenUriArgs args)
	{
	    try {
                Gnome.Url.Show(args.AURI);
	    }
	    catch (Exception e) {
                Console.WriteLine("Couldn't show URL: " + args.AURI);
            }

            args.RetVal = true;
        }

        private void SetFonts ()
        {
            string varFont = Conf.Get (Preference.VARIABLE_FONT, "Sans 12");
            string fixedFont = Conf.Get (Preference.FIXED_FONT, "Mono 12");

            Utils.GeckoSetFont (1, varFont);
            Utils.GeckoSetFont (2, fixedFont);
        }

        private void FontNotifyHandler (object sender, NotifyEventArgs args)
        {
            if (args.Key == Conf.GetFullKey (Preference.VARIABLE_FONT) ||
                args.Key == Conf.GetFullKey (Preference.FIXED_FONT)) {
                SetFonts ();
            }
        }

        private void ProxyUpdatedCb ()
        {
            Utils.GeckoSetProxy (Proxy.UseProxy, Proxy.ProxyHost,
                                 Proxy.ProxyPort);
        }
    }
}
