/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2004 Imendio HB
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "blam-utils.h"

static gint
tree_iter_compare_func (GtkTreeModel *model,
			GtkTreeIter  *a,
			GtkTreeIter  *b,
			SortFunc_     func)
{
	return (*func) (a, b);
}

void 
blam_tree_model_set_default_sort_func (GtkTreeModel *model, SortFunc_ func)
{
	gtk_tree_sortable_set_default_sort_func (GTK_TREE_SORTABLE (model),
						 (GtkTreeIterCompareFunc) tree_iter_compare_func,
						 func,
						 NULL);
}

void 
blam_tree_model_set_sort_func (GtkTreeModel *model, int col, SortFunc_ func)
{
	gtk_tree_sortable_set_sort_func (GTK_TREE_SORTABLE (model),
					 col,
					 (GtkTreeIterCompareFunc) tree_iter_compare_func,
					 func,
					 NULL);
}

static void
ellipsize_string (gchar *str, gint len)
{
	gchar *tmp;

	if (g_utf8_strlen (str, -1) > len + 4) {
		tmp = g_utf8_offset_to_pointer (str, len);

		tmp[0] = '.';
		tmp[1] = '.';
		tmp[2] = '.';
		tmp[3] = '\0';
	}
}

#define ELLIPSIS_LIMIT 6
#define TREE_INDENT 30

gchar *
blam_ellipsize_and_delimit_string (GtkWidget   *widget, 
				   const gchar *str, 
				   gint         width)
{
	PangoLayout    *layout;
	PangoRectangle  rect;
	gint            len_str;
	gint            width_str;
	gchar          *ret_val;

	ret_val = g_strdup (str);

	g_strdelimit (ret_val, "\n\r\t", '\0');

	len_str = g_utf8_strlen (ret_val, -1);

	if (len_str < ELLIPSIS_LIMIT) {
		return ret_val;
	}

	layout = gtk_widget_create_pango_layout (widget, NULL);
	
	pango_layout_set_text (layout, ret_val, -1);
	pango_layout_get_extents (layout, NULL, &rect);
	width_str = rect.width / PANGO_SCALE;

	while (len_str >= ELLIPSIS_LIMIT && width_str > width) {
		len_str--;
		ellipsize_string (ret_val, len_str);
		
		pango_layout_set_text (layout, ret_val, -1);
		pango_layout_get_extents (layout, NULL, &rect);
		
		width_str = rect.width / PANGO_SCALE;
	}

	g_object_unref (layout);

	return ret_val;
}
