/*
 * Copyright (c) 2007 Carlos Martín Nieto
 * 
 * This file is under GPLv2 or later.
 */

using NDesk.DBus;
using org.freedesktop.DBus;

namespace Imendio.Blam {
    [Interface("org.gnome.feed.Reader")]
    public interface IDBlam {
        void Test();
        bool Subscribe(string url);
    }
    
    public class DBusMgr : IDBlam {
        
        public static string bus_name = "org.gnome.feed.Reader";
        public static string obj_path = "/org/gnome/feed/Reader";

        private Application app = null;

        public void Test()
        {
            System.Console.WriteLine("tested");
        }

        public DBusMgr(Application app)
        {
            BusG.Init();
            this.app = app;
        }

        ~DBusMgr()
        {
            Unregister();
        }

        public static bool running()
        { /* TODO: Shouldn't we make sure we are the owners? */
            return Bus.Session.NameHasOwner(bus_name);
        }
        
        public void Register()
        {
            if(running())
                return;
            
            Bus.Session.RequestName(bus_name);
            Bus.Session.Register(new ObjectPath(obj_path), this);
            /* TODO: We should probably try to unregister whatever we had registered
             * when we failed.
             */
        }
        
        public void Unregister()
        {
            if(!running())
                return;

            Bus.Session.Unregister(new ObjectPath(obj_path));
            Bus.Session.ReleaseName(bus_name);
        }
        
        public static DBusMgr GetInstance()
        {
            if(!running())
                return null;

            return Bus.Session.GetObject<DBusMgr>(bus_name, new ObjectPath(obj_path));
        }

        public bool Subscribe(string url)
        {
            Channel channel = new Channel();
            channel.Url = url;
            
            app.CCollection.Add(channel);
            
            return true;
        }
    }
}