/* SPDX-License-Identifier: GPL-2.0-or-later
 * Copyright 2021 Blender Foundation. All rights reserved. */

/** \file
 * \ingroup cmpnodes
 */

#include "node_composite_util.hh"

/* **************** Posterize ******************** */

namespace blender::nodes::node_composite_posterize_cc {

static void cmp_node_posterize_declare(NodeDeclarationBuilder &b)
{
  b.add_input<decl::Color>(N_("Image")).default_value({1.0f, 1.0f, 1.0f, 1.0f});
  b.add_input<decl::Float>(N_("Steps")).default_value(8.0f).min(2.0f).max(1024.0f);
  b.add_output<decl::Color>(N_("Image"));
}

}  // namespace blender::nodes::node_composite_posterize_cc

void register_node_type_cmp_posterize()
{
  namespace file_ns = blender::nodes::node_composite_posterize_cc;

  static bNodeType ntype;

  cmp_node_type_base(&ntype, CMP_NODE_POSTERIZE, "Posterize", NODE_CLASS_OP_COLOR);
  ntype.declare = file_ns::cmp_node_posterize_declare;

  nodeRegisterType(&ntype);
}
