#!/usr/bin/env python

# BloGTK Version 1.0
# Configuration Routines - config.py
# (C)2004 Jay Reding
# Code released under the terms of the BSD License. (See file LICENSE)

# 0.7 - These functions control the management of accounts for BloGTK 0.7. This is a rewrite
# of the original config.py so that BloGTK can handle multiple blogging accounts.

import pygtk
import gtk
import gtk.glade
import pango
import ConfigParser
import os

# 0.7 - Python 2.3 doesn't like arguments named None. It doesn't care about arguments named 'foo'
foo = 0;

class blogtkPrefs:

   def drawPrefs(self, mainGlade, foo):

      self.mainGlade = mainGlade

      # 0.7 - Here's where we pull our widgets. Pulling a widget sounds kinda painful,
      # doesn't it?
      self.accountsWindow = self.mainGlade.get_widget('accountsWindow')
      self.blogURLEntry = self.mainGlade.get_widget('blogURLEntry')
      self.blogUserEntry = self.mainGlade.get_widget('blogUserEntry')
      self.blogPassEntry = self.mainGlade.get_widget('blogPassEntry')
      self.blogRadioBlogger = self.mainGlade.get_widget('blogRadioBlogger')
      self.blogRadioMT = self.mainGlade.get_widget('blogRadioMT')
      self.blogRadioMW = self.mainGlade.get_widget('blogRadioMW')

      self.blogSaveButton = self.mainGlade.get_widget('blogSaveButton')
      self.blogNewButton = self.mainGlade.get_widget('blogNewButton')
      self.blogDeleteButton = self.mainGlade.get_widget('blogDeleteButton')

      self.blogFontsButton = self.mainGlade.get_widget('blogFontsButton')
      self.fontEntry = self.mainGlade.get_widget('blogFontsEntry')

      self.blogOKButton = self.mainGlade.get_widget('blogOKButton')
      self.blogCancelButton = self.mainGlade.get_widget('blogCancelButton')

      # 0.8-5 - Here's where we retrieve our proxy settings widgets and connect with
      # our proxy interface callbacks.

      self.proxyAddressEntry = self.mainGlade.get_widget("proxyAddressEntry")
      self.proxyPortEntry = self.mainGlade.get_widget("proxyPortEntry")
      self.proxyButton_Custom = self.mainGlade.get_widget("proxyButton_Custom")
      self.proxyButton_System = self.mainGlade.get_widget("proxyButton_System")
      self.proxyButton_None = self.mainGlade.get_widget("proxyButton_None")
      self.mainGlade.signal_autoconnect({'on_proxyButton_Custom_toggled': self.toggleProxyEntries})

      # 0.9 - We should also ensure that our widgets for our general settings also get pulled
      # for manipulation
      self.defaultPublishCheck = self.mainGlade.get_widget('option_DefaultPublish')
      self.useUTF8Check = self.mainGlade.get_widget('option_useUTF8')
      self.retrievalSpin = self.mainGlade.get_widget('retrievalSpin')

      self.defaultMainCheck = self.mainGlade.get_widget('publishCheck')

      self.url = ""
      self.user = ""
      self.passwd = ""
      self.system = ""

      # Check for config file. If it exists, fill the form with the previous data
      self.homeDir = os.path.expanduser('~')
      self.configDir = self.homeDir + "/.BloGTK"

      if os.path.isfile(self.configDir + "/BloGTK.conf") == 1:
         self.configFile = self.configDir + "/BloGTK.conf"
         self.parser = ConfigParser.ConfigParser()
         self.file = open(self.configFile, "rw")
         self.parser.readfp(self.file)

	      # 0.7 - Here's where BloGTK begins its handling of multiple accounts. Each account is
         # placed into a ConfigParser section
         self.blogs = self.parser.sections()

      else:
         print "Creating New Config!"
         self.configFile = self.configDir + "/BloGTK.conf"
         self.parser = ConfigParser.ConfigParser()
         self.file = open(self.configFile, "w")

         self.parser.add_section("Default")
         self.parser.write(self.file)

         self.parser.set("Default", "server", "http://www.yoursite.com/blog/blog.cgi")
         self.parser.set("Default", "user", "username")
         self.parser.set("Default", "pass", "password")
         self.parser.set("Default", "system", "blogger")
         self.parser.set("Default", "font", "Sans 12")
      
         self.parser.set("Default", "Publish", "FALSE")
         self.parser.set("Default", "useUTF", "0")
         self.parser.set("Default", "retrievalNumber", "10")
      
         self.parser.write(self.file)
         self.blogs = self.parser.sections()
         self.file.close()

      # 0.9 - We also need to check for the creation of our 'proxies.conf' proxy
      # configuration file
      self.proxyConfig = self.configDir + "/proxies.conf"

      if os.path.isfile(self.configDir + "/proxies.conf") == 1:
         self.proxyParser = ConfigParser.ConfigParser()
         self.proxyFile = open(self.proxyConfig, "rw")
         self.proxyParser.readfp(self.proxyFile)
   
         self.fillProxyForm(self, foo)

      else:

         print "Creating new proxies.conf"
         self.proxyParser = ConfigParser.ConfigParser()
         self.proxyFile = open(self.proxyConfig, "w")
   
         self.proxyParser.add_section("Proxy")

         self.proxyParser.set("Proxy", "Option", "none")
         self.proxyParser.set("Proxy", "Server", "proxy.domain.com")
         self.proxyParser.set("Proxy", "Port", "8080")

         self.proxyParser.write(self.proxyFile)
         self.proxyFile.close()

         self.fillProxyForm(self, foo)

      self.accountsWindow.show()

      self.accountsCombo = self.mainGlade.get_widget("accountsCombo")

      # 0.7 - Whenever the combo box entry for the blogs list changes, we call the routine to
      # fill the form elements.
      self.mainGlade.signal_autoconnect({'on_accountsComboEntry_changed': self.fillForm})

      # 0.7 - Here's where we place the sections (blogs) into the combo box
      self.accountsCombo.set_popdown_strings(self.blogs)

      # 0.7 - Here's where we set our callbacks,
      self.accountsWindow.connect_object("delete_event", self.windowHider, self.accountsWindow)
      self.blogCancelButton.connect_object("clicked", self.windowHider, self.accountsWindow, foo)

      self.blogOKButton.connect_object("clicked", self.finishConfig, foo)

      self.blogFontsButton.connect_object("clicked", self.showFonts, foo)

      self.blogSaveButton.connect_object("clicked", self.saveAccount, foo)
      self.blogNewButton.connect_object("clicked", self.newAccount, foo)
      self.blogDeleteButton.connect_object("clicked", self.deleteAccount, foo)


      # 0.9 - Again, GTK keeps sending mutiple signals, requiring the old iterator trick yet again
      # so we can switch between multiple blogs. This is yet another hair-tearing bug...
      self.iterator = 1

   def fillForm(self, widget):

      self.section = self.accountsCombo.entry.get_text()

      try:
         self.url = self.parser.get(self.section, "server")
         self.user = self.parser.get(self.section, "user")
         self.passwd = self.parser.get(self.section, "pass")
         self.system = self.parser.get(self.section, "system")
   
         # 0.9 - We need to pull our General Settings from the config as well...
         self.defaultPublish = self.parser.get("Default", "defaultPublish")
         self.useUTF = self.parser.get("Default", "useutf")
         self.retrievalNumber = self.parser.get("Default", "retrievalNumber")

      except ConfigParser.NoSectionError:
         pass

      self.blogURLEntry.set_text(self.url)
      self.blogUserEntry.set_text(self.user)
      self.blogPassEntry.set_text(self.passwd)

      if self.system == "mt":
         self.blogRadioMT.set_active(gtk.TRUE)
      if self.system == "blogger":
         self.blogRadioBlogger.set_active(gtk.TRUE)
      if self.system == "metaweblog":
         self.blogRadioMW.set_active(gtk.TRUE)

      if self.defaultPublish == "1":
         self.defaultPublishCheck.set_active(gtk.TRUE)
      if self.defaultPublish == "0":
         self.defaultPublishCheck.set_active(gtk.FALSE)
      else:
         pass

      if self.useUTF == "1":
         self.useUTF8Check.set_active(gtk.TRUE)
      else:
         self.useUTF8Check.set_active(gtk.FALSE)

      number = float(self.retrievalNumber)

      self.retrievalSpin.set_value(number)

   def newAccount(self, foo):

      self.newAccountDialog = self.mainGlade.get_widget('newAccountDialog')
      self.newBlogCancelButton = self.mainGlade.get_widget('newBlogCancelButton')
      self.newBlogOKButton = self.mainGlade.get_widget('newBlogOKButton')

      self.newAccountDialog.show()

      self.newAccountDialog.connect_object("delete_event", self.windowHider, self.newAccountDialog)
      self.newBlogCancelButton.connect_object("clicked", self.windowHider, self.newAccountDialog, foo)
      self.newBlogOKButton.connect_object("clicked", self.makeNewBlog, foo)

   def makeNewBlog(self, foo):

      self.newBlogEntry = self.mainGlade.get_widget('newBlogEntry')

      self.newBlogName = self.newBlogEntry.get_text()

      if self.newBlogName == "server":
         errDialog = gtk.Dialog(title="Error", parent=self.newAccountDialog, flags=0)
         button2 = gtk.Button(stock=gtk.STOCK_OK)
         button2.connect_object("clicked", gtk.Widget.destroy, errDialog)
         errDialog.action_area.pack_start(button2, gtk.TRUE, gtk.TRUE, 0)
         button2.show()

         errLabel = gtk.Label("The name 'server' is reserved. Please select another.")
         errDialog.vbox.pack_start(errLabel, gtk.TRUE, gtk.TRUE, 2)

         errLabel.show()
         errDialog.show()

      else:

         try:
            self.parser.add_section(self.newBlogName)
            self.parser.set(self.newBlogName, "server", "")
            self.parser.set(self.newBlogName, "user", "")
            self.parser.set(self.newBlogName, "pass", "")
            self.parser.set(self.newBlogName, "system", "blogger")
            self.parser.set(self.newBlogName, "font", "Sans 12")

            self.writeFile = open(self.configFile, "w")

            self.parser.write(self.writeFile)
      
            self.writeFile.close()

            self.sections = self.parser.sections()
            self.accountsCombo.set_popdown_strings(self.sections)

            self.accountsCombo.entry.set_text(self.newBlogName)
            self.windowHider(self.newAccountDialog, foo)
            # self.newBlogEntry.set_text("")

         except ConfigParser.DuplicateSectionError:
            self.accountsCombo.entry.set_text(self.newBlogName)
            self.windowHider(self.newAccountDialog, foo)

   def saveAccount(self, foo):

      # 0.8 - Fixed problems with new account information not appearing after being saved.

      self.section = self.accountsCombo.entry.get_text()

      URL = self.blogURLEntry.get_text()
      user = self.blogUserEntry.get_text()
      passwd = self.blogPassEntry.get_text()
      font = self.fontEntry.get_text()

      self.parser.set(self.section, "server", URL)
      self.parser.set(self.section, "user", user)
      self.parser.set(self.section, "pass", passwd)
      self.parser.set(self.section, "font", font)

      if self.blogRadioMT.get_active() == gtk.TRUE:
         self.system = "mt"
      if self.blogRadioBlogger.get_active() == gtk.TRUE:
         self.system = "blogger"
      if self.blogRadioMW.get_active() == gtk.TRUE:
         self.system = "metaweblog"

      self.parser.set(self.section, "system", self.system)

      # 0.9 - Each time we save the form, we want to also save our general settings as well...

      if self.defaultPublishCheck.get_active() == gtk.TRUE:
         self.parser.set("Default", "defaultPublish", "1")
         self.defaultMainCheck.set_active(gtk.TRUE)
      else:
         self.parser.set("Default", "defaultPublish", "0")
         self.defaultMainCheck.set_active(gtk.FALSE)

      if self.useUTF8Check.get_active() == gtk.TRUE:
         self.parser.set("Default", "useUTF", "1")
      else:
         self.parser.set("Default", "useUTF", "0")

      number = self.retrievalSpin.get_value()

      num_string = str(number)

      self.parser.set("Default", "retrievalNumber", num_string)

      self.writeFile = open(self.configFile, "w")
      self.parser.write(self.writeFile)
      self.writeFile.close()

      sections = self.parser.sections()
      self.accountsCombo.set_popdown_strings(sections)

      self.accountsCombo.entry.set_text(self.section)

      self.fillForm(foo)


   def deleteAccount(self,foo):

      self.section = self.accountsCombo.entry.get_text()

      if self.section == "Default":
         errDialog = gtk.Dialog(title="Error", parent=self.accountsWindow, flags=0)
         button2 = gtk.Button(stock=gtk.STOCK_OK)
         button2.connect_object("clicked", gtk.Widget.destroy, errDialog)
         errDialog.action_area.pack_start(button2, gtk.TRUE, gtk.TRUE, 0)
         button2.show()

         errLabel = gtk.Label("You cannot delete the default account")
         errDialog.vbox.pack_start(errLabel, gtk.TRUE, gtk.TRUE, 2)

         errLabel.show()
         errDialog.show()

      else:

         self.parser.remove_option(self.section, "server")
         self.parser.remove_option(self.section, "user")
         self.parser.remove_option(self.section, "pass")
         self.parser.remove_option(self.section, "system")

      try:
         self.conf.remove_option(self.section, "font")
      except:
         pass

      self.parser.remove_section(self.section)

      file = open(self.configDir + "/BloGTK.conf", "w")
      self.parser.write(file)
      file.close()

      sections = self.parser.sections()
      self.accountsCombo.set_popdown_strings(sections)

   def showFonts(self, foo):

      self.fontDialog = self.mainGlade.get_widget('fontDialog')

      self.font_cancelButton = self.mainGlade.get_widget('cancel_button2')
      self.font_applyButton = self.mainGlade.get_widget('apply_button1')
      self.font_okButton = self.mainGlade.get_widget('ok_button2')

      self.fontDialog.show()

      self.fontDialog.connect_object("delete_event", self.windowHider, self.fontDialog)
      self.font_cancelButton.connect_object("clicked", self.windowHider, self.fontDialog, foo)
      self.font_applyButton.connect_object("clicked", self.applyFonts, foo)
      self.font_okButton.connect_object("clicked", self.setFonts, foo)

   def setFonts(self, foo):
      self.font = self.fontDialog.get_font_name()

      self.fontEntry.set_text(self.font)

      self.windowHider(self.fontDialog, foo)

   def applyFonts(self, foo):

      # 0.3 - Apply our font changes to the main window

      font = self.fontDialog.get_font_name()

      self.titleEntry = self.mainGlade.get_widget('titleEntry')
      self.bodyView = self.mainGlade.get_widget('bodyView')

      font_desc = pango.FontDescription(font)
      self.bodyView.modify_font(font_desc)
      self.titleEntry.modify_font(font_desc)

   def finishConfig(self, foo):      

      if self.iterator == 1:

         self.blogNameLabel = self.mainGlade.get_widget('blogNameLabel')
         self.blogName = self.accountsCombo.entry.get_text()

         self.blogNameLabel.set_text(self.blogName)

         # 0.95 - We also need to let the user know what blog account has been selected
         self.mainStatus = self.mainGlade.get_widget('mainStatus')

         self.mainStatus.push(1, "Blog account " + self.blogName + " has been selected. Use File/Connect to connect.")

         # 0.9 - We should save whatever current data is in the blog options as well to avoid
         # confusion
         self.saveAccount(foo)

         # 0.8-5 - Here's where we save our proxy information.
         self.saveProxyData(self, foo)

         # 0.7 - So things don't get confused, we'll clear out the blog and category
         # selectors until the user manually reconnects.

         blankset = [""]

         self.blogCombo = self.mainGlade.get_widget("blogCombo")
         self.catCombo = self.mainGlade.get_widget("catCombo")

         self.blogCombo.set_popdown_strings(blankset)
         self.catCombo.set_popdown_strings(blankset)

         self.iterator = self.iterator + 1

         self.windowHider(self.accountsWindow, foo)

      else:
         pass

   # 0.9 - These routines handle the interactions with the proxy section of our configuration
   # screen.

   def toggleProxyEntries(self, widget):

      if self.proxyButton_Custom.get_active() == gtk.TRUE:
         self.proxyAddressEntry.set_sensitive(gtk.TRUE)
	 self.proxyPortEntry.set_sensitive(gtk.TRUE)
      elif self.proxyButton_Custom.get_active() == gtk.FALSE:
         self.proxyAddressEntry.set_sensitive(gtk.FALSE)
	 self.proxyPortEntry.set_sensitive(gtk.FALSE)

   def fillProxyForm(self, foo, bar):

      port = self.proxyParser.get("Proxy", "port")
      host = self.proxyParser.get("Proxy", "server")
      option = self.proxyParser.get("Proxy", "option")

      self.proxyAddressEntry.set_text(host)
      self.proxyPortEntry.set_text(port)

      if option == "none":
         self.proxyButton_None.set_active(gtk.TRUE)
      if option == "system":
         self.proxyButton_System.set_active(gtk.TRUE)
      if option == "custom":
         self.proxyButton_Custom.set_active(gtk.TRUE)

   def saveProxyData(self, foo, bar):

      host = self.proxyAddressEntry.get_text()
      port = self.proxyPortEntry.get_text()

      if self.proxyButton_System.get_active() == gtk.TRUE:
         option = "system"
      if self.proxyButton_Custom.get_active() == gtk.TRUE:
         option = "custom"
      if self.proxyButton_None.get_active() == gtk.TRUE:
         option = "none"

      self.proxyParser = ConfigParser.ConfigParser()
      self.proxyFile = open(self.proxyConfig, "w")

      self.proxyParser.add_section("Proxy")

      self.proxyParser.set("Proxy", "Option", option)
      self.proxyParser.set("Proxy", "Server", host)
      self.proxyParser.set("Proxy", "Port", port)

      self.proxyParser.write(self.proxyFile)
      self.proxyFile.close()

   def windowHider(self, widget, foo):
      # Strike me down, and I'll become invisible like Obi-Wan did...
      widget.hide()
      return gtk.TRUE
