# -*- coding: utf-8 -*-

#  Bluemindo
#  functions.py

#    Bluemindo: A really simple but powerful audio player in Python/PyGTK.
#    Copyright (C) 2007-2008  Erwan Briand

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation version 3 of the License.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gobject import idle_add
from gtk import main_quit as gtk_main_quit
from md5 import new as md5_new
from os.path import join, isfile, isdir
from os import remove
import ConfigParser

from common.config import ConfigLoader

class Functions:
    def __init__(self):
        """Just set the data and the locale dir"""
        if isdir('../data') and isfile('../locale/bluemindo.pot'):
            self.datadir = '../data'
            self.localedir = '../locale'
        else:
            self.datadir = '/usr/share/bluemindo'
            self.localedir = '/usr/share/locale'

    def get_hash(self, str1, str2):
        """Just return the hash for given strings"""
        md5 = md5_new()
        md5.update(str1)
        md5.update(str2)
        
        return str(md5.hexdigest())

    def great_length(self, length):
        """Return the length in a human-readable way"""
        lg0 = length / 60
        lg1 = length % 60

        if lg0 >= 0 and lg0 < 10:
            lg0 = '0' + str(lg0)

        if lg1 >= 0 and lg1 < 10:
            lg1 = '0' + str(lg1)

        lg = str(lg0) + ':' + str(lg1)
        return lg

    def clear_bold(self, text):
        """Return the text without <b> and </b>"""
        if text.startswith('<b>') and text.endswith('</b>'):
            return text[3:-4]
        else:
            return text

    def open_bluemindo(self, window):
        """Handle the Bluemindo's window open and change width,
        height and position on the screen"""
        config = ConfigLoader()
        configfile = ConfigParser.ConfigParser()
        configfile_ = 'Bluemindo.cfg'
        conf_ = configfile.read(join(config.confdir, configfile_))

        try:
            width = configfile.get('Window', 'width')
            height = configfile.get('Window', 'height')
            x = configfile.get('Window', 'x')
            y = configfile.get('Window', 'y')

            window.resize(int(width), int(height))
            window.move(int(x), int(y))
        except ConfigParser.NoSectionError:
            pass

    def close_bluemindo(self, window, quit=True):
        """This function is called when the Bluemindo's main window is closed"""
        config = ConfigLoader()

        # Backup window width, height and position
        if window.get_properties('visible')[0]:
            configfile = ConfigParser.ConfigParser()
            _file_ = join(config.confdir, 'Bluemindo.cfg')
            configfile.read(_file_)

            width = window.get_size()[0]
            height = window.get_size()[1]
            x = window.get_position()[0]
            y = window.get_position()[1]

            if not configfile.has_section('Window'):
                configfile.add_section('Window')

            configfile.set('Audio', 'volume', configfile.get('Audio', 'volume'))

            configfile.set('Window', 'width', width)
            configfile.set('Window', 'height', height)
            configfile.set('Window', 'x', x)
            configfile.set('Window', 'y', y)

            configfile.write(open(_file_, 'w'))

        # Delete the socket file and quit GTK
        if quit:
            SOCKET_NAME = '/tmp/bluemindo'
            remove(SOCKET_NAME)

            current_playing = join(config.datadir, 'current-playing')
            if isfile(current_playing):
                remove(current_playing)

            print 'The dolphin has plunge!'
            idle_add(gtk_main_quit)
