# -*- coding: utf-8 -*-

#  Bluemindo
#  sqlite.py

#    Bluemindo: A really simple but powerful audio player in Python/PyGTK.
#    Copyright (C) 2007-2008  Erwan Briand

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation version 3 of the License.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

from os.path import join, exists

try:
    # Load sqlite3 (python 2.5)
	import sqlite3 as sqlite
except ImportError:
	try:
	    # Load pysqlite2 (python =< 2.4)
		from pysqlite2 import dbapi2 as sqlite
	except ImportError:
		raise SystemExit('This program needs sqlite bindings for python.')

from common.config import ConfigLoader
config = ConfigLoader()

class SQLite(object):
    def __init__(self): 
            sqlfile = join(config.datadir, 'bluemindo.db')
            if not exists(sqlfile):
                database_exist = False
            else:
                database_exist = True

            self.cx = sqlite.connect(sqlfile)
            self.cur = self.cx.cursor()

            # Seems to fix the issue #233:
            # http://www.codingteam.net/bluemindo-bugs-affiche-233.html
            self.cx.text_factory = str

            if not database_exist:
                self.execute('create table songs '
                             '('
                              'title text, '
                              'artist text, '
                              'album text, '
                              'track integer, '
                              'length integer, '
                              'genre text, '
                              'filename text, '
                              'reallength integer'
                             ')')

    def execute(self, sql, param=None):
        if param is not None:
            self.cur.execute(sql, param)
        else:
            self.cur.execute(sql)

        self.cx.commit()
        return self.cur

    def executemany(self, sql, param):
        self.cur.executemany(sql, param)

        self.cx.commit()
        return self.cur

    def fetchall(self, cur):
        return cur.fetchall()

    def close(self):
        self.cur.close()
        self.cx.close()
