# -*- coding: utf-8 -*-

#  Bluemindo (Base modules)
#  trayicon.py

#    Bluemindo: A really simple but powerful audio player in Python/PyGTK.
#    Copyright (C) 2007-2008  Erwan Briand

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation version 3 of the License.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gettext import gettext as _
from gtk.glade import XML as glade_XML
from gtk import status_icon_new_from_file

from common.functions import Functions

class Trayicon:
    def __init__(self, module):   
        self.module = {'name': 'Trayicon',
                       'logo': None,
                       'configurable': False}
                          
        self.instance_module = module

        module.connect('OnBluemindoStarted', self.loadmodule)
        module.connect('OnBluemindoWindowClosed', self.on_window_close)
        
        self.functions = Functions()

    def loadmodule(self, glade):
        # Add Bluemindo's icon to the tray
        self.window = glade.get_widget('window1')
    
        gti = status_icon_new_from_file(
              self.functions.datadir + '/image/logo_head_small.png')
        gti.set_tooltip(_('Bluemindo music player'))
        gti.connect('popup-menu', self.tray_icon_menu)
        gti.connect('activate', self.tray_icon_click)
        
        self.instance_module.load_event('OnStatusIconAnswer', gti)

    def hideshow(self):
        # Hide or show Bluemindo's main window
        if self.window.get_properties('visible')[0]:
            self.functions.close_bluemindo(self.window, False)
            self.window.hide()
        elif not self.window.get_properties('visible')[0]:
            self.window.show()
            self.functions.open_bluemindo(self.window)

    def tray_icon_click(self, status_icon):
        self.hideshow()

    def on_window_close(self):
        self.hideshow()

    def on_quit_activate(self, widget):
        # Quit Bluemindo :'(
        self.instance_module.load_event('OnBluemindoQuitted')
        self.functions.close_bluemindo(self.window)
        
    def tray_icon_menu(self, status_icon, button, activate_time):
        # Create the right-click menu on the trayicon
        widget = glade_XML('modules/trayicon/traycontext.glade', 'menu1',
                           domain='bluemindo')
        widget.get_widget('menu1').popup(None, None, None, button,
                                         activate_time)
        widget.get_widget('tray-bluemindo').connect('activate',
                                                    self.tray_icon_click)
        widget.get_widget('tray-quit').connect('activate',
                                               self.on_quit_activate)
        
        widget.get_widget('menu-play').connect('activate', self.on_play)
        widget.get_widget('menu-previous').connect('activate', self.on_previous)
        widget.get_widget('menu-next').connect('activate', self.on_next)

    def on_play(self, wdg):
        self.instance_module.load_event('OnPlayPressed')

    def on_previous(self, wdg):
        self.instance_module.load_event('OnPreviousPressed')

    def on_next(self, wdg):
        self.instance_module.load_event('OnNextPressed')
