# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gtk.glade import XML as glade_XML
from os.path import join

from common.functions import Functions

functions = Functions()

class ErrorBox(object):
    def __init__(self, title='Error.', text=''):
        glade_file = join(functions.datadir, 'glade', 'boxes.glade')
        box = glade_XML(glade_file, 'errorbox')

        box_wdg = box.get_widget('errorbox')
        box_wdg.set_title(title)
        box_wdg.set_markup(text)

        box_wdg.run()
        box_wdg.destroy()

class DialogBox(object):
    def __init__(self, title='Question.', text=''):
        glade_file = join(functions.datadir, 'glade', 'boxes.glade')
        box = glade_XML(glade_file, 'dialogbox')

        box_wdg = box.get_widget('dialogbox')
        box_wdg.set_title(title)
        box.get_widget('label1').set_markup(text)

        self.val = box_wdg.run()
        box_wdg.destroy()

    def get_answer(self):
        return self.val