/*
*
*  A2DPD - Bluetooth A2DP daemon for Linux
*
*  Copyright (C) 2006-2007  Frédéric DALLEAU <frederic.dalleau@palmsource.com>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef A2DPD_TOOLS_H
#define A2DPD_TOOLS_H

#include <bluetooth/bluetooth.h>
#include <bluetooth/rfcomm.h>
#include <bluetooth/l2cap.h>
#include <bluetooth/sdp.h>
#include <bluetooth/sdp_lib.h>
#include <bluetooth/sco.h>

#define safefree(buf) do { if(buf) { myfree(buf, __LINE__); (buf) = NULL; } } while (0)
#define checkbuffer(buf) checkbuffer__(buf, __LINE__)

void* mymalloc(int size);
void myfree(void* p, int line);
int checkbuffer__(void* p, int line);
void ignore_child_processes_return_values();
void make_daemon_process(int bFork, int bVerbose, char *output_file_name);
int lockfile(int bKill);
void unlockfile(int lockfd);
sdp_session_t *sdp_connect_async(const bdaddr_t *dst);
void dump_raw(const char* data, int size);
void dump_stream(const short* data, int size);

#endif

