/*
*
*  A2DPD - Bluetooth A2DP daemon for Linux
*
*  Copyright (C) 2006-2007  Frédéric DALLEAU <frederic.dalleau@palmsource.com>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef A2DPD_DBUS_H
#define A2DPD_DBUS_H

#include <sys/poll.h>
#include "a2dpd_ipc.h"

enum { STARTED, ENDED, DISCONNECTED, CONNECTING, CONNECTED };

extern void a2dpd_signal_state(int state, char* bdaddr);
extern void a2dpd_signal_init(int session_bus);
extern void a2dpd_signal_set_socket(int a2dpd_ctl_socket);
extern void a2dpd_signal_kill();
extern void a2dpd_signal_command(char* dir, char* cmd);
extern void a2dpd_signal_add_fd_to_poll(struct pollinfo* pollinfos);
extern void a2dpd_signal_state_machine();
extern void a2dpd_signal_address_changed(char* cur_addr);
extern int write_config_string(char *filename, char *section, char *key, char *value);

#endif

