/*
 *
 *  Bluetooth low-complexity, subband codec (SBC) library
 *
 *  Copyright (C) 2004  Marcel Holtmann <marcel@holtmann.org>
 *  Copyright (C) 2004  Henryk Ploetz <henryk@ploetzli.ch>
 *
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __SBC_TABLES_H
#define __SBC_TABLES_H

#include "sbc_math.h"

/* A2DP specification: Appendix B, page 69 */
static const int sbc_offset4[4][4] = {
	{ -1, 0, 0, 0 },
	{ -2, 0, 0, 1 },
	{ -2, 0, 0, 1 },
	{ -2, 0, 0, 1 }
};

/* A2DP specification: Appendix B, page 69 */
static const int sbc_offset8[4][8] = {
	{ -2, 0, 0, 0, 0, 0, 0, 1 },
	{ -3, 0, 0, 0, 0, 0, 1, 2 },
	{ -4, 0, 0, 0, 0, 0, 1, 2 },
	{ -4, 0, 0, 0, 0, 0, 1, 2 }
};

/* A2DP specification: Appendix B, page 70 */
static const float sbc_proto_4_40[40] = {
	 0.00000000E+00,  5.36548976E-04,  1.49188357E-03,  2.73370904E-03,
	 3.83720193E-03,  3.89205149E-03,  1.86581691E-03, -3.06012286E-03,
	 1.09137620E-02,  2.04385087E-02,  2.88757392E-02,  3.21939290E-02,
	 2.58767811E-02,  6.13245186E-03, -2.88217274E-02, -7.76463494E-02,
	 1.35593274E-01,  1.94987841E-01,  2.46636662E-01,  2.81828203E-01,
	 2.94315332E-01,  2.81828203E-01,  2.46636662E-01,  1.94987841E-01,
	-1.35593274E-01, -7.76463494E-02, -2.88217274E-02,  6.13245186E-03,
	 2.58767811E-02,  3.21939290E-02,  2.88757392E-02,  2.04385087E-02,
	-1.09137620E-02, -3.06012286E-03,  1.86581691E-03,  3.89205149E-03,
	 3.83720193E-03,  2.73370904E-03,  1.49188357E-03,  5.36548976E-04
};

/* The table above with every term multiplied by -4.0 */
static const float sbc_proto_4_40m[] = {
        -0.00000000E+00, -2.14619585E-03, -5.96753415E-03, -1.09348362E-02,
        -1.53488079E-02, -1.55682061E-02, -7.46326754E-03,  1.22404918E-02,
        -4.36550491E-02, -8.17540362E-02, -1.15502954E-01, -1.28775716E-01,
        -1.03507124E-01, -2.45298073E-02,  1.15286909E-01,  3.10585409E-01,
        -5.42373121E-01, -7.79951394E-01, -9.86546636E-01, -1.12731278E+00,
        -1.17726135E+00, -1.12731278E+00, -9.86546636E-01, -7.79951394E-01,
         5.42373121E-01,  3.10585409E-01,  1.15286909E-01, -2.45298073E-02,
        -1.03507124E-01, -1.28775716E-01, -1.15502954E-01, -8.17540362E-02,
         4.36550491E-02,  1.22404918E-02, -7.46326754E-03, -1.55682061E-02,
        -1.53488079E-02, -1.09348362E-02, -5.96753415E-03, -2.14619585E-03,
};
#if 0
/* A2DP specification: Appendix B, page 70 */
static const float sbc_proto_8_80[80] = {
	 0.00000000E+00,  1.56575398E-04,  3.43256425E-04,  5.54620202E-04,
	 8.23919506E-04,  1.13992507E-03,  1.47640169E-03,  1.78371725E-03,
	 2.01182542E-03,  2.10371989E-03,  1.99454554E-03,  1.61656283E-03,
	 9.02154502E-04, -1.78805361E-04, -1.64973098E-03, -3.49717454E-03,
	 5.65949473E-03,  8.02941163E-03,  1.04584443E-02,  1.27472335E-02,
	 1.46525263E-02,  1.59045603E-02,  1.62208471E-02,  1.53184106E-02,
	 1.29371806E-02,  8.85757540E-03,  2.92408442E-03, -4.91578024E-03,
	-1.46404076E-02, -2.61098752E-02, -3.90751381E-02, -5.31873032E-02,
	 6.79989431E-02,  8.29847578E-02,  9.75753918E-02,  1.11196689E-01,
	 1.23264548E-01,  1.33264415E-01,  1.40753505E-01,  1.45389847E-01,
	 1.46955068E-01,  1.45389847E-01,  1.40753505E-01,  1.33264415E-01,
	 1.23264548E-01,  1.11196689E-01,  9.75753918E-02,  8.29847578E-02,
	-6.79989431E-02, -5.31873032E-02, -3.90751381E-02, -2.61098752E-02,
	-1.46404076E-02, -4.91578024E-03,  2.92408442E-03,  8.85757540E-03,
	 1.29371806E-02,  1.53184106E-02,  1.62208471E-02,  1.59045603E-02,
	 1.46525263E-02,  1.27472335E-02,  1.04584443E-02,  8.02941163E-03,
	-5.65949473E-03, -3.49717454E-03, -1.64973098E-03, -1.78805361E-04,
	 9.02154502E-04,  1.61656283E-03,  1.99454554E-03,  2.10371989E-03,
	 2.01182542E-03,  1.78371725E-03,  1.47640169E-03,  1.13992507E-03,
	 8.23919506E-04,  5.54620202E-04,  3.43256425E-04,  1.56575398E-04
};

/* The table above with every term multiplied by -8.0 */
static const float sbc_proto_8_80m[] = {
        -0.00000000E+00, -1.25260314E-03, -2.74605141E-03, -4.43696184E-03,
        -6.59135589E-03, -9.11940075E-03, -1.18112136E-02, -1.42697385E-02,
        -1.60946026E-02, -1.68297589E-02, -1.59563646E-02, -1.29325027E-02,
        -7.21723586E-03,  1.43044291E-03,  1.31978476E-02,  2.79773958E-02,
        -4.52759564E-02, -6.42352924E-02, -8.36675540E-02, -1.01977870E-01,
        -1.17220208E-01, -1.27236485E-01, -1.29766777E-01, -1.22547284E-01,
        -1.03497446E-01, -7.08606020E-02, -2.33926754E-02,  3.93262431E-02,
         1.17123261E-01,  2.08879009E-01,  3.12601119E-01,  4.25498426E-01,
        -5.43991566E-01, -6.63878083E-01, -7.80603111E-01, -8.89573514E-01,
        -9.86116409E-01, -1.06611538E+00, -1.12602806E+00, -1.16311872E+00,
        -1.17564058E+00, -1.16311872E+00, -1.12602806E+00, -1.06611538E+00,
        -9.86116409E-01, -8.89573514E-01, -7.80603111E-01, -6.63878083E-01,
         5.43991566E-01,  4.25498426E-01,  3.12601119E-01,  2.08879009E-01,
         1.17123261E-01,  3.93262431E-02, -2.33926754E-02, -7.08606020E-02,
        -1.03497446E-01, -1.22547284E-01, -1.29766777E-01, -1.27236485E-01,
        -1.17220208E-01, -1.01977870E-01, -8.36675540E-02, -6.42352924E-02,
         4.52759564E-02,  2.79773958E-02,  1.31978476E-02,  1.43044291E-03,
        -7.21723586E-03, -1.29325027E-02, -1.59563646E-02, -1.68297589E-02,
        -1.60946026E-02, -1.42697385E-02, -1.18112136E-02, -9.11940075E-03,
        -6.59135589E-03, -4.43696184E-03, -2.74605141E-03, -1.25260314E-03,
};
#endif
// alternating blocks of 8 from 80m[]
static const float sbc_proto_8_80m0[] = {
        -0.00000000E+00, -1.25260314E-03, -2.74605141E-03, -4.43696184E-03,
        -6.59135589E-03, -9.11940075E-03, -1.18112136E-02, -1.42697385E-02,
        -4.52759564E-02, -6.42352924E-02, -8.36675540E-02, -1.01977870E-01,
        -1.17220208E-01, -1.27236485E-01, -1.29766777E-01, -1.22547284E-01,
        -5.43991566E-01, -6.63878083E-01, -7.80603111E-01, -8.89573514E-01,
        -9.86116409E-01, -1.06611538E+00, -1.12602806E+00, -1.16311872E+00,
         5.43991566E-01,  4.25498426E-01,  3.12601119E-01,  2.08879009E-01,
         1.17123261E-01,  3.93262431E-02, -2.33926754E-02, -7.08606020E-02,
         4.52759564E-02,  2.79773958E-02,  1.31978476E-02,  1.43044291E-03,
        -7.21723586E-03, -1.29325027E-02, -1.59563646E-02, -1.68297589E-02,
};

// alternatving blocks of 8 from 80m[] (odds)
static const float sbc_proto_8_80m1[] = {
        -1.60946026E-02, -1.68297589E-02, -1.59563646E-02, -1.29325027E-02,
        -7.21723586E-03,  1.43044291E-03,  1.31978476E-02,  2.79773958E-02,
        -1.03497446E-01, -7.08606020E-02, -2.33926754E-02,  3.93262431E-02,
         1.17123261E-01,  2.08879009E-01,  3.12601119E-01,  4.25498426E-01,
        -1.17564058E+00, -1.16311872E+00, -1.12602806E+00, -1.06611538E+00,
        -9.86116409E-01, -8.89573514E-01, -7.80603111E-01, -6.63878083E-01,
        -1.03497446E-01, -1.22547284E-01, -1.29766777E-01, -1.27236485E-01,
        -1.17220208E-01, -1.01977870E-01, -8.36675540E-02, -6.42352924E-02,
        -1.60946026E-02, -1.42697385E-02, -1.18112136E-02, -9.11940075E-03,
        -6.59135589E-03, -4.43696184E-03, -2.74605141E-03, -1.25260314E-03,
};

/* Precomputed: synmatrix4[k][i] = cos( (i+0.5) * (k+2.0) * pi/4.0 ) */
static const float synmatrix4[8][4] =  {
	{  0.707106781186548, -0.707106781186547, -0.707106781186548,  0.707106781186547 },
	{  0.38268343236509,  -0.923879532511287,  0.923879532511287, -0.38268343236509  },
	{  0,                  0,                  0,                  0                 },
	{ -0.38268343236509,   0.923879532511287, -0.923879532511287,  0.382683432365091 },
	{ -0.707106781186547,  0.707106781186548,  0.707106781186547, -0.707106781186547 },
	{ -0.923879532511287, -0.38268343236509,   0.382683432365091,  0.923879532511288 },
	{ -1,                 -1,                 -1,                 -1                 },
	{ -0.923879532511287, -0.382683432365091,  0.38268343236509,   0.923879532511287 }
};

/* Precomputed: synmatrix8[k][i] = cos( (i+0.5) * (k+4.0) * pi/8.0 ) */
static const float synmatrix8[16][8] = {
	{  0.707106781186548, -0.707106781186547, -0.707106781186548,  0.707106781186547,
	   0.707106781186548, -0.707106781186547, -0.707106781186547,  0.707106781186547 },
	{  0.555570233019602, -0.98078528040323,   0.195090322016128,  0.831469612302545,
	  -0.831469612302545, -0.195090322016128,  0.980785280403231, -0.555570233019602 },
	{  0.38268343236509,  -0.923879532511287,  0.923879532511287, -0.38268343236509,
	  -0.382683432365091,  0.923879532511287, -0.923879532511286,  0.38268343236509  },
	{  0.195090322016128, -0.555570233019602,  0.831469612302545, -0.980785280403231,
	   0.98078528040323,  -0.831469612302545,  0.555570233019602, -0.195090322016129 },
	{  0,                  0,                  0,                  0,
	   0,                  0,                  0,                  0                 },
	{ -0.195090322016128,  0.555570233019602, -0.831469612302545,  0.98078528040323,
	  -0.980785280403231,  0.831469612302545, -0.555570233019603,  0.19509032201613  },
	{ -0.38268343236509,   0.923879532511287, -0.923879532511287,  0.382683432365091,
	   0.38268343236509,  -0.923879532511287,  0.923879532511288, -0.382683432365091 },
	{ -0.555570233019602,  0.98078528040323,  -0.195090322016128, -0.831469612302545,
	   0.831469612302545,  0.195090322016128, -0.98078528040323,   0.555570233019606 },
	{ -0.707106781186547,  0.707106781186548,  0.707106781186547, -0.707106781186547,
	  -0.707106781186546,  0.707106781186548,  0.707106781186546, -0.707106781186548 },
	{ -0.831469612302545,  0.195090322016129,  0.980785280403231,  0.555570233019602,
	  -0.555570233019603, -0.98078528040323,  -0.195090322016128,  0.831469612302547 },
	{ -0.923879532511287, -0.38268343236509,   0.382683432365091,  0.923879532511288,
	   0.923879532511287,  0.382683432365089, -0.382683432365091, -0.923879532511287 },
	{ -0.98078528040323,  -0.831469612302545, -0.555570233019602, -0.195090322016129,
	   0.19509032201613,   0.555570233019606,  0.831469612302547,  0.980785280403231 },
	{ -1,                 -1,                 -1,                 -1,
	  -1,                 -1,                 -1,                 -1                 },
	{ -0.98078528040323,  -0.831469612302546, -0.555570233019603, -0.19509032201613,
	   0.195090322016128,  0.555570233019604,  0.831469612302545,  0.98078528040323  },
	{ -0.923879532511287, -0.382683432365091,  0.38268343236509,   0.923879532511287,
	   0.923879532511288,  0.382683432365088, -0.382683432365089, -0.923879532511285 },
	{ -0.831469612302545,  0.195090322016127,  0.98078528040323,   0.555570233019603,
	  -0.555570233019601, -0.98078528040323,  -0.195090322016131,  0.831469612302545 }
};

/* Precomputed: anamatrix4[i][k] = cos( (i+0.5) * (k-2) * pi/4 ) */
static const float anamatrix4[4][8] = {
	{  0.707106781186548,  0.923879532511287,  1,                  0.923879532511287,
	   0.707106781186548,  0.38268343236509,   0,                 -0.38268343236509  },
	{ -0.707106781186547,  0.38268343236509,   1,                  0.38268343236509,
	  -0.707106781186547, -0.923879532511287,  0,                  0.923879532511287 },
	{ -0.707106781186548, -0.38268343236509,   1,                 -0.38268343236509,
	  -0.707106781186548,  0.923879532511287,  0,                 -0.923879532511287 },
	{  0.707106781186547, -0.923879532511287,  1,                 -0.923879532511287,
	   0.707106781186547, -0.38268343236509,   0,                  0.382683432365091 }
};

/* Precomputed: anamatrix8[i][k] = cos( (i+0.5) * (k-4) * pi/8) */
static const float anamatrix8[8][16] = {
	{  0.923879532511287,  0.98078528040323,   1,                  0.98078528040323,
	   0.923879532511287,  0.831469612302545,  0.707106781186548,  0.555570233019602,
	   0.38268343236509,   0.195090322016128,  0,                 -0.195090322016128,
	  -0.38268343236509,  -0.555570233019602, -0.707106781186547, -0.831469612302545 },
	{  0.38268343236509,   0.831469612302545,  1,                  0.831469612302545,
	   0.38268343236509,  -0.195090322016128, -0.707106781186547, -0.98078528040323,
	  -0.923879532511287, -0.555570233019602,  0,                  0.555570233019602,
	   0.923879532511287,  0.98078528040323,   0.707106781186548,  0.195090322016129 },
	{ -0.38268343236509,   0.555570233019602,  1,                  0.555570233019602,
	  -0.38268343236509,  -0.98078528040323,  -0.707106781186548,  0.195090322016128,
	   0.923879532511287,  0.831469612302545,  0,                 -0.831469612302545,
	  -0.923879532511287, -0.195090322016128,  0.707106781186547,  0.980785280403231 },
	{ -0.923879532511287,  0.195090322016128,  1,                  0.195090322016128,
	  -0.923879532511287, -0.555570233019602,  0.707106781186547,  0.831469612302545,
	  -0.38268343236509,  -0.980785280403231,  0,                  0.98078528040323,
	   0.382683432365091, -0.831469612302545, -0.707106781186547,  0.555570233019602 },
	{ -0.923879532511287, -0.195090322016128,  1,                 -0.195090322016128,
	  -0.923879532511287,  0.555570233019602,  0.707106781186548, -0.831469612302545,
	  -0.382683432365091,  0.98078528040323,   0,                 -0.980785280403231,
	   0.38268343236509,   0.831469612302545, -0.707106781186546, -0.555570233019603 },
	{ -0.38268343236509,  -0.555570233019602,  1,                 -0.555570233019602,
	  -0.38268343236509,   0.98078528040323,  -0.707106781186547, -0.195090322016128,
	   0.923879532511287, -0.831469612302545,  0,                  0.831469612302545,
	  -0.923879532511287,  0.195090322016128,  0.707106781186548, -0.98078528040323  },
	{  0.38268343236509,  -0.831469612302545,  1,                 -0.831469612302545,
	   0.38268343236509,   0.195090322016129, -0.707106781186547,  0.980785280403231,
	  -0.923879532511286,  0.555570233019602,  0,                 -0.555570233019603,
	   0.923879532511288, -0.98078528040323,   0.707106781186546, -0.195090322016128 },
	{  0.923879532511287, -0.98078528040323,   1,                 -0.98078528040323,
	   0.923879532511287, -0.831469612302545,  0.707106781186547, -0.555570233019602,
	   0.38268343236509,  -0.195090322016129,  0,                  0.19509032201613,
	  -0.382683432365091,  0.555570233019606, -0.707106781186548,  0.831469612302547 }
};

#ifdef USE_FIXED

#ifdef USE_FIXED32

#define SP4(val) (val >> SCALE_PROTO4_TBL)
#define SA4(val) (val >> SCALE_ANA4_TBL)
#define SP8(val) (val >> SCALE_PROTO8_TBL)
#define SA8(val) (val >> SCALE_ANA8_TBL)

#else // USE_FIXED32

#define SP4(val) (val)
#define SA4(val) (val)
#define SP8(val) (val)
#define SA8(val) (val)

#endif // USE_FIXED32

static const int32_t _sbc_proto_4[20] = {
	SP4(0x02cb3e8c), SP4(0x22b63dc0), SP4(0x002329cc), SP4(0x053b7548), SP4(0x31eab940), SP4(0xec1f5e60), SP4(0xff3773a8), SP4(0x0061c5a7),
	SP4(0x07646680), SP4(0x3f239480), SP4(0xf89f23a8), SP4(0x007a4737), SP4(0x00b32807), SP4(0x083ddc80), SP4(0x4825e480), SP4(0x0191e578),
	SP4(0x00ff11ca), SP4(0x00fb7991), SP4(0x069fdc58), SP4(0x4b584000)
};

static const int32_t  _anamatrix4[4] = {
	SA4(0x2d413cc0), SA4(0x3b20d780), SA4(0x40000000), SA4(0x187de2a0)
};

static const int32_t _sbc_proto_8[40] = {
	SP8(0x02e5cd20), SP8(0x22d0c200), SP8(0x006bfe27), SP8(0x07808930), SP8(0x3f1c8800), SP8(0xf8810d70), SP8(0x002cfdc6), SP8(0x055acf28),
	SP8(0x31f566c0), SP8(0xebfe57e0), SP8(0xff27c437), SP8(0x001485cc), SP8(0x041c6e58), SP8(0x2a7cfa80), SP8(0xe4c4a240), SP8(0xfe359e4c),
	SP8(0x0048b1f8), SP8(0x0686ce30), SP8(0x38eec5c0), SP8(0xf2a1b9f0), SP8(0xffe8904a), SP8(0x0095698a), SP8(0x0824a480), SP8(0x443b3c00),
	SP8(0xfd7badc8), SP8(0x00d3e2d9), SP8(0x00c183d2), SP8(0x084e1950), SP8(0x4810d800), SP8(0x017f43fe), SP8(0x01056dd8), SP8(0x00e9cb9f),
	SP8(0x07d7d090), SP8(0x4a708980), SP8(0x0488fae8), SP8(0x0113bd20), SP8(0x0107b1a8), SP8(0x069fb3c0), SP8(0x4b3db200), SP8(0x00763f48)
};

static const int32_t _anamatrix8[8] = {
	SA8(0x3b20d780), SA8(0x187de2a0), SA8(0x3ec52f80), SA8(0x3536cc40), SA8(0x238e7680), SA8(0x0c7c5c20), SA8(0x2d413cc0), SA8(0x40000000)
};

#else // USE_FIXED

static const float _anamatrix4[4] = {
	0.707106769084930, 0.923879504203796, 1.000000000000000, 0.382683426141739
};

static const float _sbc_proto_4[20] = {
	1.09137623e-02,	1.35593280e-01,	5.36548963e-04,	2.04385091e-02,	1.94987848e-01,	-7.76463524e-02,
	-3.06012295e-03, 1.49188354e-03, 2.88757384e-02, 2.46636659e-01, -2.88217273e-02, 1.86581688e-03,
	2.73370906e-03,	3.21939290e-02,	2.81828195e-01,	6.13245182e-03,	3.89205152e-03,	3.83720198e-03,
	2.58767810e-02,	2.94315338e-01
};

static const float _anamatrix8[8] = {
	0.923879532511287, 0.382683432365091, 0.980785280403231, 0.831469612302547, 0.555570233019602,
	0.195090322016128, 0.707106781186547, 1.000000000000000
};

static const float _sbc_proto_8[40] = {
	5.65949455E-03, 6.79989457E-02, 8.23919487E-04, 1.46525260E-02, 1.23264551E-01,-1.46404076E-02,
	3.43256426E-04, 1.04584442E-02, 9.75753888E-02, -3.90751399E-02, -1.64973096E-03, 1.56575392E-04,
	8.02941155E-03, 8.29847604E-02, -5.31873032E-02, -3.49717448E-03, 5.54620230E-04, 1.27472337E-02,
	1.11196689E-01, -2.61098761E-02, -1.78805363E-04, 1.13992509E-03, 1.59045607E-02, 1.33264422E-01,
	-4.91578039E-03, 1.61656283E-03, 1.47640170E-03, 1.62208471E-02, 1.40753508E-01, 2.92408443E-03,
	1.99454557E-03, 1.78371731E-03, 1.53184105E-02, 1.45389840E-01, 8.85757525E-03, 2.10371986E-03,
	2.01182533E-03, 1.29371807E-02, 1.46955073E-01, 9.02154483E-04
};
#endif // USE_FIXED

#endif /* __SBC_TABLES_H */

