#include <math.h>
#include "sbc.h"
#include "sbc_tables.h"

struct {
	char *name;
	void *ref;
	int i;
	int j;
	int bits;
	char* scalestr;
} tables[] = {
	//{"sbc_proto_4_40_f", (void *)sbc_proto_4_40, 40, 1, 28},
	//{"sbc_proto_8_80_f", (void *)sbc_proto_8_80, 80, 1, 28},
// 	{"synmatrix4_f", (void *)synmatrix4, 8, 4, 28},
// 	{"synmatrix8_f", (void *)synmatrix8, 16, 8, 28},
	//{"anamatrix4_f", (void *)anamatrix4, 4, 8, 28},
	{"_sbc_proto_4", (void *)_sbc_proto_4, 20, 1, 32, "SP4"},
	{"_anamatrix4", (void *)_anamatrix4, 4, 1, 30, "SA4"},
	{"_sbc_proto_8", (void *)_sbc_proto_8, 40, 1, 33, "SP8"},
	{"_anamatrix8", (void *)_anamatrix8, 8, 1, 30, "SA8"},
	{0, 0, 0, 0}
};

int main(int argc, char **argv) {
	int entry, i, j, idx;
	float *array;
#if 0
	printf("static const float sbc_proto_4_40m[] = {\n");
	for(i=0; i<40; i++) {
		if(i%4 == 0) printf("\n\t");
		printf("%1.8E, ", -4. * sbc_proto_4_40[i]);
	}
	printf("\n};");
#endif
	for(entry = 0; tables[entry].name; entry++) {
		if(tables[entry].j == 1) {
			if (tables[entry].ref == (void *)_sbc_proto_8 || tables[entry].ref == (void *)_anamatrix8) {
				printf("static const int32_t %s[%d] = {\n",
				       tables[entry].name, tables[entry].i);
			}
			else
				printf("static const sbc_fixed_t %s[%d] = {\n",
				       tables[entry].name, tables[entry].i);
			array = (float *)tables[entry].ref;
			for(i = 0; i < tables[entry].i; i++) {
				if(i>0) {
					printf(", ");
					if(i%8 == 0) printf("\n");
				}
				double res = array[i]*pow(2, tables[entry].bits);
				if (res > 0 )
					res += 0.5;
				else
					res += -0.5;
				if (fabs(res) > (double)(0xFFFFFFFF / 2.0)) {
					printf("OVERFLOW (%f)!\n", res);
					exit(1);
				}
				if (tables[entry].scalestr)
					printf("%s(0x%08x)", tables[entry].scalestr, (int32_t)res);
				else
					printf("0x%08x", (int32_t)res);
			}
			printf("\n};\n\n");
		} else {
			printf("static const sbc_fixed_t %s[%d][%d] = {\n",
			       tables[entry].name, tables[entry].i, tables[entry].j);
			array = (float *)tables[entry].ref;
			idx = 0;
			for(i = 0; i < tables[entry].i; i++) {
				if(i>0) printf(",\n");
				printf("{ ");
				for(j = 0; j < tables[entry].j; j++) {
					if(j>0) {
						printf(", ");
						if(j%8 == 0) printf("\n");
					}
					double res = array[idx++]*pow(2, tables[entry].bits);
					if (res > 0 )
						res += 0.5;
					else
						res += -0.5;
					if (fabs(res) > (double)(0xFFFFFFFF / 2.0)) {
						printf("OVERFLOW (%f)!\n", res);
						exit(1);
					}
					printf("0x%08x", (int32_t)res);
				}
				printf(" }");
			}
			printf("\n};\n\n");
		}
	}
}
