#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>

#include <taglib/fileref.h>
#include <glibmm.h>

// Plugin-specific include
#include <taglib/taglib.h>
#include <taglib/fileref.h>
#include <taglib/tfile.h>
#include <taglib/tag.h>

#include <taglib/id3v2tag.h>
#include <taglib/mpegfile.h>
#include <taglib/id3v2framefactory.h>
#include <taglib/textidentificationframe.h>
#include <taglib/uniquefileidentifierframe.h>

#include <boost/format.hpp>
static boost::format fsizefmt ("%llu");

extern "C" int  _plugin_has_accessors;
int _plugin_has_accessors = 1;

#include <bmp/database_types.hh>
#include <bmp/library_types.hh>
#include <src/util_string.hh>

namespace
{
  // Based on SoundJuicer code, (C) Ross Burton <ross@burtonini.com> 
  void
  add_txxx_tag (TagLib::ID3v2::Tag    * id3v2tag,
                Glib::ustring const&    spec_id,
                Glib::ustring const&    realworld_id,
                Glib::ustring const&    idstring) 
  {
    using namespace Bmp;
    using namespace TagLib;

    ID3v2::UserTextIdentificationFrame * frame;

    if (idstring.empty()) return;

    if (!spec_id.empty())
    {
      id3v2tag->removeFrames (spec_id.c_str());
      frame = new ID3v2::UserTextIdentificationFrame (String::UTF8);
      id3v2tag->addFrame (frame);
      frame->setDescription (String (spec_id.c_str(), String::UTF8));
      frame->setText (String (idstring.c_str(), String::UTF8));
    }

    if (!realworld_id.empty())
    {
      id3v2tag->removeFrames (realworld_id.c_str());
      frame = new ID3v2::UserTextIdentificationFrame (String::UTF8);
      id3v2tag->addFrame (frame);
      frame->setDescription (String (realworld_id.c_str(), String::UTF8));
      frame->setText (String (idstring.c_str(), String::UTF8));
    }
  }
}

extern "C" bool _set (std::string const& name, Bmp::Library::UTrack & track)
{
  using namespace Bmp::Library;
  using namespace TagLib;

  ID3v2::FrameFactory *factory = ID3v2::FrameFactory::instance();
  factory->setDefaultTextEncoding (String::UTF8);

  MPEG::File opfile (name.c_str(), factory);

  if (!(opfile.isOpen() && opfile.isValid()))
    return false; 

  opfile.strip ();

  ID3v2::Tag * tag = opfile.ID3v2Tag (true);
  if (!tag)  
    return false;

  Bmp::Library::metadata_set_common (track, tag);

  if (track.mb_album_artist)
    {
      add_txxx_tag (tag,
                    Bmp::MetadatumDefine(DATUM_MB_ALBUM_ARTIST).title,
                    Bmp::MetadatumDefine(DATUM_MB_ALBUM_ARTIST).id,
                    track.mb_album_artist.get());
    }

  if (track.mb_album_artist_id)
    {
      add_txxx_tag (tag,
                    Bmp::MetadatumDefine(DATUM_MB_ALBUM_ARTIST_ID).title,
                    Bmp::MetadatumDefine(DATUM_MB_ALBUM_ARTIST_ID).id,
                    track.mb_album_artist_id.get());
    }

  if (track.mb_album_artist_sort_name)
    {
      add_txxx_tag (tag,
                    Bmp::MetadatumDefine(DATUM_MB_ALBUM_ARTIST_SORTNAME).title,
                    Bmp::MetadatumDefine(DATUM_MB_ALBUM_ARTIST_SORTNAME).id,
                    track.mb_album_artist_sort_name.get());
    }

  if (track.mb_track_id)
    {
      ID3v2::UniqueFileIdentifierFrame *frame = new ID3v2::UniqueFileIdentifierFrame
                                  ("http://musicbrainz.org", track.mb_track_id.get().c_str());
      tag->addFrame (frame);
    }

  if (track.mb_album_id)
    {
      add_txxx_tag (tag,
                    Bmp::MetadatumDefine(DATUM_MB_ALBUM_ID).title,
                    Bmp::MetadatumDefine(DATUM_MB_ALBUM_ID).id,
                    track.mb_album_id.get());
    }

  if (track.mb_artist_id)
    {
      add_txxx_tag (tag,
                    Bmp::MetadatumDefine(DATUM_MB_ARTIST_ID).title,
                    Bmp::MetadatumDefine(DATUM_MB_ARTIST_ID).id,
                    track.mb_artist_id.get());
    }

  if (track.mb_artist_sort_name)
    {
      add_txxx_tag (tag,
                    Bmp::MetadatumDefine(DATUM_MB_ARTIST_SORTNAME).title,
                    Bmp::MetadatumDefine(DATUM_MB_ARTIST_SORTNAME).id,
                    track.mb_artist_sort_name.get());
    }

  if (track.mb_release_date)
    {
      ID3v2::TextIdentificationFrame *frame = 0;

      frame = new ID3v2::TextIdentificationFrame ("TDRL", String::UTF8);
      frame->setText (String (track.mb_release_date.get().c_str(), String::UTF8));
      tag->addFrame (frame);

      frame = new ID3v2::TextIdentificationFrame ("TDRC", String::UTF8);
      frame->setText (String (track.mb_release_date.get().c_str(), String::UTF8));
      tag->addFrame (frame);
    }

  if (track.asin)
    {
      add_txxx_tag (tag,
                  Bmp::MetadatumDefine(DATUM_ASIN).title,
                  Bmp::MetadatumDefine(DATUM_ASIN).id,
                  track.asin.get());
    }

  if (track.puid)
    {
      add_txxx_tag (tag,
                  Bmp::MetadatumDefine(DATUM_MUSICIP_PUID).title,
                  Bmp::MetadatumDefine(DATUM_MUSICIP_PUID).id,
                  track.puid.get());
    }

  opfile.save (TagLib::MPEG::File::ID3v2);
  tag = opfile.ID3v2Tag (false);

  struct stat tagstat;
  stat (name.c_str(), &tagstat);

  TagLib::ByteVector tagData (tag->render());

  track.hash =
  Bmp::Util::md5_hex ((char*)(tagData.data()), tagData.size())+(fsizefmt % (unsigned long long int)(tagstat.st_size)).str();

  return true;
}

extern "C" bool _get (TagLib::File * p, Bmp::DB::Row & row, std::string const& name)  
{
  using namespace Bmp::Library;
  using namespace TagLib;

  MPEG::File * file;

  if (!(file = dynamic_cast<MPEG::File*> (p)))
    return false;

  ID3v2::Tag * tag = file->ID3v2Tag (false);
  if (tag)
    Bmp::Library::metadata_get_id3v2 (tag, row, name); 

  return true;
}
