/***************************************************************************
copyright            : (C) 2005 by Andy Leadbetter
email                : andrew.leadbetter@gmail.com
 ***************************************************************************/

/***************************************************************************
 *   This library is free software; you can redistribute it and/or modify  *
 *   it  under the terms of the GNU Lesser General Public License version  *
 *   2.1 as published by the Free Software Foundation.                     *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  *
 *   USA                                                                   *
 ***************************************************************************/

#ifndef TAGLIB_MP4PROPERTIES_H
#define TAGLIB_MP4PROPERTIES_H

#include <audioproperties.h>
#include <tstring.h>

#include <mp4.h>
// mp4.h drags in mp4_config.h that defines these
// get rid of them so they don't conflict with our config.h

#undef HAVE_DLFCN_H
#undef HAVE_ERRNO_H
#undef HAVE_FLOAT_H
#undef HAVE_FPOS_T_POS
#undef HAVE_GETPWUID
#undef HAVE_INTTYPES_H
#undef HAVE_IN_PORT_T
#undef HAVE_LIMITS_H
#undef HAVE_MEMCPY
#undef HAVE_MEMORY_H
#undef HAVE_SOCKLEN_T
#undef HAVE_STDINT_H
#undef HAVE_STDLIB_H
#undef HAVE_STRCHR
#undef HAVE_STRINGS_H
#undef HAVE_STRING_H
#undef HAVE_STRSEP
#undef HAVE_SYSFS_LIBSYSFS_H
#undef HAVE_SYS_STAT_H
#undef HAVE_SYS_TIME_H
#undef HAVE_SYS_TYPES_H
#undef HAVE_UNISTD_H
#undef HAVE_FLOAT32_T 
#undef HAVE_IOKIT_IOKITLIB_H 
#undef HAVE_LIBMP4V2 
#undef HAVE_MATHF_H
#undef HAVE_SYSFS_LIBSYSFS_H 
#undef WORDS_BIGENDIAN 
#undef inline
#undef off_t
#undef PACKAGE
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#undef PACKAGE_BUGREPORT
#undef STDC_HEADERS
#undef TIME_WITH_SYS_TIME
#undef VERSION

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

namespace TagLib
{
    namespace MP4
    {
        class File;

        /*!
         * This reads the data from a MP4 stream to support the
         * AudioProperties API.
         */

        class Properties : public AudioProperties
        {
            public:

                /*!
                 * Initialize this structure
                 */
                Properties(Properties::ReadStyle style);

                /*!
                 * Destroys this MP4 Properties instance.
                 */
                virtual ~Properties();

                // Reimplementations.

                virtual int length() const;
                virtual int bitrate() const;
                virtual int sampleRate() const;
                virtual int channels() const;

            private:

                void readMP4Properties(MP4FileHandle mp4File);
                void readAudioTrackProperties(MP4FileHandle mp4File, MP4TrackId trackId );

                friend class MP4::File;

                int m_length;
                int m_bitrate;
                int m_sampleRate;
                int m_channels;

                Properties(const Properties &);
                Properties &operator=(const Properties &);

                void read();
        };

    }

}

#endif
