//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <glibmm.h>
#include <gtkmm.h>
#include <libglademm.h>
#include <glib/gstdio.h>

#include <cstring>
#include <iostream>
#include <sstream>
#include <string>

#include <boost/format.hpp>
#include <boost/optional.hpp>

#include "main.hh"
#include "paths.hh"

#include "ui_toolbox.hh"
#include "util.hh"
#include "uri++.hh"

#include "lyrics.hh"
#include "dialog-lyrics.hh"

#include "amazon.hh"
#include "playbacksource.hh"

namespace Bmp
{
  Lyrics::~Lyrics () {}

  Lyrics* Lyrics::create ()
  {
      const std::string path (BMP_GLADE_DIR G_DIR_SEPARATOR_S "dialog-lyrics.glade");
      Glib::RefPtr<Gnome::Glade::Xml> glade_xml = Gnome::Glade::Xml::create (path);
      Lyrics *p = 0;
      glade_xml->get_widget_derived ("trackinfo", p);
      return p;
  }

  Lyrics::Lyrics (BaseObjectType                       * obj,
                  Glib::RefPtr<Gnome::Glade::Xml> const& xml)
      : Gtk::Dialog (obj),
        m_ref_xml   (xml)
  {
      Util::window_set_icon_list (GTK_WIDGET (this->gobj()), "player");

      m_ref_xml->get_widget ("lyrics",        m_widget_lyrics);
      m_ref_xml->get_widget ("cover",         m_widget_cover);
      m_ref_xml->get_widget ("notebook",      m_widget_notebook);
      m_ref_xml->get_widget ("label_artist",  m_widget_label_artist);
      m_ref_xml->get_widget ("label_title",   m_widget_label_title);
  }

  void
  Lyrics::run ( SimpleTrackInfo const& sti )
  {
      if (sti.image)
      {
        m_widget_cover->set (sti.image->scale_simple (96, 96, Gdk::INTERP_BILINEAR));
      }
      else
      if (sti.asin)
      {
        try{
          Glib::RefPtr<Gdk::Pixbuf> cover;
          Amazon::fetch (sti.asin.get(), cover, true);
          m_widget_cover->set (cover->scale_simple (96, 96, Gdk::INTERP_BILINEAR));
          }
        catch (...)
          {
            m_widget_cover->set (Gdk::Pixbuf::create_from_file (Glib::build_filename
              (BMP_IMAGE_DIR, BMP_COVER_IMAGE_DEFAULT))->scale_simple (96, 96, Gdk::INTERP_BILINEAR));
          } 
      }
      else
      {
        m_widget_cover->set (Gdk::Pixbuf::create_from_file (Glib::build_filename
          (BMP_IMAGE_DIR, BMP_COVER_IMAGE_DEFAULT))->scale_simple (96, 96, Gdk::INTERP_BILINEAR));
      }

      bool forced = false;  
      rerun:

      m_widget_label_artist->set_markup ("<b>" + sti.artist.get() + "</b>");
      m_widget_label_title->set_markup ("<i>" + sti.title.get() + "</i>");

      Glib::ustring text;
      m_widget_lyrics->set_sensitive (false);
      m_widget_notebook->set_current_page (1);
      while (gtk_events_pending())
        gtk_main_iteration();
      if (Bmp::LyricWiki::get_lyrics (sti.artist.get(), sti.title.get(), text, forced))
      {
        try {
          m_widget_lyrics->get_buffer ()->set_text (text);
          m_widget_lyrics->set_sensitive (true);
          while (gtk_events_pending())
            gtk_main_iteration();
          }
        catch (...) {}
      }
      show_all ();
      m_widget_notebook->set_current_page (0);
      while (gtk_events_pending())
        gtk_main_iteration();
      if (Gtk::Dialog::run() == GTK_RESPONSE_APPLY)
      {
        forced = true;
        goto rerun;
      }
  }
} // namespace Bmp 
