//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_PODCAST_TOOLS_HH 
#define BMP_PODCAST_TOOLS_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <vector>

#include <boost/format.hpp>
#include <boost/optional.hpp>
#include <glibmm.h>
#include <glibmm/markup.h>
#include "util.hh"
#include "uuid.h"

#include "podcast_types.hh"

namespace Bmp
{
  namespace PodCastTools
  {
    //////////////////////////////////////////////////////////////////////////////////////////////////////////

    class PodCastOverlayParser : public Glib::Markup::Parser
    {
      public:

        PodCastOverlayParser (MOverlayItems & overlays); 
        virtual ~PodCastOverlayParser ();

        bool check_sanity ();

      protected:

        virtual void
        on_start_element  (Glib::Markup::ParseContext& context,
                           Glib::ustring const& elementname,
                           const AttributeMap& attributes);
        virtual void
        on_end_element    (Glib::Markup::ParseContext& context,
                           Glib::ustring const& elementname);
        virtual void
        on_text	          (Glib::Markup::ParseContext& context,
                           Glib::ustring const& text);
        virtual void
        on_passtrough     (Glib::Markup::ParseContext& context,
                           Glib::ustring const& text);
        virtual void
        on_error	        (Glib::Markup::ParseContext& context,
                           const Glib::MarkupError& error);
      private:

        MOverlayItems & m_overlays;

        enum Element
        {
          E_NONE	              = 0, 
          E_BMP_CAST_OVERLAY    = 1 << 0,
          E_CAST_ITEM           = 1 << 1,
        };

        int state;
    };

    //////////////////////////////////////////////////////////////////////////////////////////////////////////

    class PodCastManager;
    class OPMLParser : public Glib::Markup::Parser
    {
      public:

        OPMLParser (MPodCasts & casts, const PodCastManager * manager); 
        virtual ~OPMLParser ();

        bool check_sanity ();

      protected:

        virtual void
        on_start_element  (Glib::Markup::ParseContext & context,
                           Glib::ustring const& elementname,
                           AttributeMap const& attributes);
        virtual void
        on_end_element    (Glib::Markup::ParseContext & context,
                           Glib::ustring const& elementname);
        virtual void
        on_text	          (Glib::Markup::ParseContext & context,
                           Glib::ustring const& text);
        virtual void
        on_passtrough     (Glib::Markup::ParseContext & context,
                           Glib::ustring const& text);
        virtual void
        on_error	        (Glib::Markup::ParseContext & context,
                           Glib::MarkupError const& error);
      private:

        MPodCasts            & m_casts;
        const PodCastManager * m_manager;

        enum Element
        {
          E_NONE	              = 0, 
          E_OPML                = 1 << 0,
          E_HEAD                = 1 << 1,
          E_BODY                = 1 << 2,
          E_OUTLINE             = 1 << 3
        };

        int state;
    };

    //////////////////////////////////////////////////////////////////////////////////////////////////////////

    class PodCastManager
    {
      public:

        PodCastManager ();
        ~PodCastManager ();

        void pod_cast_get_list  (PodCastList & list);

        PodCast const& pod_cast_fetch  (Glib::ustring const&        uri,
                                        Glib::RefPtr<Gdk::Pixbuf> & pixbuf,
                                        bool                        load_cover = true) const;

        PodCast const& pod_cast_fetch  (Glib::ustring const& uri) const;

        void pod_cast_cache  (Glib::ustring const&  uri,
                              bool                  update = false,
                              std::string const&    uuid_ = std::string());

        void pod_cast_delete (Glib::ustring const& uri);

        void pod_cast_update (Glib::ustring const& uri);

        void pod_cast_item_change (Glib::ustring const& uri,
                                   Glib::ustring const& guid_value,
                                   PodCastOverlayItem const& overlay_item);

      private:

        friend class OPMLParser;

        void pod_cast_load (std::string const& uuid, PodCast & cast) const;

        void pod_cast_overlay_save (PodCast const& cast);

        void save_opml ();
        void save_overlays ();

        void save_state ();

        MPodCasts m_casts;
    };
  }
}
#endif
