#include <stdlib.h>
#include <glib.h>

#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xmlreader.h>
#include <libxml/xpath.h>
#include <libxml/xpathInternals.h>

static int
register_namespaces (xmlXPathContextPtr xpathCtx, const xmlChar* nsList)
{
    xmlChar* nsListDup;
    xmlChar* prefix;
    xmlChar* href;
    xmlChar* next;
    
    nsListDup = xmlStrdup(nsList);
    if(nsListDup == NULL)
    {
    g_warning (G_STRLOC ": unable to strdup namespaces list");
    return(-1); 
    }
    
    next = nsListDup; 
    while (next != NULL)
    {
    // skip spaces
    while((*next) == ' ') next++;
    if((*next) == '\0') break;

    // find prefix
    prefix = next;
    next = (xmlChar*)xmlStrchr(next, '=');

    if (next == NULL) 
    {
        g_warning (G_STRLOC ": invalid namespaces list format");
        xmlFree (nsListDup);
        return(-1); 
    }
    *(next++) = '\0';   
    
    // find href
    href = next;
    next = (xmlChar*)xmlStrchr(next, ' ');
    if (next != NULL)
    {
        *(next++) = '\0';   
    }

    // do register namespace
    if(xmlXPathRegisterNs(xpathCtx, prefix, href) != 0)
      {
        g_warning (G_STRLOC ": unable to register NS with prefix=\"%s\" and href=\"%s\"", prefix, href);
        xmlFree(nsListDup);
        return(-1); 
    }
    }
    
    xmlFree(nsListDup);
    return(0);
  }

xmlXPathObjectPtr
xml_execute_xpath_expression (xmlDocPtr doc, 
                  const xmlChar * xpathExpr,
                              const xmlChar * nsList)
{

    xmlXPathContextPtr xpathCtx;
    xmlXPathObjectPtr xpathObj;

    /*
     * Create xpath evaluation context
     */
    xpathCtx = xmlXPathNewContext (doc);
    if (xpathCtx == NULL)
     {
         return NULL;
     }

     if (nsList)
    register_namespaces (xpathCtx, nsList);

    /*
     * Evaluate xpath expression
     */
    xpathObj = xmlXPathEvalExpression (xpathExpr, xpathCtx);
    if (xpathObj == NULL)
     {
         xmlXPathFreeContext (xpathCtx);
         return NULL;
     }

    /*
     * Cleanup
     */
    xmlXPathFreeContext (xpathCtx);

    return xpathObj;
}
