//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non GPL-compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <glibmm/ustring.h>

using namespace std;
using namespace Glib;

namespace
{
  enum ElementId
  {
    E_TOPTAGS,
    E_TAG,
    E_NAME,
    E_COUNT,
    E_URL,
  };
}

#include "parser/libxml2-sax-base.hh"
using Bmp::XPath;

#include "lastfm-tags-libxml2-sax.hh"

namespace
{
  Element_tag elements[] =
  {
      { "toptags" },
      { "tag"     },
      { "name"    },
      { "count"   },
      { "url"     },
  };
  
  struct LastFMTagParserContext : public ParseContextBase
  {
    Bmp::LastFM::TagV  & m_tags;
    Bmp::LastFM::Tag     m_tag;

    LastFMTagParserContext (Bmp::LastFM::TagV & tags)
      : ParseContextBase()
      , m_tags (tags)
    {}
  };

  typedef std::map < ustring, ustring > ElementAttributes; 

#define DEFAULT_REFS \
  LastFMTagParserContext & context (static_cast<LastFMTagParserContext&>(_context));

  //////////////////////////////////////////////////////////////////////////////

  namespace Handlers
  {
    namespace Tag
    {
      HANDLER(tag)
      {
        DEFAULT_REFS
        context.m_tag = Bmp::LastFM::Tag();
      }
    }
  }

  Handler_tag handlers[] = 
  {
    { XPath(elements[E_TOPTAGS]) / XPath(elements[E_TAG]), 
      &Handlers::Tag::tag },
  };
  //---------
  
  namespace HandlersEnd
  {
    namespace Tag
    {
      HANDLER_END(tag)
      {
        DEFAULT_REFS
        context.m_tags.push_back (context.m_tag);
      }
    }
  }
  
  HandlerEnd_tag handlers_end[] =
  {
    { XPath(elements[E_TOPTAGS]) / XPath(elements[E_TAG]), 
        &HandlersEnd::Tag::tag },
  };
  //---------
  
  namespace HandlersPCDATA
  {
    namespace Tag
    {
      HANDLER_PCDATA(name)
      {
        DEFAULT_REFS
        context.m_tag.name += text;
      }

      HANDLER_PCDATA(count)
      {
        DEFAULT_REFS
        context.m_tag.count = g_ascii_strtoull (text.c_str(), NULL, 10); 
      }
 
      HANDLER_PCDATA(url)
      {
        DEFAULT_REFS
        context.m_tag.url += text;
      }
    }
  }

  HandlerPCDATA_tag handlers_pcdata[] = 
  {
      { XPath(elements[E_TOPTAGS]) / XPath(elements[E_TAG]) / XPath(elements[E_NAME]),
        &HandlersPCDATA::Tag::name},

      { XPath(elements[E_TOPTAGS]) / XPath(elements[E_TAG]) / XPath(elements[E_COUNT]),
        &HandlersPCDATA::Tag::count},

      { XPath(elements[E_TOPTAGS]) / XPath(elements[E_TAG]) / XPath(elements[E_URL]),
        &HandlersPCDATA::Tag::url},
  };
  //---------
}

namespace Bmp
{
  namespace LastFM
  {
    int parse_toptags (TagV & tags, const char * data, guint size) 
    {
      LastFMTagParserContext context (tags);

      for (unsigned int n = 0; n < G_N_ELEMENTS(handlers); ++n)
       {
         context.mHandlers.insert (std::make_pair (handlers[n].elementId, handlers[n].handler));
       }
       
       // handler/end 
       for (unsigned int n = 0; n < G_N_ELEMENTS(handlers_end); ++n)
       {
         context.mHandlersEnd.insert (std::make_pair (handlers_end[n].elementId, handlers_end[n].handler));
       }
       
       // handler/pcdata
       for (unsigned int n = 0; n < G_N_ELEMENTS(handlers_pcdata); ++n)
       {
         context.mHandlersPCDATA.insert (std::make_pair (handlers_pcdata[n].elementId, handlers_pcdata[n].handler));
       }
       
       // name <-> id map 
       for (unsigned int n = 0; n < G_N_ELEMENTS(elements); ++n)
       {
         context.mNameIdMap.insert (std::make_pair (elements[n], ElementId (n)));
       }

      return SaxParserBase::xml_base_parse (data, size, context);
    }
  }
}
