//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_UI_PART_PODCASTS_HH
#define BMP_UI_PART_PODCASTS_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif//HAVE_CONFIG_H

#include <boost/optional.hpp>
#include <boost/shared_ptr.hpp>
#include <string>
#include <ctime>
#include <map>

#include <glib/gtypes.h>
#include <glibmm/ustring.h>
#include <gdkmm/pixbuf.h>
#include <gtkmm/liststore.h>
#include <gtkmm/treemodelfilter.h>
#include <gtkmm/treeview.h>
#include <gtkmm/uimanager.h>
#include <libglademm/xml.h>
#include <gdk/gdkx.h>
#include "widgets/ccwidgets.hh"
#include "widgets/cell-renderer-cairo-surface.hh"
#include "bmp/base-types.hh"
#include "bmp/ui-types.hh"
#include "playbacksource.hh"
#include "podcast.hh"
#include "podcast-utils.hh"
#include "podcast-types.hh"
#include "ui-part-base.hh"
#include "minisoup.hh"
using namespace Bmp::PodcastBackend;
using namespace Gtk;
using namespace Glib;

namespace Bmp
{
  typedef boost::optional<TreeIter> OptionalTreeIter;
  
  namespace UiPart
  {
    class Podcasts
      : public PlaybackSource,
        public Base
    {
        boost::shared_ptr<PodcastBackend::PodcastManager> m_cast_manager;

      public:

        Podcasts (RefPtr<Gnome::Glade::Xml> const& xml,
                  RefPtr<Gtk::UIManager> const& ui_manager);

        virtual ~Podcasts ();

      protected:

        virtual guint
        add_ui ();

        virtual ustring
        get_uri ();

        virtual ustring
        get_type ();

        virtual bool
        go_next ();

        virtual bool
        go_prev ();

        virtual void
        stop ();

        virtual void
        play ();
  
        virtual void
        play_post ();

        virtual void
        prev_post ();

        virtual void
        next_post ();

        virtual void
        restore_context ();

        virtual void
        buffering_done ();

     private:

        ::Window set_da_window_id ();

        bool check_casts ();

        void  add_cast_internal (PodcastBackend::Podcast const&  cast);

        void  upd_cast_internal (PodcastBackend::Podcast const&  cast,
                                 Gtk::TreeIter                &  iter);

        void  load_cast_image   (PodcastBackend::Podcast const&  cast,
                                 Gtk::TreeIter                &  iter);

        // Action Callbacks
        void  activate_default (Gtk::TreePath const& path,
                                Gtk::TreeViewColumn* column);

        void  on_new_podcast ();
        void  on_remove_podcast ();
        void  on_update_podcast ();

        void  on_copy_xml_link ();
        void  on_copy_web_link ();
        void  on_export_feedlist ();

        void  on_casts_selection_changed ();
        void  on_items_selection_changed ();

        class Casts
          : public Gtk::TreeModel::ColumnRecord
        {
          public:

            Gtk::TreeModelColumn<BmpCairoIS>      expired;
            Gtk::TreeModelColumn<BmpCairoIS>      image;
            Gtk::TreeModelColumn<ustring>   title;
            Gtk::TreeModelColumn<ustring>   uri;
            Gtk::TreeModelColumn<UID>             uid;
            Gtk::TreeModelColumn<std::string>     key;
            Gtk::TreeModelColumn<time_t>          most_recent;
            Gtk::TreeModelColumn<ustring>   searchtitle;

            Casts ()
            {
              add (expired);
              add (image);
              add (title);
              add (uri);
              add (uid);
              add (key);
              add (most_recent);
              add (searchtitle);
            }
        };
        Casts casts;

        ///// ITEMS
        enum ItemColumnType
        {
          CELL_PIXBUF,
          CELL_TEXT,
          CELL_TOGGLE,
          CELL_PROGRESS,
        };

        enum ItemColumn
        {
          COLUMN_PLAYING,
          COLUMN_DOWNLOADED,
          COLUMN_DOWNLOADING,
          COLUMN_NEW,
          COLUMN_TITLE,
          COLUMN_DATE,

          N_COLUMNS
        };

        class Items
          : public Gtk::TreeModel::ColumnRecord
        {
          public:
            Gtk::TreeModelColumn<PodcastBackend::PodcastItem> item;
            Items ()
            {
              add (item);
            }
        };
        Items items;

        enum Direction
        {
          NEXT,
          PREV,
          CHECKONLY,
        };

        // Items
        void cell_data_func_items (Gtk::CellRenderer * cell, Gtk::TreeIter const& m_iter, ItemColumn column, ItemColumnType type);
        int  items_default_sort_func (Gtk::TreeIter const& iter_a, Gtk::TreeIter const& iter_b);

        // Casts
        void cell_data_func_cast_logo (Gtk::CellRenderer * cell, Gtk::TreeIter const& m_iter);
        int casts_default_sort_func (Gtk::TreeIter const& iter_a, Gtk::TreeIter const& iter_b);
        bool on_casts_event (GdkEvent * ev);

        void go_next_prev  (Direction direction);
        void has_next_prev (bool & next, bool & prev);
        bool podcast_visible_func (Gtk::TreeIter const& iter);

        bool sel_uid_is_current_uid ();
        void assign_current_item (TreeIter const& iter);
        void clear_current_item ();
        void current_check_played_and_caps ();
        void send_metadata ();

        Gtk::TreeView * m_view_casts;
        Gtk::TreeView * m_view_items;

        RefPtr<Gtk::TreeModelFilter>    m_store_casts_filter;
        RefPtr<Gtk::ListStore>          m_store_casts;
        RefPtr<Gtk::ListStore>          m_store_items;

        Cairo::RefPtr<Cairo::ImageSurface>    m_feed_default;
        Cairo::RefPtr<Cairo::ImageSurface>    m_feed_expired;

        OptionalTreeIter  m_current_iter;
        Podcast           m_current_cast;
        PodcastItem       m_current_item;
        ustring           m_current_item_uid;

        TrackMetadata     m_metadata;
        RefPixbuf         m_current_image;

        Sexy::IconEntry*  m_filter_entry;
        Gtk::TextView*    m_textview;
        Gtk::DrawingArea* m_video;

        UidIterMap  m_context_map;
        UID         m_current_uid;
        UID         m_uid;

        RefPixbuf   m_playing; // 'playing' arrow pixbuf
        RefPixbuf   m_emblem_new;

        struct DownloadContext
        {
          Soup::RequestFileRefP mFileRequest;
          ustring               mCastUri;
          PodcastItem           mDownloadItem;
          double                mDownloadProgress;
        };

        typedef boost::shared_ptr<DownloadContext> DownloadContextRefp;
        typedef std::pair<UID, std::string> DownloadKey;

        /* typedef std::tr1::unordered_map<DownloadKey, DownloadContextRefp> DownloadMap; FIXME: Write hash func */
        typedef std::map<DownloadKey, DownloadContextRefp> DownloadMap;

        void  on_column_download_toggled (ustring const& path);
        void  download_done (std::string const& /*filename*/, DownloadKey /*key*/);
        void  download_aborted (DownloadKey /*key*/);
        void  download_progress (double /*progress*/, DownloadKey /*key*/);
        void  download_remove (DownloadKey /*key*/); /* NOT a callback; merely resetting our internal download info state */
        void  download_cancel (DownloadKey /*key*/); /* -"""- */

        DownloadMap mDownloads;
        UidSet mDownloadUids;
        Glib::Mutex mDownloadEraseLock;

    }; // Playlist
  } // namespace UiPart
} // namespace Bmp

#endif // !BMP_UI_PART_PODCASTS_HH

