//  BMP
//  Copyright (C) 2005-2007 BMP development.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_DIALOG_TRACK_DETAILS_HH
#define BMP_DIALOG_TRACK_DETAILS_HH

#include <gtkmm/dialog.h>
#include <gtkmm/image.h>
#include <gtkmm/label.h>
#include <gtkmm/notebook.h>
#include <gtkmm/textview.h>
#include <libglademm/xml.h>

#include "bmp/types/types-basic.hh"
#include "bmp/types/types-ui.hh"

#include "lyrics-v2.hh"
#include "lastfm.hh"
using namespace Bmp::LastFM; 
using namespace Bmp::LastFM::XMLRPC; 

namespace Bmp
{
  class LastFmWikiView;
  class TrackDetails
    : public Gtk::Window
  {
      Glib::RefPtr<Gnome::Glade::Xml> m_ref_xml;

    public:

      TrackDetails (BaseObjectType                       * obj,
                    Glib::RefPtr<Gnome::Glade::Xml> const& xml);
      static TrackDetails* create ();
      virtual ~TrackDetails ();

      void
      display (TrackMetadata const& metadata);

    private:

      void
      got_lyrics (std::string const& lyrics, bool have_em);

      void
      get_lyrics (bool forced = false);

      void
      got_artist (std::string const& metadata, guint code); 

      void
      get_artist ();

    private:

      typedef std::vector<TrackMetadata> MetadataV;
      typedef MetadataV::iterator MetadataIter;

      LyricWiki::TextRequestRefP m_lyrics_request;
      LastFM::XMLRPC::ArtistMetadataRequestRefPtr m_artist_request;

      Glib::RefPtr<Gtk::UIManager> m_ui_manager;
      Glib::RefPtr<Gtk::ActionGroup> m_actiongroup;

      Glib::RefPtr<Gtk::SizeGroup> m_size_group;

      Gtk::Notebook       * m_notebook_artist;
      Gtk::Notebook       * m_notebook_lyrics;
      Gtk::Image          * m_widget_cover;
      Gtk::TextView       * m_widget_lyrics;
      LastFmWikiView      * m_widget_artist;
      Gtk::Widget         * m_visible_child;
      RefPixbuf             m_cover;
      ustring               m_link;

      struct MetaDataData
      {
        MetadataV             V;
        MetadataIter          Iter;
        Glib::Mutex           Lock;
        MetaDataData () : Iter (V.begin()) {}
      };
      MetaDataData MData;

      void
      open_uri (ustring const&);

      void
      popup_uri_menu (ustring const&, guint, guint32);

      void
      on_menu_open_uri ();

      void
      on_menu_copy_uri ();
 
      void
      split_title ();

  }; //class TrackDetails
} //namespace Bmp 

#endif // !BMP_DIALOG_TRACK_DETAILS_HH

