/*  BMP
 *  Copyright (C) 2005-2007 BMP development.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id$
 *
 * The BMPx project hereby grant permission for non-gpl compatible GStreamer
 * plugins to be used and distributed together with GStreamer and BMPx. This
 * permission are above and beyond the permissions granted by the GPL license
 * BMPx is covered by.
 *
 *  $Id$
 */

#include <config.h>

#include <glib.h>
#include <glib/gi18n.h>
#include <gtk/gtk.h>

#include "linkage.hh"

#define GLIB_REQUIRED_MAJOR_VER GLIB_MAJOR_VERSION
#define GLIB_REQUIRED_MINOR_VER 8
#define GLIB_REQUIRED_MICRO_VER 0

#define GTK_REQUIRED_MAJOR_VER GTK_MAJOR_VERSION
#define GTK_REQUIRED_MINOR_VER 8
#define GTK_REQUIRED_MICRO_VER 0

#define GLADE_REQUIRED_MAJOR_VER GLIB_MAJOR_VERSION
#define GLADE_REQUIRED_MINOR_VER 8
#define GLADE_REQUIRED_MICRO_VER 0

C_FUNCTION
const gchar*
sanity_check_glib (void)
{
  return glib_check_version (GLIB_REQUIRED_MAJOR_VER,
                             GLIB_REQUIRED_MINOR_VER,
                             GLIB_REQUIRED_MICRO_VER);
}

static gchar *
sanity_check_glib_msg (void)
{
  if (sanity_check_glib ())
    {
      return g_strdup_printf (_("BMPx requires Glib %d.%d.%d or above to run."),
                              GLIB_REQUIRED_MAJOR_VER,
                              GLIB_REQUIRED_MINOR_VER,
                              GLIB_REQUIRED_MICRO_VER);
    }

  return 0;
}

C_FUNCTION
gchar *
sanity_check_gtk (void)
{
  return gtk_check_version (GTK_REQUIRED_MAJOR_VER,
                            GTK_REQUIRED_MINOR_VER,
                            GTK_REQUIRED_MICRO_VER);
}

static gchar *
sanity_check_gtk_msg (void)
{
  if (sanity_check_gtk ())
    {
      return g_strdup_printf (_("BMPx requires GTK+ %d.%d.%d or above to run."),
                              GTK_REQUIRED_MAJOR_VER,
                              GTK_REQUIRED_MINOR_VER,
                              GTK_REQUIRED_MICRO_VER);
    }

  return 0;
}

C_FUNCTION
gchar *
sanity_check_libs (void)
{
  gchar *error;

  if ((error = sanity_check_glib_msg ()) != NULL)
    {
      return error;
    }

  if ((error = sanity_check_gtk_msg ()) != NULL)
    return error;

  return 0;
}
