//  BMP
//  Copyright (C) 2005-2007 BMP development.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non GPL-compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_JAMENDO_DATA_TYPES_HH
#define BMP_JAMENDO_DATA_TYPES_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <string>
#include <vector>
#include <boost/cstdint.hpp>

namespace Bmp
{
  namespace JamendoData
  {
    struct Artist
    {
      std::string   dispname;
      guint64      id;

      std::string   name;
      std::string   weblink;
      std::string   genre;
      std::string   description;
      std::string   image_url;

      Artist () : id (0) {}
    };
    typedef std::vector<Artist> ArtistV;

    struct Album
    {
      // <album/> has no name/dispname pair, just dispname; the SQL is farther away than the classes here
      std::string   dispname;
      guint64      id;

      guint64      artist_id;
      std::string   weblink; 
      std::string   genre;
      std::string   pubdate;
      std::string   releasedate;

      Album () : id (0), artist_id (0) {}
    };
    typedef std::vector<Album> AlbumV;

    struct Track
    {
      std::string   dispname; 
      guint64      id;

      guint64      album_id;
      guint64      length;
      guint64      trackno;
      std::string   weblink;
    };
    typedef std::vector<Track> TrackV;
  }
}

#endif //!BMP_JAMENDO_DATA_TYPES_HH
