//  BMP
//  Copyright (C) 2005-2007 BMP development.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_UTIL_HH
#define BMP_UTIL_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <ctime>

#include <glib-object.h>
#include <glibmm/ustring.h>
#include <gdkmm/pixbuf.h>
#include <cairomm/context.h>
#include <cairomm/surface.h>

#include "util-string.hh"

namespace Bmp
{
  namespace Util
  {
    bool
    match_keys (Glib::ustring const& haystack,
                Glib::ustring const& needle);

    char*
    hexify (char*, int);

    Glib::ustring
    sanitize_html (Glib::ustring const&);

    Glib::ustring
    sanitize_lastfm (Glib::ustring const&);

    Glib::RefPtr<Gdk::Pixbuf>
    get_image_from_uri (Glib::ustring const&);

    std::time_t
    parseRFC822Date (char const*);

    void
    free_gvalue_ptr (GValue* value);

    void
    draw_cairo_image (Cairo::RefPtr<Cairo::Context> const&      cr,
                      Cairo::RefPtr<Cairo::ImageSurface> const& image,
                      double                                    x,
                      double                                    y,
                      double                                    alpha);
  }
}

#endif //!BMP_UTIL_HH
