-- This Alex file was machine-generated by the BNF converter
%{
module LexBNF where

import Alex
import ErrM
%}

{ ^l = [a-zA-Z^192-^255] # [^215 ^247]}    -- isolatin1 letter
{ ^c = [A-Z^192-^221] # [^215]}    -- capital isolatin1 letter
{ ^s = [a-z^222-^255] # [^247]}    -- small isolatin1 letter
{ ^d = [0-9]            }    -- digit
{ ^i = [^l^d^'^_]       }    -- identifier character
{ ^u = [^0-^255]        }    -- universal: any character

{ %s =    -- reserved words consisting of special symbols
   ^; | ^. | ^: ^: ^= | ^[ | ^] | ^_ | ^( | ^: | ^) | ^, | ^| | ^- | ^* | ^+ | ^? | ^{ | ^}
}

"tokens_lx"/"tokens_acts":-
<>         ::= ^-^- [.]* ^n
<>         ::= ^{ ^- ([^u # ^-] | ^- [^u # ^}])* (^-)+ ^}

<>         ::= ^w+
<pTSpec>   ::=  %s %{ pTSpec p = PT p . TS    %}

<ident>   ::= ^l ^i*   %{ ident  p = PT p . eitherResIdent TV %}
<string>  ::= ^" ([^u # [^"^\^n]] | (^\ (^" | ^\ | ^' | n | t)))* ^"%{ string p = PT p . TL . unescapeInitTail %}
<char>    ::= ^' (^u # [^'^\] | ^\ [^\ ^' n t]) ^'  %{ char   p = PT p . TC    %}
<int>    ::= ^d+      %{ int    p = PT p . TI    %}


%{ 

data Tok =
   TS String     -- reserved words
 | TL String     -- string literals
 | TI String     -- integer literals
 | TV String     -- identifiers
 | TD String     -- double precision float literals
 | TC String     -- character literals

 deriving (Eq,Show)

data Token = 
   PT  Posn Tok
 | Err Posn
  deriving Show

tokenPos (PT (Pn _ l _) _ :_) = "line " ++ show l
tokenPos (Err (Pn _ l _) :_) = "line " ++ show l
tokenPos _ = "end of file"

prToken t = case t of
  PT _ (TS s) -> s
  PT _ (TI s) -> s
  PT _ (TV s) -> s
  PT _ (TD s) -> s
  PT _ (TC s) -> s
  _ -> show t

tokens:: String -> [Token]
tokens inp = scan tokens_scan inp

tokens_scan:: Scan Token
tokens_scan = load_scan (tokens_acts,stop_act) tokens_lx
        where
        stop_act p ""  = []
        stop_act p inp = [Err p]

eitherResIdent :: (String -> Tok) -> String -> Tok
eitherResIdent tv s = if isResWord s then (TS s) else (tv s) where
  isResWord s = isInTree s $
    B "lower" (B "entrypoints" (B "comment" (B "coercions" (B "char" N N) N) (B "digit" N N)) (B "layout" (B "internal" (B "eps" N N) N) (B "letter" N N))) (B "terminator" (B "separator" (B "rules" (B "nonempty" N N) N) (B "stop" N N)) (B "toplevel" (B "token" N N) (B "upper" N N)))

data BTree = N | B String BTree BTree deriving (Show)

isInTree :: String -> BTree -> Bool
isInTree x tree = case tree of
  N -> False
  B a left right
   | x < a  -> isInTree x left
   | x > a  -> isInTree x right
   | x == a -> True

unescapeInitTail :: String -> String
unescapeInitTail = unesc . tail where
  unesc s = case s of
    '\\':c:cs | elem c ['\"', '\\', '\''] -> c : unesc cs
    '\\':'n':cs  -> '\n' : unesc cs
    '\\':'t':cs  -> '\t' : unesc cs
    '"':[]    -> []
    c:cs      -> c : unesc cs
    _         -> []
%}
