{-
    BNF Converter: Layout handling Generator
    Copyright (C) 2004  Author:  Aarne Ranta

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

module CFtoLayout where

import CF

cf2Layout :: String -> CF -> String
cf2Layout name cf = let (top,lay,stop) = layoutPragmas cf in unlines [
  "module Layout" ++ name ++ " where",
  "",
  "import Lex" ++ name,
  "import Alex",
  "",
  "-- Generated by the BNF Converter",
  "",
  "-- local parameters",
  "",
  "topLayout = " ++ show top,
  "layoutWords = " ++ show lay,
  "layoutStopWords = " ++ show stop,
  "",
  "-- by setting the first argument False, you can switch off top-level layout",
  "",
  "resolveLayout :: Bool -> [Token] -> [Token]",
  "resolveLayout tp = tailif . res iftop where",
  "",
  "  -- the parameters are used in this way",
  "  iftop = if (tp && topLayout) then [1] else []   -- stack of block positions",
  "  tailif = if (tp && topLayout) then tail else id -- remove first ; (hack)",
  "  ifmix t0 = prToken t0 /= openBrace",
  "  isLayout = isTokenIn layoutWords",
  "  isStop = isTokenIn layoutStopWords",
  "",
  "  res st@(n:ns) (t:ts@(t0:_))",
  "    | isLayout t && ifmix t0 = enterBlock t st ts  -- test if layout is used",
  "    | column t == n  = sameBlock  t st ts",
  "    | column t < n   = exitBlock  t ns ts -- pop the stack",
  "    | isStop t       = exitBlock  t ns ts",
  "    | otherwise      = t : res st ts",
  "",
  "  -- special introduction of braces if the end of file is encountered",
  "  res (_:ns) (t:[])  = let Pn g l c = position t in",
  "                        t : [sToken p s | ",
  "                             (p,s) <- zip [Pn (g + i) l (c + i + 1) | i <- [0,2..]]",
  "                                           (replicate (length ns) closeBrace ++ ",
  "                                           [semicolon])]",
  "",
  "  enterBlock t0 st@(n:ns) ts@(t:ts1)",
  "    | ct > n    = t0 : addToken (nextPos t0) openBrace (t : res (ct:st) ts1)  ",
  "    | otherwise = error $ \"block enter error at \" ++ show (position t)",
  "   where ",
  "     ct = column t ",
  "",
  "  sameBlock t0 st@(n:ns) ts",
  "    | otherwise = addToken (position t0) semicolon (t0 : res st ts)",
  "",
  "  exitBlock t0 st@(n:ns) ts",
  "    | column t0 < n = addToken (position t0) closeBrace (exitBlock t0 ns ts)",
  "                                                         -- exit to yet outer block",
  "    | otherwise     = addToken (position t0) closeBrace (",
  "                        if isStop t0 ",
  "                          then t0 : res st ts",
  "                          else res st (t0:ts))",
  "",
  "",
  "addToken :: Position -> String -> [Token] -> [Token]",
  "addToken p s ts = sToken p s : map (incrGlobal p (length s)) ts",
  "",
  "type Position = Posn",
  "",
  "nextPos :: Token -> Position ",
  "nextPos t = Pn (g + s) l (c + s + 1) where",
  "  Pn g l c = position t",
  "  s = tokenLength t",
  "",
  "incrGlobal :: Position -> Int -> Token -> Token",
  "incrGlobal (Pn g0 l0 c0) i (PT (Pn g l c) t) =",
  "  if l > l0 ",
  "    then PT (Pn (g + i) l c) t",
  "    else PT (Pn (g + i) l (c + i)) t",
  "incrGlobal (Pn g0 l0 c0) i p = error $ \"cannot add token at \" ++ show p",
  "",
  "sToken :: Position -> String -> Token",
  "sToken p s = PT p (TS s) -- reserved word or symbol",
  "",
  "position :: Token -> Position",
  "position t = case t of",
  "  PT p _ -> p",
  "  Err p -> p",
  "",
  "line :: Token -> Int",
  "line t = case position t of Pn _ l _ -> l",
  "",
  "column :: Token -> Int",
  "column t = case position t of Pn _ _ c -> c",
  "",
  "isTokenIn :: [String] -> Token -> Bool",
  "isTokenIn ts t = case t of",
  "  PT _ (TS r) | elem r ts -> True",
  "  _ -> False",
  "",
  "tokenLength :: Token -> Int",
  "tokenLength t = length $ prToken t",
  "",
  "openBrace  = \"{\"",
  "closeBrace = \"}\"",
  "semicolon  = \";\"",
  ""
  ]
