{-
    BNF Converter: Haskell main file
    Copyright (C) 2004  Author:  Markus Forberg, Peter Gammie, Aarne Ranta

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

module HaskellTop (makeAll) where 

-- import Utils
import CF
import CFtoHappy
import CFtoAlex
import CFtoAlex2
import CFtoLatex
import CFtoAbstract
import CFtoTemplate
import CFtoPrinter
import CFtoLayout
-- import CFtoGF		( cf2AbsGF, cf2ConcGF )
-- import System
import GetCF
import Char
import System

-- naming conventions

absFile, absFileM, alexFile, alexFileM, dviFile,
 gfAbs, gfConc,
 happyFile, happyFileM,
 latexFile, errMFile,
 templateFile, templateFileM, printerFile, printerFileM,
 layoutFile, layoutFileM, psFile, tFile, tFileM, mFile :: String -> FilePath
absFile       name = "Abs" ++ name ++ ".hs"
absFileM      name = "Abs" ++ name 
alexFile      name = "Lex" ++ name ++ ".x"
alexFileM     name = "Lex" ++ name
happyFile     name = "Par" ++ name ++ ".y"
happyFileM    name = "Par" ++ name 
latexFile     name = "Doc" ++ name ++ ".tex"
templateFile  name = "Skel" ++ name ++ ".hs"
templateFileM name = "Skel" ++ name
printerFile   name = "Print" ++ name ++ ".hs"
printerFileM  name = "Print" ++ name
dviFile       name = "Doc" ++ name ++ ".dvi"
psFile        name = "Doc" ++ name ++ ".ps"
gfAbs         name = name ++ ".Abs.gf"
gfConc        name = name ++ ".Conc.gf"
tFile         name = "Test" ++ name ++ ".hs"
tFileM        name = "Test" ++ name
mFile         _    = "Makefile"
errMFile      _    = "ErrM.hs"
layoutFileM   name = "Layout" ++ name
layoutFile    name = layoutFileM name ++ ".hs"

makeAll :: Bool -> Bool -> FilePath -> IO ()
makeAll make alex1 file = do
  let name = takeWhile (/= '.') file
  (cf, isOK) <- tryReadCF $ name
  if isOK then do

    writeFileRep (absFile   name)    $ cf2Abstract  name cf
    writeFileRep (alexFile  name)    $ cf2alex1or2  name cf
    if (alex1) then putStrLn "   (Use Alex 1.1 to compile.)" else 
                    putStrLn "   (Use Alex 2.0 to compile.)"
    writeFileRep (happyFile name)    $ cf2HappyS    name cf
    putStrLn "   (Tested with Happy 1.13)"
    writeFileRep (latexFile name)    $ cfToLatex    name cf
    writeFileRep (templateFile name) $ cf2Template  name cf
    writeFileRep (printerFile name)  $ cf2Printer   name cf
    if hasLayout cf then 
      writeFileRep (layoutFile name) $ cf2Layout    name cf
      else return ()
    writeFileRep (tFile name)        $ testfile     name cf
    writeFileRep (errMFile name)     $ errM         name cf
    if make then (writeFileRep (mFile name) $ makefile name) else return () 
    putStrLn $ "Done!"
   else do putStrLn $ "Failed!"
	   exitFailure
       where cf2alex1or2 = if alex1 then cf2alex else cf2alex2

makefile :: String -> String
makefile name = unlines 
                [
 		 "all:", 
                 "\thappy " ++ happyFile name, 
		 "\talex " ++ alexFile name,
                 "\tlatex " ++ latexFile name,
		 "\tdvips " ++ dviFile name ++ " -o " ++ psFile name,
		 "\tghc --make " ++ tFile name ++ " -o " ++ "test" ++ name,
		 "clean:",
		 "\t rm -f " ++ unwords [
                                         "*.log *.aux *.hi *.o *.dvi",
				         "Doc" ++ name ++ ".ps",
				         "*.o"
                                        ],
		 "vclean:",
		 "\t rm -f " ++ unwords [
				         "Doc" ++ name ++ ".*",
				         "Lex" ++ name ++ ".*",
				         "Par" ++ name ++ ".*",
				         "Skel" ++ name ++ ".*",
				         "Print" ++ name ++ ".*",
			                 "Test" ++ name ++ ".*",
					 "Abs" ++ name ++ ".*", 
					 "test" ++ name,
					 "ErrM.*",
					 "Makefile*"
                                        ]
		]

testfile :: String -> CF -> String
testfile name cf = let lay = hasLayout cf in unlines
	        ["-- automatically generated by BNF Converter",
		 "module Main where\n",
	         "",
	         "import IO ( stdin, hGetContents )",
	         "import System ( getArgs, getProgName )",
		 "",
		 "import " ++ alexFileM name,
		 "import " ++ happyFileM name,
		 "import " ++ templateFileM name,
	         "import " ++ printerFileM name,
	         "import " ++ absFileM name,
	         if lay then ("import " ++ layoutFileM name) else "",
	         "import ErrM",
		 "",
		 "type ParseFun a = [Token] -> Err a",
	         "",
                 "myLLexer = " ++ if lay then "resolveLayout True . myLexer" 
                                         else "myLexer",
                 "",
		 "runFile :: (Print a, Show a) => ParseFun a -> FilePath -> IO ()",
		 "runFile p f = readFile f >>= run p",
		 "",
		 "run :: (Print a, Show a) => ParseFun a -> String -> IO ()",
		 "run p s = case (p (myLLexer s)) of",
                 "           Bad s    -> do  putStrLn \"\\nParse Failed...\\n\"",
                 "                           putStrLn s",
		 "           Ok  tree -> do putStrLn \"\\nParse Successful!\"",
		 "                          putStrLn $ \"\\n[Abstract Syntax]\\n\\n\" ++ show tree",
                 "                          putStrLn $ \"\\n[Linearized tree]\\n\\n\" ++ printTree tree",
		 "",
		 "main :: IO ()",
		 "main = do args <- getArgs",
		 "          case args of",
		 "            []  -> hGetContents stdin >>= run " ++ firstParser,
		 "            [f] -> runFile " ++ firstParser ++ " f",
		 "            _   -> do progName <- getProgName",
		 "                      putStrLn $ progName ++ \": excess arguments.\""
		 ]
		  where firstParser = 'p' : firstEntry cf

errM :: a -> b -> String
errM _ _ = unlines
	   [
	    "-- BNF Converter: Error Monad",
	    "-- Copyright (C) 2004  Author:  Aarne Ranta",
	    "",
	    "-- This file comes with NO WARRANTY and may be used FOR ANY PURPOSE.",
	    "module ErrM where",
	    "",
	    "-- the Error monad: like Maybe type with error msgs",
	    "",
	    "data Err a = Ok a | Bad String",
	    "  deriving (Read, Show, Eq)",
	    "",
	    "instance Monad Err where",
	    "  return      = Ok",
	    "  Ok a  >>= f = f a",
	    "  Bad s >>= f = Bad s"
	   ]

{-		 

makeGF :: FilePath -> IO ()
makeGF file = do
  let name = takeWhile (/= '.') file
  cf <- readCF $ name
  writeFileRep (gfAbs name)        $ cf2AbsGF     name cf
  writeFileRep (gfConc name)       $ cf2ConcGF    name cf
  putStrLn $ "Done!"

readCF :: FilePath -> IO CF
readCF f = tryReadCF f >>= return . fst

tryReadCF :: FilePath -> IO (CF,Bool)
tryReadCF name = do
  s <- readFile $ cfFile name
  putStrLn $ "\nReading grammar from " ++ name
  let (cf,msg) = getCF s
  if not (null msg) then do
    putStrLn $ unlines msg
    return (cf,False)
   else do
    putStrLn $ show (length (rulesOfCF cf)) +++ "rules accepted\n"
    case (notUniqueFuns cf) of
     [] -> return (cf,True)
     xs -> do  
       putStrLn $ "Warning :" 
       putStrLn $ "  Non-unique label name(s) : " ++ unwords xs
       putStrLn $ "  There may be problems with the pretty-printer.\n"
       return (cf, True)

writeFileRep :: FilePath -> String -> IO()
writeFileRep f s = writeFile f s >> putStrLn ("wrote file " ++ f)
-}
