// TodoList.H  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef TODOLIST_H
#define TODOLIST_H

#include <multiset.h>
#include <time.h>

#include "String.H"

class TodoList;

class TodoListItem {
  String line;
  time_t when;
public:
  TodoListItem(String l, time_t w)
    : line(l), when(w) { }

  bool operator<(const TodoListItem &t) const
    { return when < t.when; }

  friend class TodoList;
};

class TodoList {

  multiset<TodoListItem, less<TodoListItem> > todoQueue;

public:
  TodoList();
  ~TodoList();

  void addDeban(String, String, time_t);

  String getNext();
};

#endif
