/////////////////////////////////////////////////////////////////////////
// $Id: ia_opcodes.h,v 1.30 2009/10/24 11:17:51 sshwarts Exp $
/////////////////////////////////////////////////////////////////////////
//
//   Copyright (c) 2008-2009 Stanislav Shwartsman
//          Written by Stanislav Shwartsman [sshwarts at sourceforge net]
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA B 02110-1301 USA
//
/////////////////////////////////////////////////////////////////////////

bx_define_opcode(BX_IA_AAA, &BX_CPU_C::AAA, NULL)
bx_define_opcode(BX_IA_AAD, &BX_CPU_C::AAD, NULL)
bx_define_opcode(BX_IA_AAM, &BX_CPU_C::AAM, NULL)
bx_define_opcode(BX_IA_AAS, &BX_CPU_C::AAS, NULL)
bx_define_opcode(BX_IA_DAA, &BX_CPU_C::DAA, NULL)
bx_define_opcode(BX_IA_DAS, &BX_CPU_C::DAS, NULL)
bx_define_opcode(BX_IA_ADC_ALIb, &BX_CPU_C::ADC_ALIb, NULL)
bx_define_opcode(BX_IA_ADC_AXIw, &BX_CPU_C::ADC_AXIw, NULL)
bx_define_opcode(BX_IA_ADC_EAXId, &BX_CPU_C::ADC_EAXId, NULL)
bx_define_opcode(BX_IA_ADC_EbGbM, &BX_CPU_C::ADC_EbGbM, NULL)
bx_define_opcode(BX_IA_ADC_EbIbM, &BX_CPU_C::ADC_EbIbM, NULL)
bx_define_opcode(BX_IA_ADC_EbIbR, &BX_CPU_C::ADC_EbIbR, NULL)
bx_define_opcode(BX_IA_ADC_EdGdM, &BX_CPU_C::ADC_EdGdM, NULL)
bx_define_opcode(BX_IA_ADC_EdIdM, &BX_CPU_C::ADC_EdIdM, NULL)
bx_define_opcode(BX_IA_ADC_EdIdR, &BX_CPU_C::ADC_EdIdR, NULL)
bx_define_opcode(BX_IA_ADC_EwGwM, &BX_CPU_C::ADC_EwGwM, NULL)
bx_define_opcode(BX_IA_ADC_EwIwM, &BX_CPU_C::ADC_EwIwM, NULL)
bx_define_opcode(BX_IA_ADC_EwIwR, &BX_CPU_C::ADC_EwIwR, NULL)
bx_define_opcode(BX_IA_ADC_GbEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::ADC_GbEbR)
bx_define_opcode(BX_IA_ADC_GbEbR, &BX_CPU_C::ADC_GbEbR, NULL)
bx_define_opcode(BX_IA_ADC_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::ADC_GdEdR)
bx_define_opcode(BX_IA_ADC_GdEdR, &BX_CPU_C::ADC_GdEdR, NULL)
bx_define_opcode(BX_IA_ADC_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::ADC_GwEwR)
bx_define_opcode(BX_IA_ADC_GwEwR, &BX_CPU_C::ADC_GwEwR, NULL)
bx_define_opcode(BX_IA_ADD_ALIb, &BX_CPU_C::ADD_ALIb, NULL)
bx_define_opcode(BX_IA_ADD_AXIw, &BX_CPU_C::ADD_AXIw, NULL)
bx_define_opcode(BX_IA_ADD_EAXId, &BX_CPU_C::ADD_EAXId, NULL)
bx_define_opcode(BX_IA_ADD_EbGbM, &BX_CPU_C::ADD_EbGbM, NULL)
bx_define_opcode(BX_IA_ADD_EbIbM, &BX_CPU_C::ADD_EbIbM, NULL)
bx_define_opcode(BX_IA_ADD_EbIbR, &BX_CPU_C::ADD_EbIbR, NULL)
bx_define_opcode(BX_IA_ADD_EdGdM, &BX_CPU_C::ADD_EdGdM, NULL)
bx_define_opcode(BX_IA_ADD_EdIdM, &BX_CPU_C::ADD_EdIdM, NULL)
bx_define_opcode(BX_IA_ADD_EdIdR, &BX_CPU_C::ADD_EdIdR, NULL)
bx_define_opcode(BX_IA_ADD_EwGwM, &BX_CPU_C::ADD_EwGwM, NULL)
bx_define_opcode(BX_IA_ADD_EwIwM, &BX_CPU_C::ADD_EwIwM, NULL)
bx_define_opcode(BX_IA_ADD_EwIwR, &BX_CPU_C::ADD_EwIwR, NULL)
bx_define_opcode(BX_IA_ADD_GbEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::ADD_GbEbR)
bx_define_opcode(BX_IA_ADD_GbEbR, &BX_CPU_C::ADD_GbEbR, NULL)
bx_define_opcode(BX_IA_ADD_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::ADD_GdEdR)
bx_define_opcode(BX_IA_ADD_GdEdR, &BX_CPU_C::ADD_GdEdR, NULL)
bx_define_opcode(BX_IA_ADD_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::ADD_GwEwR)
bx_define_opcode(BX_IA_ADD_GwEwR, &BX_CPU_C::ADD_GwEwR, NULL)
bx_define_opcode(BX_IA_AND_ALIb, &BX_CPU_C::AND_ALIb, NULL)
bx_define_opcode(BX_IA_AND_AXIw, &BX_CPU_C::AND_AXIw, NULL)
bx_define_opcode(BX_IA_AND_EAXId, &BX_CPU_C::AND_EAXId, NULL)
bx_define_opcode(BX_IA_AND_EbGbM, &BX_CPU_C::AND_EbGbM, NULL)
bx_define_opcode(BX_IA_AND_EbIbM, &BX_CPU_C::AND_EbIbM, NULL)
bx_define_opcode(BX_IA_AND_EbIbR, &BX_CPU_C::AND_EbIbR, NULL)
bx_define_opcode(BX_IA_AND_EdGdM, &BX_CPU_C::AND_EdGdM, NULL)
bx_define_opcode(BX_IA_AND_EdIdM, &BX_CPU_C::AND_EdIdM, NULL)
bx_define_opcode(BX_IA_AND_EdIdR, &BX_CPU_C::AND_EdIdR, NULL)
bx_define_opcode(BX_IA_AND_EwGwM, &BX_CPU_C::AND_EwGwM, NULL)
bx_define_opcode(BX_IA_AND_EwIwM, &BX_CPU_C::AND_EwIwM, NULL)
bx_define_opcode(BX_IA_AND_EwIwR, &BX_CPU_C::AND_EwIwR, NULL)
bx_define_opcode(BX_IA_AND_GbEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::AND_GbEbR)
bx_define_opcode(BX_IA_AND_GbEbR, &BX_CPU_C::AND_GbEbR, NULL)
bx_define_opcode(BX_IA_AND_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::AND_GdEdR)
bx_define_opcode(BX_IA_AND_GdEdR, &BX_CPU_C::AND_GdEdR, NULL)
bx_define_opcode(BX_IA_AND_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::AND_GwEwR)
bx_define_opcode(BX_IA_AND_GwEwR, &BX_CPU_C::AND_GwEwR, NULL)
bx_define_opcode(BX_IA_ARPL_EwGw, &BX_CPU_C::ARPL_EwGw, NULL)
bx_define_opcode(BX_IA_BOUND_GdMa, &BX_CPU_C::BOUND_GdMa, NULL)
bx_define_opcode(BX_IA_BOUND_GwMa, &BX_CPU_C::BOUND_GwMa, NULL)
bx_define_opcode(BX_IA_BSF_GdEdR, &BX_CPU_C::BSF_GdEdR, NULL)
bx_define_opcode(BX_IA_BSF_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::BSF_GdEdR)
bx_define_opcode(BX_IA_BSF_GwEwR, &BX_CPU_C::BSF_GwEwR, NULL)
bx_define_opcode(BX_IA_BSF_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::BSF_GwEwR)
bx_define_opcode(BX_IA_BSR_GdEdR, &BX_CPU_C::BSR_GdEdR, NULL)
bx_define_opcode(BX_IA_BSR_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::BSR_GdEdR)
bx_define_opcode(BX_IA_BSR_GwEwR, &BX_CPU_C::BSR_GwEwR, NULL)
bx_define_opcode(BX_IA_BSR_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::BSR_GwEwR)
bx_define_opcode(BX_IA_BSWAP_ERX, &BX_CPU_C::BSWAP_ERX, NULL)
bx_define_opcode(BX_IA_BT_EdGdM, &BX_CPU_C::BT_EdGdM, NULL)
bx_define_opcode(BX_IA_BT_EdGdR, &BX_CPU_C::BT_EdGdR, NULL)
bx_define_opcode(BX_IA_BT_EdIbM, &BX_CPU_C::BT_EdIbM, NULL)
bx_define_opcode(BX_IA_BT_EdIbR, &BX_CPU_C::BT_EdIbR, NULL)
bx_define_opcode(BX_IA_BT_EwGwM, &BX_CPU_C::BT_EwGwM, NULL)
bx_define_opcode(BX_IA_BT_EwGwR, &BX_CPU_C::BT_EwGwR, NULL)
bx_define_opcode(BX_IA_BT_EwIbM, &BX_CPU_C::BT_EwIbM, NULL)
bx_define_opcode(BX_IA_BT_EwIbR, &BX_CPU_C::BT_EwIbR, NULL)
bx_define_opcode(BX_IA_BTC_EdGdM, &BX_CPU_C::BTC_EdGdM, NULL)
bx_define_opcode(BX_IA_BTC_EdGdR, &BX_CPU_C::BTC_EdGdR, NULL)
bx_define_opcode(BX_IA_BTC_EdIbM, &BX_CPU_C::BTC_EdIbM, NULL)
bx_define_opcode(BX_IA_BTC_EdIbR, &BX_CPU_C::BTC_EdIbR, NULL)
bx_define_opcode(BX_IA_BTC_EwGwM, &BX_CPU_C::BTC_EwGwM, NULL)
bx_define_opcode(BX_IA_BTC_EwGwR, &BX_CPU_C::BTC_EwGwR, NULL)
bx_define_opcode(BX_IA_BTC_EwIbM, &BX_CPU_C::BTC_EwIbM, NULL)
bx_define_opcode(BX_IA_BTC_EwIbR, &BX_CPU_C::BTC_EwIbR, NULL)
bx_define_opcode(BX_IA_BTR_EdGdM, &BX_CPU_C::BTR_EdGdM, NULL)
bx_define_opcode(BX_IA_BTR_EdGdR, &BX_CPU_C::BTR_EdGdR, NULL)
bx_define_opcode(BX_IA_BTR_EdIbM, &BX_CPU_C::BTR_EdIbM, NULL)
bx_define_opcode(BX_IA_BTR_EdIbR, &BX_CPU_C::BTR_EdIbR, NULL)
bx_define_opcode(BX_IA_BTR_EwGwM, &BX_CPU_C::BTR_EwGwM, NULL)
bx_define_opcode(BX_IA_BTR_EwGwR, &BX_CPU_C::BTR_EwGwR, NULL)
bx_define_opcode(BX_IA_BTR_EwIbM, &BX_CPU_C::BTR_EwIbM, NULL)
bx_define_opcode(BX_IA_BTR_EwIbR, &BX_CPU_C::BTR_EwIbR, NULL)
bx_define_opcode(BX_IA_BTS_EdGdM, &BX_CPU_C::BTS_EdGdM, NULL)
bx_define_opcode(BX_IA_BTS_EdGdR, &BX_CPU_C::BTS_EdGdR, NULL)
bx_define_opcode(BX_IA_BTS_EdIbM, &BX_CPU_C::BTS_EdIbM, NULL)
bx_define_opcode(BX_IA_BTS_EdIbR, &BX_CPU_C::BTS_EdIbR, NULL)
bx_define_opcode(BX_IA_BTS_EwGwM, &BX_CPU_C::BTS_EwGwM, NULL)
bx_define_opcode(BX_IA_BTS_EwGwR, &BX_CPU_C::BTS_EwGwR, NULL)
bx_define_opcode(BX_IA_BTS_EwIbM, &BX_CPU_C::BTS_EwIbM, NULL)
bx_define_opcode(BX_IA_BTS_EwIbR, &BX_CPU_C::BTS_EwIbR, NULL)
bx_define_opcode(BX_IA_ERROR, &BX_CPU_C::BxError, NULL)
bx_define_opcode(BX_IA_CALL_EdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CALL_EdR)
bx_define_opcode(BX_IA_CALL_EdR, &BX_CPU_C::CALL_EdR, NULL)
bx_define_opcode(BX_IA_CALL_EwM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CALL_EwR)
bx_define_opcode(BX_IA_CALL_EwR, &BX_CPU_C::CALL_EwR, NULL)
bx_define_opcode(BX_IA_CALL_Jd, &BX_CPU_C::CALL_Jd, NULL)
bx_define_opcode(BX_IA_CALL_Jw, &BX_CPU_C::CALL_Jw, NULL)
bx_define_opcode(BX_IA_CALL16_Ap, &BX_CPU_C::CALL16_Ap, NULL)
bx_define_opcode(BX_IA_CALL16_Ep, &BX_CPU_C::CALL16_Ep, NULL)
bx_define_opcode(BX_IA_CALL32_Ap, &BX_CPU_C::CALL32_Ap, NULL)
bx_define_opcode(BX_IA_CALL32_Ep, &BX_CPU_C::CALL32_Ep, NULL)
bx_define_opcode(BX_IA_CBW, &BX_CPU_C::CBW, NULL)
bx_define_opcode(BX_IA_CDQ, &BX_CPU_C::CDQ, NULL)
bx_define_opcode(BX_IA_CLC, &BX_CPU_C::CLC, NULL)
bx_define_opcode(BX_IA_CLD, &BX_CPU_C::CLD, NULL)
bx_define_opcode(BX_IA_CLFLUSH, &BX_CPU_C::CLFLUSH, NULL)
bx_define_opcode(BX_IA_CLI, &BX_CPU_C::CLI, NULL)
bx_define_opcode(BX_IA_CLTS, &BX_CPU_C::CLTS, NULL)
bx_define_opcode(BX_IA_CMC, &BX_CPU_C::CMC, NULL)
bx_define_opcode(BX_IA_CMOVB_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVB_GdEdR)
bx_define_opcode(BX_IA_CMOVB_GdEdR, &BX_CPU_C::CMOVB_GdEdR, NULL)
bx_define_opcode(BX_IA_CMOVB_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVB_GwEwR)
bx_define_opcode(BX_IA_CMOVB_GwEwR, &BX_CPU_C::CMOVB_GwEwR, NULL)
bx_define_opcode(BX_IA_CMOVBE_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVBE_GdEdR)
bx_define_opcode(BX_IA_CMOVBE_GdEdR, &BX_CPU_C::CMOVBE_GdEdR, NULL)
bx_define_opcode(BX_IA_CMOVBE_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVBE_GwEwR)
bx_define_opcode(BX_IA_CMOVBE_GwEwR, &BX_CPU_C::CMOVBE_GwEwR, NULL)
bx_define_opcode(BX_IA_CMOVL_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVL_GdEdR)
bx_define_opcode(BX_IA_CMOVL_GdEdR, &BX_CPU_C::CMOVL_GdEdR, NULL)
bx_define_opcode(BX_IA_CMOVL_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVL_GwEwR)
bx_define_opcode(BX_IA_CMOVL_GwEwR, &BX_CPU_C::CMOVL_GwEwR, NULL)
bx_define_opcode(BX_IA_CMOVLE_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVLE_GdEdR)
bx_define_opcode(BX_IA_CMOVLE_GdEdR, &BX_CPU_C::CMOVLE_GdEdR, NULL)
bx_define_opcode(BX_IA_CMOVLE_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVLE_GwEwR)
bx_define_opcode(BX_IA_CMOVLE_GwEwR, &BX_CPU_C::CMOVLE_GwEwR, NULL)
bx_define_opcode(BX_IA_CMOVNB_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNB_GdEdR)
bx_define_opcode(BX_IA_CMOVNB_GdEdR, &BX_CPU_C::CMOVNB_GdEdR, NULL)
bx_define_opcode(BX_IA_CMOVNB_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNB_GwEwR)
bx_define_opcode(BX_IA_CMOVNB_GwEwR, &BX_CPU_C::CMOVNB_GwEwR, NULL)
bx_define_opcode(BX_IA_CMOVNBE_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNBE_GdEdR)
bx_define_opcode(BX_IA_CMOVNBE_GdEdR, &BX_CPU_C::CMOVNBE_GdEdR, NULL)
bx_define_opcode(BX_IA_CMOVNBE_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNBE_GwEwR)
bx_define_opcode(BX_IA_CMOVNBE_GwEwR, &BX_CPU_C::CMOVNBE_GwEwR, NULL)
bx_define_opcode(BX_IA_CMOVNL_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNL_GdEdR)
bx_define_opcode(BX_IA_CMOVNL_GdEdR, &BX_CPU_C::CMOVNL_GdEdR, NULL)
bx_define_opcode(BX_IA_CMOVNL_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNL_GwEwR)
bx_define_opcode(BX_IA_CMOVNL_GwEwR, &BX_CPU_C::CMOVNL_GwEwR, NULL)
bx_define_opcode(BX_IA_CMOVNLE_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNLE_GdEdR)
bx_define_opcode(BX_IA_CMOVNLE_GdEdR, &BX_CPU_C::CMOVNLE_GdEdR, NULL)
bx_define_opcode(BX_IA_CMOVNLE_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNLE_GwEwR)
bx_define_opcode(BX_IA_CMOVNLE_GwEwR, &BX_CPU_C::CMOVNLE_GwEwR, NULL)
bx_define_opcode(BX_IA_CMOVNO_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNO_GdEdR)
bx_define_opcode(BX_IA_CMOVNO_GdEdR, &BX_CPU_C::CMOVNO_GdEdR, NULL)
bx_define_opcode(BX_IA_CMOVNO_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNO_GwEwR)
bx_define_opcode(BX_IA_CMOVNO_GwEwR, &BX_CPU_C::CMOVNO_GwEwR, NULL)
bx_define_opcode(BX_IA_CMOVNP_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNP_GdEdR)
bx_define_opcode(BX_IA_CMOVNP_GdEdR, &BX_CPU_C::CMOVNP_GdEdR, NULL)
bx_define_opcode(BX_IA_CMOVNP_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNP_GwEwR)
bx_define_opcode(BX_IA_CMOVNP_GwEwR, &BX_CPU_C::CMOVNP_GwEwR, NULL)
bx_define_opcode(BX_IA_CMOVNS_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNS_GdEdR)
bx_define_opcode(BX_IA_CMOVNS_GdEdR, &BX_CPU_C::CMOVNS_GdEdR, NULL)
bx_define_opcode(BX_IA_CMOVNS_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNS_GwEwR)
bx_define_opcode(BX_IA_CMOVNS_GwEwR, &BX_CPU_C::CMOVNS_GwEwR, NULL)
bx_define_opcode(BX_IA_CMOVNZ_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNZ_GdEdR)
bx_define_opcode(BX_IA_CMOVNZ_GdEdR, &BX_CPU_C::CMOVNZ_GdEdR, NULL)
bx_define_opcode(BX_IA_CMOVNZ_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNZ_GwEwR)
bx_define_opcode(BX_IA_CMOVNZ_GwEwR, &BX_CPU_C::CMOVNZ_GwEwR, NULL)
bx_define_opcode(BX_IA_CMOVO_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVO_GdEdR)
bx_define_opcode(BX_IA_CMOVO_GdEdR, &BX_CPU_C::CMOVO_GdEdR, NULL)
bx_define_opcode(BX_IA_CMOVO_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVO_GwEwR)
bx_define_opcode(BX_IA_CMOVO_GwEwR, &BX_CPU_C::CMOVO_GwEwR, NULL)
bx_define_opcode(BX_IA_CMOVP_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVP_GdEdR)
bx_define_opcode(BX_IA_CMOVP_GdEdR, &BX_CPU_C::CMOVP_GdEdR, NULL)
bx_define_opcode(BX_IA_CMOVP_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVP_GwEwR)
bx_define_opcode(BX_IA_CMOVP_GwEwR, &BX_CPU_C::CMOVP_GwEwR, NULL)
bx_define_opcode(BX_IA_CMOVS_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVS_GdEdR)
bx_define_opcode(BX_IA_CMOVS_GdEdR, &BX_CPU_C::CMOVS_GdEdR, NULL)
bx_define_opcode(BX_IA_CMOVS_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVS_GwEwR)
bx_define_opcode(BX_IA_CMOVS_GwEwR, &BX_CPU_C::CMOVS_GwEwR, NULL)
bx_define_opcode(BX_IA_CMOVZ_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVZ_GdEdR)
bx_define_opcode(BX_IA_CMOVZ_GdEdR, &BX_CPU_C::CMOVZ_GdEdR, NULL)
bx_define_opcode(BX_IA_CMOVZ_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVZ_GwEwR)
bx_define_opcode(BX_IA_CMOVZ_GwEwR, &BX_CPU_C::CMOVZ_GwEwR, NULL)
bx_define_opcode(BX_IA_CMP_ALIb, &BX_CPU_C::CMP_ALIb, NULL)
bx_define_opcode(BX_IA_CMP_AXIw, &BX_CPU_C::CMP_AXIw, NULL)
bx_define_opcode(BX_IA_CMP_EAXId, &BX_CPU_C::CMP_EAXId, NULL)
bx_define_opcode(BX_IA_CMP_EbGbM, &BX_CPU_C::CMP_EbGbM, NULL)
bx_define_opcode(BX_IA_CMP_EbIbM, &BX_CPU_C::CMP_EbIbM, NULL)
bx_define_opcode(BX_IA_CMP_EbIbR, &BX_CPU_C::CMP_EbIbR, NULL)
bx_define_opcode(BX_IA_CMP_EdGdM, &BX_CPU_C::CMP_EdGdM, NULL)
bx_define_opcode(BX_IA_CMP_EdIdM, &BX_CPU_C::CMP_EdIdM, NULL)
bx_define_opcode(BX_IA_CMP_EdIdR, &BX_CPU_C::CMP_EdIdR, NULL)
bx_define_opcode(BX_IA_CMP_EwGwM, &BX_CPU_C::CMP_EwGwM, NULL)
bx_define_opcode(BX_IA_CMP_EwIwM, &BX_CPU_C::CMP_EwIwM, NULL)
bx_define_opcode(BX_IA_CMP_EwIwR, &BX_CPU_C::CMP_EwIwR, NULL)
bx_define_opcode(BX_IA_CMP_GbEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::CMP_GbEbR)
bx_define_opcode(BX_IA_CMP_GbEbR, &BX_CPU_C::CMP_GbEbR, NULL)
bx_define_opcode(BX_IA_CMP_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMP_GdEdR)
bx_define_opcode(BX_IA_CMP_GdEdR, &BX_CPU_C::CMP_GdEdR, NULL)
bx_define_opcode(BX_IA_CMP_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMP_GwEwR)
bx_define_opcode(BX_IA_CMP_GwEwR, &BX_CPU_C::CMP_GwEwR, NULL)
bx_define_opcode(BX_IA_CMPXCHG_EbGbM, &BX_CPU_C::CMPXCHG_EbGbM, NULL)
bx_define_opcode(BX_IA_CMPXCHG_EbGbR, &BX_CPU_C::CMPXCHG_EbGbR, NULL)
bx_define_opcode(BX_IA_CMPXCHG_EdGdM, &BX_CPU_C::CMPXCHG_EdGdM, NULL)
bx_define_opcode(BX_IA_CMPXCHG_EdGdR, &BX_CPU_C::CMPXCHG_EdGdR, NULL)
bx_define_opcode(BX_IA_CMPXCHG_EwGwM, &BX_CPU_C::CMPXCHG_EwGwM, NULL)
bx_define_opcode(BX_IA_CMPXCHG_EwGwR, &BX_CPU_C::CMPXCHG_EwGwR, NULL)
bx_define_opcode(BX_IA_CMPXCHG_IBTS, &BX_CPU_C::CMPXCHG_IBTS, NULL)
bx_define_opcode(BX_IA_CMPXCHG_XBTS, &BX_CPU_C::CMPXCHG_XBTS, NULL)
bx_define_opcode(BX_IA_CMPXCHG8B, &BX_CPU_C::CMPXCHG8B, NULL)
bx_define_opcode(BX_IA_CPUID, &BX_CPU_C::CPUID, NULL)
bx_define_opcode(BX_IA_CWD, &BX_CPU_C::CWD, NULL)
bx_define_opcode(BX_IA_CWDE, &BX_CPU_C::CWDE, NULL)
bx_define_opcode(BX_IA_DEC_EbM, &BX_CPU_C::DEC_EbM, NULL)
bx_define_opcode(BX_IA_DEC_EbR, &BX_CPU_C::DEC_EbR, NULL)
bx_define_opcode(BX_IA_DEC_EdR, &BX_CPU_C::DEC_ERX, NULL)
bx_define_opcode(BX_IA_DEC_EdM, &BX_CPU_C::DEC_EdM, NULL)
bx_define_opcode(BX_IA_DEC_ERX, &BX_CPU_C::DEC_ERX, NULL)
bx_define_opcode(BX_IA_DEC_EwR, &BX_CPU_C::DEC_RX, NULL)
bx_define_opcode(BX_IA_DEC_EwM, &BX_CPU_C::DEC_EwM, NULL)
bx_define_opcode(BX_IA_DEC_RX, &BX_CPU_C::DEC_RX, NULL)
bx_define_opcode(BX_IA_DIV_ALEbR, &BX_CPU_C::DIV_ALEbR, NULL)
bx_define_opcode(BX_IA_DIV_ALEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::DIV_ALEbR)
bx_define_opcode(BX_IA_DIV_AXEwR, &BX_CPU_C::DIV_AXEwR, NULL)
bx_define_opcode(BX_IA_DIV_AXEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::DIV_AXEwR)
bx_define_opcode(BX_IA_DIV_EAXEdR, &BX_CPU_C::DIV_EAXEdR, NULL)
bx_define_opcode(BX_IA_DIV_EAXEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::DIV_EAXEdR)
bx_define_opcode(BX_IA_ENTER16_IwIb, &BX_CPU_C::ENTER16_IwIb, NULL)
bx_define_opcode(BX_IA_ENTER32_IwIb, &BX_CPU_C::ENTER32_IwIb, NULL)
bx_define_opcode(BX_IA_HLT, &BX_CPU_C::HLT, NULL)
bx_define_opcode(BX_IA_IDIV_ALEbR, &BX_CPU_C::IDIV_ALEbR, NULL)
bx_define_opcode(BX_IA_IDIV_ALEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::IDIV_ALEbR)
bx_define_opcode(BX_IA_IDIV_AXEwR, &BX_CPU_C::IDIV_AXEwR, NULL)
bx_define_opcode(BX_IA_IDIV_AXEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::IDIV_AXEwR)
bx_define_opcode(BX_IA_IDIV_EAXEdR, &BX_CPU_C::IDIV_EAXEdR, NULL)
bx_define_opcode(BX_IA_IDIV_EAXEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::IDIV_EAXEdR)
bx_define_opcode(BX_IA_IMUL_ALEbR, &BX_CPU_C::IMUL_ALEbR, NULL)
bx_define_opcode(BX_IA_IMUL_ALEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::IMUL_ALEbR)
bx_define_opcode(BX_IA_IMUL_AXEwR, &BX_CPU_C::IMUL_AXEwR, NULL)
bx_define_opcode(BX_IA_IMUL_AXEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::IMUL_AXEwR)
bx_define_opcode(BX_IA_IMUL_EAXEdR, &BX_CPU_C::IMUL_EAXEdR, NULL)
bx_define_opcode(BX_IA_IMUL_EAXEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::IMUL_EAXEdR)
bx_define_opcode(BX_IA_IMUL_GdEdR, &BX_CPU_C::IMUL_GdEdR, NULL)
bx_define_opcode(BX_IA_IMUL_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::IMUL_GdEdR)
bx_define_opcode(BX_IA_IMUL_GdEdIdR, &BX_CPU_C::IMUL_GdEdIdR, NULL)
bx_define_opcode(BX_IA_IMUL_GdEdIdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::IMUL_GdEdIdR)
bx_define_opcode(BX_IA_IMUL_GwEwR, &BX_CPU_C::IMUL_GwEwR, NULL)
bx_define_opcode(BX_IA_IMUL_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::IMUL_GwEwR)
bx_define_opcode(BX_IA_IMUL_GwEwIwR, &BX_CPU_C::IMUL_GwEwIwR, NULL)
bx_define_opcode(BX_IA_IMUL_GwEwIwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::IMUL_GwEwIwR)
bx_define_opcode(BX_IA_IN_ALDX, &BX_CPU_C::IN_ALDX, NULL)
bx_define_opcode(BX_IA_IN_ALIb, &BX_CPU_C::IN_ALIb, NULL)
bx_define_opcode(BX_IA_IN_AXDX, &BX_CPU_C::IN_AXDX, NULL)
bx_define_opcode(BX_IA_IN_AXIb, &BX_CPU_C::IN_AXIb, NULL)
bx_define_opcode(BX_IA_IN_EAXDX, &BX_CPU_C::IN_EAXDX, NULL)
bx_define_opcode(BX_IA_IN_EAXIb, &BX_CPU_C::IN_EAXIb, NULL)
bx_define_opcode(BX_IA_INC_EbM, &BX_CPU_C::INC_EbM, NULL)
bx_define_opcode(BX_IA_INC_EbR, &BX_CPU_C::INC_EbR, NULL)
bx_define_opcode(BX_IA_INC_EdR, &BX_CPU_C::INC_ERX, NULL)
bx_define_opcode(BX_IA_INC_EdM, &BX_CPU_C::INC_EdM, NULL)
bx_define_opcode(BX_IA_INC_ERX, &BX_CPU_C::INC_ERX, NULL)
bx_define_opcode(BX_IA_INC_EwR, &BX_CPU_C::INC_RX, NULL)
bx_define_opcode(BX_IA_INC_EwM, &BX_CPU_C::INC_EwM, NULL)
bx_define_opcode(BX_IA_INC_RX, &BX_CPU_C::INC_RX, NULL)
bx_define_opcode(BX_IA_INT_Ib, &BX_CPU_C::INT_Ib, NULL)
bx_define_opcode(BX_IA_INT1, &BX_CPU_C::INT1, NULL)
bx_define_opcode(BX_IA_INT3, &BX_CPU_C::INT3, NULL)
bx_define_opcode(BX_IA_INTO, &BX_CPU_C::INTO, NULL)
bx_define_opcode(BX_IA_INVD, &BX_CPU_C::INVD, NULL)
bx_define_opcode(BX_IA_INVLPG, &BX_CPU_C::INVLPG, NULL)
bx_define_opcode(BX_IA_IRET16, &BX_CPU_C::IRET16, NULL)
bx_define_opcode(BX_IA_IRET32, &BX_CPU_C::IRET32, NULL)
bx_define_opcode(BX_IA_JB_Jd, &BX_CPU_C::JB_Jd, NULL)
bx_define_opcode(BX_IA_JB_Jw, &BX_CPU_C::JB_Jw, NULL)
bx_define_opcode(BX_IA_JBE_Jd, &BX_CPU_C::JBE_Jd, NULL)
bx_define_opcode(BX_IA_JBE_Jw, &BX_CPU_C::JBE_Jw, NULL)
bx_define_opcode(BX_IA_JCXZ_Jb, &BX_CPU_C::JCXZ_Jb, NULL)
bx_define_opcode(BX_IA_JECXZ_Jb, &BX_CPU_C::JECXZ_Jb, NULL)
bx_define_opcode(BX_IA_JL_Jd, &BX_CPU_C::JL_Jd, NULL)
bx_define_opcode(BX_IA_JL_Jw, &BX_CPU_C::JL_Jw, NULL)
bx_define_opcode(BX_IA_JLE_Jd, &BX_CPU_C::JLE_Jd, NULL)
bx_define_opcode(BX_IA_JLE_Jw, &BX_CPU_C::JLE_Jw, NULL)
bx_define_opcode(BX_IA_JMP_Ap, &BX_CPU_C::JMP_Ap, NULL)
bx_define_opcode(BX_IA_JMP_EdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::JMP_EdR)
bx_define_opcode(BX_IA_JMP_EdR, &BX_CPU_C::JMP_EdR, NULL)
bx_define_opcode(BX_IA_JMP_EwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::JMP_EwR)
bx_define_opcode(BX_IA_JMP_EwR, &BX_CPU_C::JMP_EwR, NULL)
bx_define_opcode(BX_IA_JMP_Jd, &BX_CPU_C::JMP_Jd, NULL)
bx_define_opcode(BX_IA_JMP_Jw, &BX_CPU_C::JMP_Jw, NULL)
bx_define_opcode(BX_IA_JMP16_Ep, &BX_CPU_C::JMP16_Ep, NULL)
bx_define_opcode(BX_IA_JMP32_Ep, &BX_CPU_C::JMP32_Ep, NULL)
bx_define_opcode(BX_IA_JNB_Jd, &BX_CPU_C::JNB_Jd, NULL)
bx_define_opcode(BX_IA_JNB_Jw, &BX_CPU_C::JNB_Jw, NULL)
bx_define_opcode(BX_IA_JNBE_Jd, &BX_CPU_C::JNBE_Jd, NULL)
bx_define_opcode(BX_IA_JNBE_Jw, &BX_CPU_C::JNBE_Jw, NULL)
bx_define_opcode(BX_IA_JNL_Jd, &BX_CPU_C::JNL_Jd, NULL)
bx_define_opcode(BX_IA_JNL_Jw, &BX_CPU_C::JNL_Jw, NULL)
bx_define_opcode(BX_IA_JNLE_Jd, &BX_CPU_C::JNLE_Jd, NULL)
bx_define_opcode(BX_IA_JNLE_Jw, &BX_CPU_C::JNLE_Jw, NULL)
bx_define_opcode(BX_IA_JNO_Jd, &BX_CPU_C::JNO_Jd, NULL)
bx_define_opcode(BX_IA_JNO_Jw, &BX_CPU_C::JNO_Jw, NULL)
bx_define_opcode(BX_IA_JNP_Jd, &BX_CPU_C::JNP_Jd, NULL)
bx_define_opcode(BX_IA_JNP_Jw, &BX_CPU_C::JNP_Jw, NULL)
bx_define_opcode(BX_IA_JNS_Jd, &BX_CPU_C::JNS_Jd, NULL)
bx_define_opcode(BX_IA_JNS_Jw, &BX_CPU_C::JNS_Jw, NULL)
bx_define_opcode(BX_IA_JNZ_Jd, &BX_CPU_C::JNZ_Jd, NULL)
bx_define_opcode(BX_IA_JNZ_Jw, &BX_CPU_C::JNZ_Jw, NULL)
bx_define_opcode(BX_IA_JO_Jd, &BX_CPU_C::JO_Jd, NULL)
bx_define_opcode(BX_IA_JO_Jw, &BX_CPU_C::JO_Jw, NULL)
bx_define_opcode(BX_IA_JP_Jd, &BX_CPU_C::JP_Jd, NULL)
bx_define_opcode(BX_IA_JP_Jw, &BX_CPU_C::JP_Jw, NULL)
bx_define_opcode(BX_IA_JS_Jd, &BX_CPU_C::JS_Jd, NULL)
bx_define_opcode(BX_IA_JS_Jw, &BX_CPU_C::JS_Jw, NULL)
bx_define_opcode(BX_IA_JZ_Jd, &BX_CPU_C::JZ_Jd, NULL)
bx_define_opcode(BX_IA_JZ_Jw, &BX_CPU_C::JZ_Jw, NULL)
bx_define_opcode(BX_IA_LAHF, &BX_CPU_C::LAHF, NULL)
bx_define_opcode(BX_IA_LAR_GvEw, &BX_CPU_C::LAR_GvEw, NULL)
bx_define_opcode(BX_IA_LDS_GdMp, &BX_CPU_C::LDS_GdMp, NULL)
bx_define_opcode(BX_IA_LDS_GwMp, &BX_CPU_C::LDS_GwMp, NULL)
bx_define_opcode(BX_IA_LEA_GdM, &BX_CPU_C::LEA_GdM, NULL)
bx_define_opcode(BX_IA_LEA_GwM, &BX_CPU_C::LEA_GwM, NULL)
bx_define_opcode(BX_IA_LEAVE16, &BX_CPU_C::LEAVE16, NULL)
bx_define_opcode(BX_IA_LEAVE32, &BX_CPU_C::LEAVE32, NULL)
bx_define_opcode(BX_IA_LES_GdMp, &BX_CPU_C::LES_GdMp, NULL)
bx_define_opcode(BX_IA_LES_GwMp, &BX_CPU_C::LES_GwMp, NULL)
bx_define_opcode(BX_IA_LFS_GdMp, &BX_CPU_C::LFS_GdMp, NULL)
bx_define_opcode(BX_IA_LFS_GwMp, &BX_CPU_C::LFS_GwMp, NULL)
bx_define_opcode(BX_IA_LGDT_Ms, &BX_CPU_C::LGDT_Ms, NULL)
bx_define_opcode(BX_IA_LGS_GdMp, &BX_CPU_C::LGS_GdMp, NULL)
bx_define_opcode(BX_IA_LGS_GwMp, &BX_CPU_C::LGS_GwMp, NULL)
bx_define_opcode(BX_IA_LIDT_Ms, &BX_CPU_C::LIDT_Ms, NULL)
bx_define_opcode(BX_IA_LLDT_Ew, &BX_CPU_C::LLDT_Ew, NULL)
bx_define_opcode(BX_IA_LMSW_Ew, &BX_CPU_C::LMSW_Ew, NULL)
bx_define_opcode(BX_IA_LOOP16_Jb, &BX_CPU_C::LOOP16_Jb, NULL)
bx_define_opcode(BX_IA_LOOPE16_Jb, &BX_CPU_C::LOOPE16_Jb, NULL)
bx_define_opcode(BX_IA_LOOPNE16_Jb, &BX_CPU_C::LOOPNE16_Jb, NULL)
bx_define_opcode(BX_IA_LOOP32_Jb, &BX_CPU_C::LOOP32_Jb, NULL)
bx_define_opcode(BX_IA_LOOPE32_Jb, &BX_CPU_C::LOOPE32_Jb, NULL)
bx_define_opcode(BX_IA_LOOPNE32_Jb, &BX_CPU_C::LOOPNE32_Jb, NULL)
bx_define_opcode(BX_IA_LSL_GvEw, &BX_CPU_C::LSL_GvEw, NULL)
bx_define_opcode(BX_IA_LSS_GdMp, &BX_CPU_C::LSS_GdMp, NULL)
bx_define_opcode(BX_IA_LSS_GwMp, &BX_CPU_C::LSS_GwMp, NULL)
bx_define_opcode(BX_IA_LTR_Ew, &BX_CPU_C::LTR_Ew, NULL)
bx_define_opcode(BX_IA_MONITOR, &BX_CPU_C::MONITOR, NULL)
bx_define_opcode(BX_IA_MWAIT, &BX_CPU_C::MWAIT, NULL)
bx_define_opcode(BX_IA_MOV_ALOd, &BX_CPU_C::MOV_ALOd, NULL)
bx_define_opcode(BX_IA_MOV_AXOd, &BX_CPU_C::MOV_AXOd, NULL)
bx_define_opcode(BX_IA_MOV_CdRd, &BX_CPU_C::MOV_CdRd, NULL)
bx_define_opcode(BX_IA_MOV_DdRd, &BX_CPU_C::MOV_DdRd, NULL)
bx_define_opcode(BX_IA_MOV_EAXOd, &BX_CPU_C::MOV_EAXOd, NULL)
bx_define_opcode(BX_IA_MOV_EbGbM, &BX_CPU_C::MOV_EbGbM, NULL)
bx_define_opcode(BX_IA_MOV_EbIbM, &BX_CPU_C::MOV_EbIbM, NULL)
bx_define_opcode(BX_IA_MOV_EbIbR, &BX_CPU_C::MOV_RLIb, NULL)
bx_define_opcode(BX_IA_MOV_EdIdM, &BX_CPU_C::MOV_EdIdM, NULL)
bx_define_opcode(BX_IA_MOV_EdIdR, &BX_CPU_C::MOV_ERXId, NULL)
bx_define_opcode(BX_IA_MOV_ERXId, &BX_CPU_C::MOV_ERXId, NULL)
bx_define_opcode(BX_IA_MOV_EwGwM, &BX_CPU_C::MOV_EwGwM, NULL)
bx_define_opcode(BX_IA_MOV_EwIwM, &BX_CPU_C::MOV_EwIwM, NULL)
bx_define_opcode(BX_IA_MOV_EwIwR, &BX_CPU_C::MOV_RXIw, NULL)
bx_define_opcode(BX_IA_MOV_EwSwM, &BX_CPU_C::MOV_EwSwM, NULL)
bx_define_opcode(BX_IA_MOV_EwSwR, &BX_CPU_C::MOV_EwSwR, NULL)
bx_define_opcode(BX_IA_MOV_GbEbM, &BX_CPU_C::MOV_GbEbM, NULL)
bx_define_opcode(BX_IA_MOV_GbEbR, &BX_CPU_C::MOV_GbEbR, NULL)
bx_define_opcode(BX_IA_MOV32_EdGdM, &BX_CPU_C::MOV32_EdGdM, NULL)
bx_define_opcode(BX_IA_MOV32_GdEdM, &BX_CPU_C::MOV32_GdEdM, NULL)
bx_define_opcode(BX_IA_MOV_GdEdR, &BX_CPU_C::MOV_GdEdR, NULL)
bx_define_opcode(BX_IA_MOV_GwEwM, &BX_CPU_C::MOV_GwEwM, NULL)
bx_define_opcode(BX_IA_MOV_GwEwR, &BX_CPU_C::MOV_GwEwR, NULL)
bx_define_opcode(BX_IA_MOV_OdAL, &BX_CPU_C::MOV_OdAL, NULL)
bx_define_opcode(BX_IA_MOV_OdAX, &BX_CPU_C::MOV_OdAX, NULL)
bx_define_opcode(BX_IA_MOV_OdEAX, &BX_CPU_C::MOV_OdEAX, NULL)
bx_define_opcode(BX_IA_MOV_RdCd, &BX_CPU_C::MOV_RdCd, NULL)
bx_define_opcode(BX_IA_MOV_RdDd, &BX_CPU_C::MOV_RdDd, NULL)
bx_define_opcode(BX_IA_MOV_RdTd, &BX_CPU_C::MOV_RdTd, NULL)
bx_define_opcode(BX_IA_MOV_RHIb, &BX_CPU_C::MOV_RHIb, NULL)
bx_define_opcode(BX_IA_MOV_RLIb, &BX_CPU_C::MOV_RLIb, NULL)
bx_define_opcode(BX_IA_MOV_RXIw, &BX_CPU_C::MOV_RXIw, NULL)
bx_define_opcode(BX_IA_MOV_SwEw, &BX_CPU_C::MOV_SwEw, NULL)
bx_define_opcode(BX_IA_MOV_TdRd, &BX_CPU_C::MOV_TdRd, NULL)
bx_define_opcode(BX_IA_MOVSX_GdEbM, &BX_CPU_C::MOVSX_GdEbM, NULL)
bx_define_opcode(BX_IA_MOVSX_GdEbR, &BX_CPU_C::MOVSX_GdEbR, NULL)
bx_define_opcode(BX_IA_MOVSX_GdEwM, &BX_CPU_C::MOVSX_GdEwM, NULL)
bx_define_opcode(BX_IA_MOVSX_GdEwR, &BX_CPU_C::MOVSX_GdEwR, NULL)
bx_define_opcode(BX_IA_MOVSX_GwEbM, &BX_CPU_C::MOVSX_GwEbM, NULL)
bx_define_opcode(BX_IA_MOVSX_GwEbR, &BX_CPU_C::MOVSX_GwEbR, NULL)
bx_define_opcode(BX_IA_MOVZX_GdEbM, &BX_CPU_C::MOVZX_GdEbM, NULL)
bx_define_opcode(BX_IA_MOVZX_GdEbR, &BX_CPU_C::MOVZX_GdEbR, NULL)
bx_define_opcode(BX_IA_MOVZX_GdEwM, &BX_CPU_C::MOVZX_GdEwM, NULL)
bx_define_opcode(BX_IA_MOVZX_GdEwR, &BX_CPU_C::MOVZX_GdEwR, NULL)
bx_define_opcode(BX_IA_MOVZX_GwEbM, &BX_CPU_C::MOVZX_GwEbM, NULL)
bx_define_opcode(BX_IA_MOVZX_GwEbR, &BX_CPU_C::MOVZX_GwEbR, NULL)
bx_define_opcode(BX_IA_MUL_ALEbR, &BX_CPU_C::MUL_ALEbR, NULL)
bx_define_opcode(BX_IA_MUL_ALEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::MUL_ALEbR)
bx_define_opcode(BX_IA_MUL_AXEwR, &BX_CPU_C::MUL_AXEwR, NULL)
bx_define_opcode(BX_IA_MUL_AXEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::MUL_AXEwR)
bx_define_opcode(BX_IA_MUL_EAXEdR, &BX_CPU_C::MUL_EAXEdR, NULL)
bx_define_opcode(BX_IA_MUL_EAXEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::MUL_EAXEdR)
bx_define_opcode(BX_IA_NEG_EbM, &BX_CPU_C::NEG_EbM, NULL)
bx_define_opcode(BX_IA_NEG_EbR, &BX_CPU_C::NEG_EbR, NULL)
bx_define_opcode(BX_IA_NEG_EdM, &BX_CPU_C::NEG_EdM, NULL)
bx_define_opcode(BX_IA_NEG_EdR, &BX_CPU_C::NEG_EdR, NULL)
bx_define_opcode(BX_IA_NEG_EwM, &BX_CPU_C::NEG_EwM, NULL)
bx_define_opcode(BX_IA_NEG_EwR, &BX_CPU_C::NEG_EwR, NULL)
bx_define_opcode(BX_IA_NOP, &BX_CPU_C::NOP, NULL)
bx_define_opcode(BX_IA_PAUSE, &BX_CPU_C::PAUSE, NULL)
bx_define_opcode(BX_IA_NOT_EbM, &BX_CPU_C::NOT_EbM, NULL)
bx_define_opcode(BX_IA_NOT_EbR, &BX_CPU_C::NOT_EbR, NULL)
bx_define_opcode(BX_IA_NOT_EdM, &BX_CPU_C::NOT_EdM, NULL)
bx_define_opcode(BX_IA_NOT_EdR, &BX_CPU_C::NOT_EdR, NULL)
bx_define_opcode(BX_IA_NOT_EwM, &BX_CPU_C::NOT_EwM, NULL)
bx_define_opcode(BX_IA_NOT_EwR, &BX_CPU_C::NOT_EwR, NULL)
bx_define_opcode(BX_IA_OR_ALIb, &BX_CPU_C::OR_ALIb, NULL)
bx_define_opcode(BX_IA_OR_AXIw, &BX_CPU_C::OR_AXIw, NULL)
bx_define_opcode(BX_IA_OR_EAXId, &BX_CPU_C::OR_EAXId, NULL)
bx_define_opcode(BX_IA_OR_EbGbM, &BX_CPU_C::OR_EbGbM, NULL)
bx_define_opcode(BX_IA_OR_EbIbM, &BX_CPU_C::OR_EbIbM, NULL)
bx_define_opcode(BX_IA_OR_EbIbR, &BX_CPU_C::OR_EbIbR, NULL)
bx_define_opcode(BX_IA_OR_EdGdM, &BX_CPU_C::OR_EdGdM, NULL)
bx_define_opcode(BX_IA_OR_EdIdM, &BX_CPU_C::OR_EdIdM, NULL)
bx_define_opcode(BX_IA_OR_EdIdR, &BX_CPU_C::OR_EdIdR, NULL)
bx_define_opcode(BX_IA_OR_EwGwM, &BX_CPU_C::OR_EwGwM, NULL)
bx_define_opcode(BX_IA_OR_EwIwM, &BX_CPU_C::OR_EwIwM, NULL)
bx_define_opcode(BX_IA_OR_EwIwR, &BX_CPU_C::OR_EwIwR, NULL)
bx_define_opcode(BX_IA_OR_GbEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::OR_GbEbR)
bx_define_opcode(BX_IA_OR_GbEbR, &BX_CPU_C::OR_GbEbR, NULL)
bx_define_opcode(BX_IA_OR_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::OR_GdEdR)
bx_define_opcode(BX_IA_OR_GdEdR, &BX_CPU_C::OR_GdEdR, NULL)
bx_define_opcode(BX_IA_OR_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::OR_GwEwR)
bx_define_opcode(BX_IA_OR_GwEwR, &BX_CPU_C::OR_GwEwR, NULL)
bx_define_opcode(BX_IA_OUT_DXAL, &BX_CPU_C::OUT_DXAL, NULL)
bx_define_opcode(BX_IA_OUT_DXAX, &BX_CPU_C::OUT_DXAX, NULL)
bx_define_opcode(BX_IA_OUT_DXEAX, &BX_CPU_C::OUT_DXEAX, NULL)
bx_define_opcode(BX_IA_OUT_IbAL, &BX_CPU_C::OUT_IbAL, NULL)
bx_define_opcode(BX_IA_OUT_IbAX, &BX_CPU_C::OUT_IbAX, NULL)
bx_define_opcode(BX_IA_OUT_IbEAX, &BX_CPU_C::OUT_IbEAX, NULL)
bx_define_opcode(BX_IA_POP_EdM, &BX_CPU_C::POP_EdM, NULL)
bx_define_opcode(BX_IA_POP_EdR, &BX_CPU_C::POP_ERX, NULL)
bx_define_opcode(BX_IA_POP_ERX, &BX_CPU_C::POP_ERX, NULL)
bx_define_opcode(BX_IA_POP_EwM, &BX_CPU_C::POP_EwM, NULL)
bx_define_opcode(BX_IA_POP_EwR, &BX_CPU_C::POP_RX, NULL)
bx_define_opcode(BX_IA_POP_RX, &BX_CPU_C::POP_RX, NULL)
bx_define_opcode(BX_IA_POP16_DS, &BX_CPU_C::POP16_DS, NULL)
bx_define_opcode(BX_IA_POP16_ES, &BX_CPU_C::POP16_ES, NULL)
bx_define_opcode(BX_IA_POP16_FS, &BX_CPU_C::POP16_FS, NULL)
bx_define_opcode(BX_IA_POP16_GS, &BX_CPU_C::POP16_GS, NULL)
bx_define_opcode(BX_IA_POP16_SS, &BX_CPU_C::POP16_SS, NULL)
bx_define_opcode(BX_IA_POP32_DS, &BX_CPU_C::POP32_DS, NULL)
bx_define_opcode(BX_IA_POP32_ES, &BX_CPU_C::POP32_ES, NULL)
bx_define_opcode(BX_IA_POP32_FS, &BX_CPU_C::POP32_FS, NULL)
bx_define_opcode(BX_IA_POP32_GS, &BX_CPU_C::POP32_GS, NULL)
bx_define_opcode(BX_IA_POP32_SS, &BX_CPU_C::POP32_SS, NULL)
bx_define_opcode(BX_IA_POPAD16, &BX_CPU_C::POPAD16, NULL)
bx_define_opcode(BX_IA_POPAD32, &BX_CPU_C::POPAD32, NULL)
bx_define_opcode(BX_IA_POPCNT_GdEdR, &BX_CPU_C::POPCNT_GdEdR, NULL)
bx_define_opcode(BX_IA_POPCNT_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::POPCNT_GdEdR)
bx_define_opcode(BX_IA_POPCNT_GwEwR, &BX_CPU_C::POPCNT_GwEwR, NULL)
bx_define_opcode(BX_IA_POPCNT_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::POPCNT_GwEwR)
bx_define_opcode(BX_IA_POPF_Fd, &BX_CPU_C::POPF_Fd, NULL)
bx_define_opcode(BX_IA_POPF_Fw, &BX_CPU_C::POPF_Fw, NULL)
bx_define_opcode(BX_IA_PUSH_EdM, &BX_CPU_C::PUSH_EdM, NULL)
bx_define_opcode(BX_IA_PUSH_EdR, &BX_CPU_C::PUSH_ERX, NULL)
bx_define_opcode(BX_IA_PUSH_ERX, &BX_CPU_C::PUSH_ERX, NULL)
bx_define_opcode(BX_IA_PUSH_EwM, &BX_CPU_C::PUSH_EwM, NULL)
bx_define_opcode(BX_IA_PUSH_EwR, &BX_CPU_C::PUSH_RX, NULL)
bx_define_opcode(BX_IA_PUSH_Id, &BX_CPU_C::PUSH_Id, NULL)
bx_define_opcode(BX_IA_PUSH_Iw, &BX_CPU_C::PUSH_Iw, NULL)
bx_define_opcode(BX_IA_PUSH_RX, &BX_CPU_C::PUSH_RX, NULL)
bx_define_opcode(BX_IA_PUSH16_CS, &BX_CPU_C::PUSH16_CS, NULL)
bx_define_opcode(BX_IA_PUSH16_DS, &BX_CPU_C::PUSH16_DS, NULL)
bx_define_opcode(BX_IA_PUSH16_ES, &BX_CPU_C::PUSH16_ES, NULL)
bx_define_opcode(BX_IA_PUSH16_FS, &BX_CPU_C::PUSH16_FS, NULL)
bx_define_opcode(BX_IA_PUSH16_GS, &BX_CPU_C::PUSH16_GS, NULL)
bx_define_opcode(BX_IA_PUSH16_SS, &BX_CPU_C::PUSH16_SS, NULL)
bx_define_opcode(BX_IA_PUSH32_CS, &BX_CPU_C::PUSH32_CS, NULL)
bx_define_opcode(BX_IA_PUSH32_DS, &BX_CPU_C::PUSH32_DS, NULL)
bx_define_opcode(BX_IA_PUSH32_ES, &BX_CPU_C::PUSH32_ES, NULL)
bx_define_opcode(BX_IA_PUSH32_FS, &BX_CPU_C::PUSH32_FS, NULL)
bx_define_opcode(BX_IA_PUSH32_GS, &BX_CPU_C::PUSH32_GS, NULL)
bx_define_opcode(BX_IA_PUSH32_SS, &BX_CPU_C::PUSH32_SS, NULL)
bx_define_opcode(BX_IA_PUSHAD16, &BX_CPU_C::PUSHAD16, NULL)
bx_define_opcode(BX_IA_PUSHAD32, &BX_CPU_C::PUSHAD32, NULL)
bx_define_opcode(BX_IA_PUSHF_Fd, &BX_CPU_C::PUSHF_Fd, NULL)
bx_define_opcode(BX_IA_PUSHF_Fw, &BX_CPU_C::PUSHF_Fw, NULL)
bx_define_opcode(BX_IA_RCL_Eb, &BX_CPU_C::RCL_Eb, NULL)
bx_define_opcode(BX_IA_RCL_Ew, &BX_CPU_C::RCL_Ew, NULL)
bx_define_opcode(BX_IA_RCR_Eb, &BX_CPU_C::RCR_Eb, NULL)
bx_define_opcode(BX_IA_RCR_Ew, &BX_CPU_C::RCR_Ew, NULL)
bx_define_opcode(BX_IA_RDMSR, &BX_CPU_C::RDMSR, NULL)
bx_define_opcode(BX_IA_RDPMC, &BX_CPU_C::RDPMC, NULL)
bx_define_opcode(BX_IA_RDTSC, &BX_CPU_C::RDTSC, NULL)
bx_define_opcode(BX_IA_REP_CMPSB_XbYb, &BX_CPU_C::REP_CMPSB_XbYb, NULL)
bx_define_opcode(BX_IA_REP_CMPSD_XdYd, &BX_CPU_C::REP_CMPSD_XdYd, NULL)
bx_define_opcode(BX_IA_REP_CMPSW_XwYw, &BX_CPU_C::REP_CMPSW_XwYw, NULL)
bx_define_opcode(BX_IA_REP_INSB_YbDX, &BX_CPU_C::REP_INSB_YbDX, NULL)
bx_define_opcode(BX_IA_REP_INSD_YdDX, &BX_CPU_C::REP_INSD_YdDX, NULL)
bx_define_opcode(BX_IA_REP_INSW_YwDX, &BX_CPU_C::REP_INSW_YwDX, NULL)
bx_define_opcode(BX_IA_REP_LODSB_ALXb, &BX_CPU_C::REP_LODSB_ALXb, NULL)
bx_define_opcode(BX_IA_REP_LODSD_EAXXd, &BX_CPU_C::REP_LODSD_EAXXd, NULL)
bx_define_opcode(BX_IA_REP_LODSW_AXXw, &BX_CPU_C::REP_LODSW_AXXw, NULL)
bx_define_opcode(BX_IA_REP_MOVSB_XbYb, &BX_CPU_C::REP_MOVSB_XbYb, NULL)
bx_define_opcode(BX_IA_REP_MOVSD_XdYd, &BX_CPU_C::REP_MOVSD_XdYd, NULL)
bx_define_opcode(BX_IA_REP_MOVSW_XwYw, &BX_CPU_C::REP_MOVSW_XwYw, NULL)
bx_define_opcode(BX_IA_REP_OUTSB_DXXb, &BX_CPU_C::REP_OUTSB_DXXb, NULL)
bx_define_opcode(BX_IA_REP_OUTSD_DXXd, &BX_CPU_C::REP_OUTSD_DXXd, NULL)
bx_define_opcode(BX_IA_REP_OUTSW_DXXw, &BX_CPU_C::REP_OUTSW_DXXw, NULL)
bx_define_opcode(BX_IA_REP_SCASB_ALXb, &BX_CPU_C::REP_SCASB_ALXb, NULL)
bx_define_opcode(BX_IA_REP_SCASD_EAXXd, &BX_CPU_C::REP_SCASD_EAXXd, NULL)
bx_define_opcode(BX_IA_REP_SCASW_AXXw, &BX_CPU_C::REP_SCASW_AXXw, NULL)
bx_define_opcode(BX_IA_REP_STOSB_YbAL, &BX_CPU_C::REP_STOSB_YbAL, NULL)
bx_define_opcode(BX_IA_REP_STOSD_YdEAX, &BX_CPU_C::REP_STOSD_YdEAX, NULL)
bx_define_opcode(BX_IA_REP_STOSW_YwAX, &BX_CPU_C::REP_STOSW_YwAX, NULL)
bx_define_opcode(BX_IA_RETfar16, &BX_CPU_C::RETfar16, NULL)
bx_define_opcode(BX_IA_RETfar16_Iw, &BX_CPU_C::RETfar16_Iw, NULL)
bx_define_opcode(BX_IA_RETfar32, &BX_CPU_C::RETfar32, NULL)
bx_define_opcode(BX_IA_RETfar32_Iw, &BX_CPU_C::RETfar32_Iw, NULL)
bx_define_opcode(BX_IA_RETnear16, &BX_CPU_C::RETnear16, NULL)
bx_define_opcode(BX_IA_RETnear16_Iw, &BX_CPU_C::RETnear16_Iw, NULL)
bx_define_opcode(BX_IA_RETnear32, &BX_CPU_C::RETnear32, NULL)
bx_define_opcode(BX_IA_RETnear32_Iw, &BX_CPU_C::RETnear32_Iw, NULL)
bx_define_opcode(BX_IA_ROL_Eb, &BX_CPU_C::ROL_Eb, NULL)
bx_define_opcode(BX_IA_ROL_Ew, &BX_CPU_C::ROL_Ew, NULL)
bx_define_opcode(BX_IA_ROR_Eb, &BX_CPU_C::ROR_Eb, NULL)
bx_define_opcode(BX_IA_ROR_Ew, &BX_CPU_C::ROR_Ew, NULL)
bx_define_opcode(BX_IA_RCR_EdM, &BX_CPU_C::RCR_EdM, NULL)
bx_define_opcode(BX_IA_RCL_EdM, &BX_CPU_C::RCL_EdM, NULL)
bx_define_opcode(BX_IA_ROL_EdM, &BX_CPU_C::ROL_EdM, NULL)
bx_define_opcode(BX_IA_ROR_EdM, &BX_CPU_C::ROR_EdM, NULL)
bx_define_opcode(BX_IA_SAR_EdM, &BX_CPU_C::SAR_EdM, NULL)
bx_define_opcode(BX_IA_SHL_EdM, &BX_CPU_C::SHL_EdM, NULL)
bx_define_opcode(BX_IA_SHR_EdM, &BX_CPU_C::SHR_EdM, NULL)
bx_define_opcode(BX_IA_RCR_EdR, &BX_CPU_C::RCR_EdR, NULL)
bx_define_opcode(BX_IA_RCL_EdR, &BX_CPU_C::RCL_EdR, NULL)
bx_define_opcode(BX_IA_ROL_EdR, &BX_CPU_C::ROL_EdR, NULL)
bx_define_opcode(BX_IA_ROR_EdR, &BX_CPU_C::ROR_EdR, NULL)
bx_define_opcode(BX_IA_SAR_EdR, &BX_CPU_C::SAR_EdR, NULL)
bx_define_opcode(BX_IA_SHL_EdR, &BX_CPU_C::SHL_EdR, NULL)
bx_define_opcode(BX_IA_SHR_EdR, &BX_CPU_C::SHR_EdR, NULL)
bx_define_opcode(BX_IA_RSM, &BX_CPU_C::RSM, NULL)
bx_define_opcode(BX_IA_SAHF, &BX_CPU_C::SAHF, NULL)
bx_define_opcode(BX_IA_SALC, &BX_CPU_C::SALC, NULL)
bx_define_opcode(BX_IA_SAR_Eb, &BX_CPU_C::SAR_Eb, NULL)
bx_define_opcode(BX_IA_SAR_Ew, &BX_CPU_C::SAR_Ew, NULL)
bx_define_opcode(BX_IA_SBB_ALIb, &BX_CPU_C::SBB_ALIb, NULL)
bx_define_opcode(BX_IA_SBB_AXIw, &BX_CPU_C::SBB_AXIw, NULL)
bx_define_opcode(BX_IA_SBB_EAXId, &BX_CPU_C::SBB_EAXId, NULL)
bx_define_opcode(BX_IA_SBB_EbGbM, &BX_CPU_C::SBB_EbGbM, NULL)
bx_define_opcode(BX_IA_SBB_EbIbM, &BX_CPU_C::SBB_EbIbM, NULL)
bx_define_opcode(BX_IA_SBB_EbIbR, &BX_CPU_C::SBB_EbIbR, NULL)
bx_define_opcode(BX_IA_SBB_EdGdM, &BX_CPU_C::SBB_EdGdM, NULL)
bx_define_opcode(BX_IA_SBB_EdIdM, &BX_CPU_C::SBB_EdIdM, NULL)
bx_define_opcode(BX_IA_SBB_EdIdR, &BX_CPU_C::SBB_EdIdR, NULL)
bx_define_opcode(BX_IA_SBB_EwGwM, &BX_CPU_C::SBB_EwGwM, NULL)
bx_define_opcode(BX_IA_SBB_EwIwM, &BX_CPU_C::SBB_EwIwM, NULL)
bx_define_opcode(BX_IA_SBB_EwIwR, &BX_CPU_C::SBB_EwIwR, NULL)
bx_define_opcode(BX_IA_SBB_GbEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::SBB_GbEbR)
bx_define_opcode(BX_IA_SBB_GbEbR, &BX_CPU_C::SBB_GbEbR, NULL)
bx_define_opcode(BX_IA_SBB_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::SBB_GdEdR)
bx_define_opcode(BX_IA_SBB_GdEdR, &BX_CPU_C::SBB_GdEdR, NULL)
bx_define_opcode(BX_IA_SBB_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::SBB_GwEwR)
bx_define_opcode(BX_IA_SBB_GwEwR, &BX_CPU_C::SBB_GwEwR, NULL)
bx_define_opcode(BX_IA_SETB_EbM, &BX_CPU_C::SETB_EbM, NULL)
bx_define_opcode(BX_IA_SETB_EbR, &BX_CPU_C::SETB_EbR, NULL)
bx_define_opcode(BX_IA_SETBE_EbM, &BX_CPU_C::SETBE_EbM, NULL)
bx_define_opcode(BX_IA_SETBE_EbR, &BX_CPU_C::SETBE_EbR, NULL)
bx_define_opcode(BX_IA_SETL_EbM, &BX_CPU_C::SETL_EbM, NULL)
bx_define_opcode(BX_IA_SETL_EbR, &BX_CPU_C::SETL_EbR, NULL)
bx_define_opcode(BX_IA_SETLE_EbM, &BX_CPU_C::SETLE_EbM, NULL)
bx_define_opcode(BX_IA_SETLE_EbR, &BX_CPU_C::SETLE_EbR, NULL)
bx_define_opcode(BX_IA_SETNB_EbM, &BX_CPU_C::SETNB_EbM, NULL)
bx_define_opcode(BX_IA_SETNB_EbR, &BX_CPU_C::SETNB_EbR, NULL)
bx_define_opcode(BX_IA_SETNBE_EbM, &BX_CPU_C::SETNBE_EbM, NULL)
bx_define_opcode(BX_IA_SETNBE_EbR, &BX_CPU_C::SETNBE_EbR, NULL)
bx_define_opcode(BX_IA_SETNL_EbM, &BX_CPU_C::SETNL_EbM, NULL)
bx_define_opcode(BX_IA_SETNL_EbR, &BX_CPU_C::SETNL_EbR, NULL)
bx_define_opcode(BX_IA_SETNLE_EbM, &BX_CPU_C::SETNLE_EbM, NULL)
bx_define_opcode(BX_IA_SETNLE_EbR, &BX_CPU_C::SETNLE_EbR, NULL)
bx_define_opcode(BX_IA_SETNO_EbM, &BX_CPU_C::SETNO_EbM, NULL)
bx_define_opcode(BX_IA_SETNO_EbR, &BX_CPU_C::SETNO_EbR, NULL)
bx_define_opcode(BX_IA_SETNP_EbM, &BX_CPU_C::SETNP_EbM, NULL)
bx_define_opcode(BX_IA_SETNP_EbR, &BX_CPU_C::SETNP_EbR, NULL)
bx_define_opcode(BX_IA_SETNS_EbM, &BX_CPU_C::SETNS_EbM, NULL)
bx_define_opcode(BX_IA_SETNS_EbR, &BX_CPU_C::SETNS_EbR, NULL)
bx_define_opcode(BX_IA_SETNZ_EbM, &BX_CPU_C::SETNZ_EbM, NULL)
bx_define_opcode(BX_IA_SETNZ_EbR, &BX_CPU_C::SETNZ_EbR, NULL)
bx_define_opcode(BX_IA_SETO_EbM, &BX_CPU_C::SETO_EbM, NULL)
bx_define_opcode(BX_IA_SETO_EbR, &BX_CPU_C::SETO_EbR, NULL)
bx_define_opcode(BX_IA_SETP_EbM, &BX_CPU_C::SETP_EbM, NULL)
bx_define_opcode(BX_IA_SETP_EbR, &BX_CPU_C::SETP_EbR, NULL)
bx_define_opcode(BX_IA_SETS_EbM, &BX_CPU_C::SETS_EbM, NULL)
bx_define_opcode(BX_IA_SETS_EbR, &BX_CPU_C::SETS_EbR, NULL)
bx_define_opcode(BX_IA_SETZ_EbM, &BX_CPU_C::SETZ_EbM, NULL)
bx_define_opcode(BX_IA_SETZ_EbR, &BX_CPU_C::SETZ_EbR, NULL)
bx_define_opcode(BX_IA_SGDT_Ms, &BX_CPU_C::SGDT_Ms, NULL)
bx_define_opcode(BX_IA_SHL_Eb, &BX_CPU_C::SHL_Eb, NULL)
bx_define_opcode(BX_IA_SHL_Ew, &BX_CPU_C::SHL_Ew, NULL)
bx_define_opcode(BX_IA_SHLD_EdGdR, &BX_CPU_C::SHLD_EdGdR, NULL)
bx_define_opcode(BX_IA_SHLD_EdGdM, &BX_CPU_C::SHLD_EdGdM, NULL)
bx_define_opcode(BX_IA_SHLD_EwGwR, &BX_CPU_C::SHLD_EwGwR, NULL)
bx_define_opcode(BX_IA_SHLD_EwGwM, &BX_CPU_C::SHLD_EwGwM, NULL)
bx_define_opcode(BX_IA_SHR_Eb, &BX_CPU_C::SHR_Eb, NULL)
bx_define_opcode(BX_IA_SHR_Ew, &BX_CPU_C::SHR_Ew, NULL)
bx_define_opcode(BX_IA_SHRD_EdGdR, &BX_CPU_C::SHRD_EdGdR, NULL)
bx_define_opcode(BX_IA_SHRD_EdGdM, &BX_CPU_C::SHRD_EdGdM, NULL)
bx_define_opcode(BX_IA_SHRD_EwGwR, &BX_CPU_C::SHRD_EwGwR, NULL)
bx_define_opcode(BX_IA_SHRD_EwGwM, &BX_CPU_C::SHRD_EwGwM, NULL)
bx_define_opcode(BX_IA_SIDT_Ms, &BX_CPU_C::SIDT_Ms, NULL)
bx_define_opcode(BX_IA_SLDT_Ew, &BX_CPU_C::SLDT_Ew, NULL)
bx_define_opcode(BX_IA_SMSW_EwR, &BX_CPU_C::SMSW_EwR, NULL)
bx_define_opcode(BX_IA_SMSW_EwM, &BX_CPU_C::SMSW_EwM, NULL)
bx_define_opcode(BX_IA_STC, &BX_CPU_C::STC, NULL)
bx_define_opcode(BX_IA_STD, &BX_CPU_C::STD, NULL)
bx_define_opcode(BX_IA_STI, &BX_CPU_C::STI, NULL)
bx_define_opcode(BX_IA_STR_Ew, &BX_CPU_C::STR_Ew, NULL)
bx_define_opcode(BX_IA_SUB_ALIb, &BX_CPU_C::SUB_ALIb, NULL)
bx_define_opcode(BX_IA_SUB_AXIw, &BX_CPU_C::SUB_AXIw, NULL)
bx_define_opcode(BX_IA_SUB_EAXId, &BX_CPU_C::SUB_EAXId, NULL)
bx_define_opcode(BX_IA_SUB_EbGbM, &BX_CPU_C::SUB_EbGbM, NULL)
bx_define_opcode(BX_IA_SUB_EbIbM, &BX_CPU_C::SUB_EbIbM, NULL)
bx_define_opcode(BX_IA_SUB_EbIbR, &BX_CPU_C::SUB_EbIbR, NULL)
bx_define_opcode(BX_IA_SUB_EdGdM, &BX_CPU_C::SUB_EdGdM, NULL)
bx_define_opcode(BX_IA_SUB_EdIdM, &BX_CPU_C::SUB_EdIdM, NULL)
bx_define_opcode(BX_IA_SUB_EdIdR, &BX_CPU_C::SUB_EdIdR, NULL)
bx_define_opcode(BX_IA_SUB_EwGwM, &BX_CPU_C::SUB_EwGwM, NULL)
bx_define_opcode(BX_IA_SUB_EwIwM, &BX_CPU_C::SUB_EwIwM, NULL)
bx_define_opcode(BX_IA_SUB_EwIwR, &BX_CPU_C::SUB_EwIwR, NULL)
bx_define_opcode(BX_IA_SUB_GbEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::SUB_GbEbR)
bx_define_opcode(BX_IA_SUB_GbEbR, &BX_CPU_C::SUB_GbEbR, NULL)
bx_define_opcode(BX_IA_SUB_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::SUB_GdEdR)
bx_define_opcode(BX_IA_SUB_GdEdR, &BX_CPU_C::SUB_GdEdR, NULL)
bx_define_opcode(BX_IA_SUB_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::SUB_GwEwR)
bx_define_opcode(BX_IA_SUB_GwEwR, &BX_CPU_C::SUB_GwEwR, NULL)
bx_define_opcode(BX_IA_SYSENTER, &BX_CPU_C::SYSENTER, NULL)
bx_define_opcode(BX_IA_SYSEXIT, &BX_CPU_C::SYSEXIT, NULL)
bx_define_opcode(BX_IA_TEST_ALIb, &BX_CPU_C::TEST_ALIb, NULL)
bx_define_opcode(BX_IA_TEST_AXIw, &BX_CPU_C::TEST_AXIw, NULL)
bx_define_opcode(BX_IA_TEST_EAXId, &BX_CPU_C::TEST_EAXId, NULL)
bx_define_opcode(BX_IA_TEST_EbGbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::TEST_EbGbR)
bx_define_opcode(BX_IA_TEST_EbGbR, &BX_CPU_C::TEST_EbGbR, NULL)
bx_define_opcode(BX_IA_TEST_EbIbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::TEST_EbIbR)
bx_define_opcode(BX_IA_TEST_EbIbR, &BX_CPU_C::TEST_EbIbR, NULL)
bx_define_opcode(BX_IA_TEST_EdGdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::TEST_EdGdR)
bx_define_opcode(BX_IA_TEST_EdGdR, &BX_CPU_C::TEST_EdGdR, NULL)
bx_define_opcode(BX_IA_TEST_EdIdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::TEST_EdIdR)
bx_define_opcode(BX_IA_TEST_EdIdR, &BX_CPU_C::TEST_EdIdR, NULL)
bx_define_opcode(BX_IA_TEST_EwGwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::TEST_EwGwR)
bx_define_opcode(BX_IA_TEST_EwGwR, &BX_CPU_C::TEST_EwGwR, NULL)
bx_define_opcode(BX_IA_TEST_EwIwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::TEST_EwIwR)
bx_define_opcode(BX_IA_TEST_EwIwR, &BX_CPU_C::TEST_EwIwR, NULL)
bx_define_opcode(BX_IA_UD2A, &BX_CPU_C::UndefinedOpcode, NULL)
bx_define_opcode(BX_IA_UD2B, &BX_CPU_C::UndefinedOpcode, NULL)
bx_define_opcode(BX_IA_VERR_Ew, &BX_CPU_C::VERR_Ew, NULL)
bx_define_opcode(BX_IA_VERW_Ew, &BX_CPU_C::VERW_Ew, NULL)
bx_define_opcode(BX_IA_WBINVD, &BX_CPU_C::WBINVD, NULL)
bx_define_opcode(BX_IA_WRMSR, &BX_CPU_C::WRMSR, NULL)
bx_define_opcode(BX_IA_XADD_EbGbM, &BX_CPU_C::XADD_EbGbM, NULL)
bx_define_opcode(BX_IA_XADD_EbGbR, &BX_CPU_C::XADD_EbGbR, NULL)
bx_define_opcode(BX_IA_XADD_EdGdM, &BX_CPU_C::XADD_EdGdM, NULL)
bx_define_opcode(BX_IA_XADD_EdGdR, &BX_CPU_C::XADD_EdGdR, NULL)
bx_define_opcode(BX_IA_XADD_EwGwM, &BX_CPU_C::XADD_EwGwM, NULL)
bx_define_opcode(BX_IA_XADD_EwGwR, &BX_CPU_C::XADD_EwGwR, NULL)
bx_define_opcode(BX_IA_XCHG_EbGbM, &BX_CPU_C::XCHG_EbGbM, NULL)
bx_define_opcode(BX_IA_XCHG_EbGbR, &BX_CPU_C::XCHG_EbGbR, NULL)
bx_define_opcode(BX_IA_XCHG_EdGdM, &BX_CPU_C::XCHG_EdGdM, NULL)
bx_define_opcode(BX_IA_XCHG_EdGdR, &BX_CPU_C::XCHG_EdGdR, NULL)
bx_define_opcode(BX_IA_XCHG_ERXEAX, &BX_CPU_C::XCHG_ERXEAX, NULL)
bx_define_opcode(BX_IA_XCHG_EwGwM, &BX_CPU_C::XCHG_EwGwM, NULL)
bx_define_opcode(BX_IA_XCHG_EwGwR, &BX_CPU_C::XCHG_EwGwR, NULL)
bx_define_opcode(BX_IA_XCHG_RXAX, &BX_CPU_C::XCHG_RXAX, NULL)
bx_define_opcode(BX_IA_XLAT, &BX_CPU_C::XLAT, NULL)
bx_define_opcode(BX_IA_XOR_ALIb, &BX_CPU_C::XOR_ALIb, NULL)
bx_define_opcode(BX_IA_XOR_AXIw, &BX_CPU_C::XOR_AXIw, NULL)
bx_define_opcode(BX_IA_XOR_EAXId, &BX_CPU_C::XOR_EAXId, NULL)
bx_define_opcode(BX_IA_XOR_EbGbM, &BX_CPU_C::XOR_EbGbM, NULL)
bx_define_opcode(BX_IA_XOR_EbIbM, &BX_CPU_C::XOR_EbIbM, NULL)
bx_define_opcode(BX_IA_XOR_EbIbR, &BX_CPU_C::XOR_EbIbR, NULL)
bx_define_opcode(BX_IA_XOR_EdGdM, &BX_CPU_C::XOR_EdGdM, NULL)
bx_define_opcode(BX_IA_XOR_EdIdM, &BX_CPU_C::XOR_EdIdM, NULL)
bx_define_opcode(BX_IA_XOR_EdIdR, &BX_CPU_C::XOR_EdIdR, NULL)
bx_define_opcode(BX_IA_XOR_EwGwM, &BX_CPU_C::XOR_EwGwM, NULL)
bx_define_opcode(BX_IA_XOR_EwIwM, &BX_CPU_C::XOR_EwIwM, NULL)
bx_define_opcode(BX_IA_XOR_EwIwR, &BX_CPU_C::XOR_EwIwR, NULL)
bx_define_opcode(BX_IA_XOR_GbEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::XOR_GbEbR)
bx_define_opcode(BX_IA_XOR_GbEbR, &BX_CPU_C::XOR_GbEbR, NULL)
bx_define_opcode(BX_IA_XOR_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::XOR_GdEdR)
bx_define_opcode(BX_IA_XOR_GdEdR, &BX_CPU_C::XOR_GdEdR, NULL)
bx_define_opcode(BX_IA_XOR_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::XOR_GwEwR)
bx_define_opcode(BX_IA_XOR_GwEwR, &BX_CPU_C::XOR_GwEwR, NULL)

bx_define_opcode(BX_IA_FWAIT, &BX_CPU_C::FWAIT, NULL)
#if BX_SUPPORT_FPU
bx_define_opcode(BX_IA_FLD_STi, &BX_CPU_C::FLD_STi, NULL)
bx_define_opcode(BX_IA_FLD_SINGLE_REAL, &BX_CPU_C::FLD_SINGLE_REAL, NULL)
bx_define_opcode(BX_IA_FLD_DOUBLE_REAL, &BX_CPU_C::FLD_DOUBLE_REAL, NULL)
bx_define_opcode(BX_IA_FLD_EXTENDED_REAL, &BX_CPU_C::FLD_EXTENDED_REAL, NULL)
bx_define_opcode(BX_IA_FILD_WORD_INTEGER, &BX_CPU_C::FILD_WORD_INTEGER, NULL)
bx_define_opcode(BX_IA_FILD_DWORD_INTEGER, &BX_CPU_C::FILD_DWORD_INTEGER, NULL)
bx_define_opcode(BX_IA_FILD_QWORD_INTEGER, &BX_CPU_C::FILD_QWORD_INTEGER, NULL)
bx_define_opcode(BX_IA_FBLD_PACKED_BCD, &BX_CPU_C::FBLD_PACKED_BCD, NULL)
bx_define_opcode(BX_IA_FST_STi, &BX_CPU_C::FST_STi, NULL)
bx_define_opcode(BX_IA_FST_SINGLE_REAL, &BX_CPU_C::FST_SINGLE_REAL, NULL)
bx_define_opcode(BX_IA_FST_DOUBLE_REAL, &BX_CPU_C::FST_DOUBLE_REAL, NULL)
bx_define_opcode(BX_IA_FSTP_EXTENDED_REAL, &BX_CPU_C::FSTP_EXTENDED_REAL, NULL)
bx_define_opcode(BX_IA_FIST_WORD_INTEGER, &BX_CPU_C::FIST_WORD_INTEGER, NULL)
bx_define_opcode(BX_IA_FIST_DWORD_INTEGER, &BX_CPU_C::FIST_DWORD_INTEGER, NULL)
bx_define_opcode(BX_IA_FISTP_QWORD_INTEGER, &BX_CPU_C::FISTP_QWORD_INTEGER, NULL)
bx_define_opcode(BX_IA_FBSTP_PACKED_BCD, &BX_CPU_C::FBSTP_PACKED_BCD, NULL)
bx_define_opcode(BX_IA_FISTTP16, &BX_CPU_C::FISTTP16, NULL)
bx_define_opcode(BX_IA_FISTTP32, &BX_CPU_C::FISTTP32, NULL)
bx_define_opcode(BX_IA_FISTTP64, &BX_CPU_C::FISTTP64, NULL)
bx_define_opcode(BX_IA_FNINIT, &BX_CPU_C::FNINIT, NULL)
bx_define_opcode(BX_IA_FNCLEX, &BX_CPU_C::FNCLEX, NULL)
bx_define_opcode(BX_IA_FRSTOR, &BX_CPU_C::FRSTOR, NULL)
bx_define_opcode(BX_IA_FNSAVE, &BX_CPU_C::FNSAVE, NULL)
bx_define_opcode(BX_IA_FLDENV, &BX_CPU_C::FLDENV, NULL)
bx_define_opcode(BX_IA_FNSTENV, &BX_CPU_C::FNSTENV, NULL)
bx_define_opcode(BX_IA_FLDCW, &BX_CPU_C::FLDCW, NULL)
bx_define_opcode(BX_IA_FNSTCW, &BX_CPU_C::FNSTCW, NULL)
bx_define_opcode(BX_IA_FNSTSW, &BX_CPU_C::FNSTSW, NULL)
bx_define_opcode(BX_IA_FNSTSW_AX, &BX_CPU_C::FNSTSW_AX, NULL)
bx_define_opcode(BX_IA_FLD1, &BX_CPU_C::FLD1, NULL)
bx_define_opcode(BX_IA_FLDL2T, &BX_CPU_C::FLDL2T, NULL)
bx_define_opcode(BX_IA_FLDL2E, &BX_CPU_C::FLDL2E, NULL)
bx_define_opcode(BX_IA_FLDPI, &BX_CPU_C::FLDPI, NULL)
bx_define_opcode(BX_IA_FLDLG2, &BX_CPU_C::FLDLG2, NULL)
bx_define_opcode(BX_IA_FLDLN2, &BX_CPU_C::FLDLN2, NULL)
bx_define_opcode(BX_IA_FLDZ, &BX_CPU_C::FLDZ, NULL)
bx_define_opcode(BX_IA_FADD_ST0_STj, &BX_CPU_C::FADD_ST0_STj, NULL)
bx_define_opcode(BX_IA_FADD_STi_ST0, &BX_CPU_C::FADD_STi_ST0, NULL)
bx_define_opcode(BX_IA_FADD_SINGLE_REAL, &BX_CPU_C::FADD_SINGLE_REAL, NULL)
bx_define_opcode(BX_IA_FADD_DOUBLE_REAL, &BX_CPU_C::FADD_DOUBLE_REAL, NULL)
bx_define_opcode(BX_IA_FIADD_WORD_INTEGER, &BX_CPU_C::FIADD_WORD_INTEGER, NULL)
bx_define_opcode(BX_IA_FIADD_DWORD_INTEGER, &BX_CPU_C::FIADD_DWORD_INTEGER, NULL)
bx_define_opcode(BX_IA_FMUL_ST0_STj, &BX_CPU_C::FMUL_ST0_STj, NULL)
bx_define_opcode(BX_IA_FMUL_STi_ST0, &BX_CPU_C::FMUL_STi_ST0, NULL)
bx_define_opcode(BX_IA_FMUL_SINGLE_REAL, &BX_CPU_C::FMUL_SINGLE_REAL, NULL)
bx_define_opcode(BX_IA_FMUL_DOUBLE_REAL, &BX_CPU_C::FMUL_DOUBLE_REAL, NULL)
bx_define_opcode(BX_IA_FIMUL_WORD_INTEGER , &BX_CPU_C::FIMUL_WORD_INTEGER , NULL)
bx_define_opcode(BX_IA_FIMUL_DWORD_INTEGER, &BX_CPU_C::FIMUL_DWORD_INTEGER, NULL)
bx_define_opcode(BX_IA_FSUB_ST0_STj, &BX_CPU_C::FSUB_ST0_STj, NULL)
bx_define_opcode(BX_IA_FSUBR_ST0_STj, &BX_CPU_C::FSUBR_ST0_STj, NULL)
bx_define_opcode(BX_IA_FSUB_STi_ST0, &BX_CPU_C::FSUB_STi_ST0, NULL)
bx_define_opcode(BX_IA_FSUBR_STi_ST0, &BX_CPU_C::FSUBR_STi_ST0, NULL)
bx_define_opcode(BX_IA_FSUB_SINGLE_REAL, &BX_CPU_C::FSUB_SINGLE_REAL, NULL)
bx_define_opcode(BX_IA_FSUBR_SINGLE_REAL, &BX_CPU_C::FSUBR_SINGLE_REAL, NULL)
bx_define_opcode(BX_IA_FSUB_DOUBLE_REAL, &BX_CPU_C::FSUB_DOUBLE_REAL, NULL)
bx_define_opcode(BX_IA_FSUBR_DOUBLE_REAL, &BX_CPU_C::FSUBR_DOUBLE_REAL, NULL)
bx_define_opcode(BX_IA_FISUB_WORD_INTEGER, &BX_CPU_C::FISUB_WORD_INTEGER, NULL)
bx_define_opcode(BX_IA_FISUBR_WORD_INTEGER, &BX_CPU_C::FISUBR_WORD_INTEGER, NULL)
bx_define_opcode(BX_IA_FISUB_DWORD_INTEGER, &BX_CPU_C::FISUB_DWORD_INTEGER, NULL)
bx_define_opcode(BX_IA_FISUBR_DWORD_INTEGER, &BX_CPU_C::FISUBR_DWORD_INTEGER, NULL)
bx_define_opcode(BX_IA_FDIV_ST0_STj, &BX_CPU_C::FDIV_ST0_STj, NULL)
bx_define_opcode(BX_IA_FDIVR_ST0_STj, &BX_CPU_C::FDIVR_ST0_STj, NULL)
bx_define_opcode(BX_IA_FDIV_STi_ST0, &BX_CPU_C::FDIV_STi_ST0, NULL)
bx_define_opcode(BX_IA_FDIVR_STi_ST0, &BX_CPU_C::FDIVR_STi_ST0, NULL)
bx_define_opcode(BX_IA_FDIV_SINGLE_REAL, &BX_CPU_C::FDIV_SINGLE_REAL, NULL)
bx_define_opcode(BX_IA_FDIVR_SINGLE_REAL, &BX_CPU_C::FDIVR_SINGLE_REAL, NULL)
bx_define_opcode(BX_IA_FDIV_DOUBLE_REAL, &BX_CPU_C::FDIV_DOUBLE_REAL, NULL)
bx_define_opcode(BX_IA_FDIVR_DOUBLE_REAL, &BX_CPU_C::FDIVR_DOUBLE_REAL, NULL)
bx_define_opcode(BX_IA_FIDIV_WORD_INTEGER, &BX_CPU_C::FIDIV_WORD_INTEGER, NULL)
bx_define_opcode(BX_IA_FIDIVR_WORD_INTEGER, &BX_CPU_C::FIDIVR_WORD_INTEGER, NULL)
bx_define_opcode(BX_IA_FIDIV_DWORD_INTEGER, &BX_CPU_C::FIDIV_DWORD_INTEGER, NULL)
bx_define_opcode(BX_IA_FIDIVR_DWORD_INTEGER, &BX_CPU_C::FIDIVR_DWORD_INTEGER, NULL)
bx_define_opcode(BX_IA_FCOM_STi, &BX_CPU_C::FCOM_STi, NULL)
bx_define_opcode(BX_IA_FUCOM_STi, &BX_CPU_C::FUCOM_STi, NULL)
bx_define_opcode(BX_IA_FCOMI_ST0_STj, &BX_CPU_C::FCOMI_ST0_STj, NULL)
bx_define_opcode(BX_IA_FUCOMI_ST0_STj, &BX_CPU_C::FUCOMI_ST0_STj, NULL)
bx_define_opcode(BX_IA_FCOM_SINGLE_REAL, &BX_CPU_C::FCOM_SINGLE_REAL, NULL)
bx_define_opcode(BX_IA_FCOM_DOUBLE_REAL, &BX_CPU_C::FCOM_DOUBLE_REAL, NULL)
bx_define_opcode(BX_IA_FICOM_WORD_INTEGER, &BX_CPU_C::FICOM_WORD_INTEGER, NULL)
bx_define_opcode(BX_IA_FICOM_DWORD_INTEGER, &BX_CPU_C::FICOM_DWORD_INTEGER, NULL)
bx_define_opcode(BX_IA_FCMOV_ST0_STj, &BX_CPU_C::FCMOV_ST0_STj, NULL)
bx_define_opcode(BX_IA_FCOMPP, &BX_CPU_C::FCOMPP, NULL)
bx_define_opcode(BX_IA_FUCOMPP, &BX_CPU_C::FUCOMPP, NULL)
bx_define_opcode(BX_IA_FXCH_STi, &BX_CPU_C::FXCH_STi, NULL)
bx_define_opcode(BX_IA_FNOP, &BX_CPU_C::FNOP, NULL)
bx_define_opcode(BX_IA_FPLEGACY, &BX_CPU_C::FPLEGACY, NULL)
bx_define_opcode(BX_IA_FCHS, &BX_CPU_C::FCHS, NULL)
bx_define_opcode(BX_IA_FABS, &BX_CPU_C::FABS, NULL)
bx_define_opcode(BX_IA_FTST, &BX_CPU_C::FTST, NULL)
bx_define_opcode(BX_IA_FXAM, &BX_CPU_C::FXAM, NULL)
bx_define_opcode(BX_IA_FDECSTP, &BX_CPU_C::FDECSTP, NULL)
bx_define_opcode(BX_IA_FINCSTP, &BX_CPU_C::FINCSTP, NULL)
bx_define_opcode(BX_IA_FFREE_STi, &BX_CPU_C::FFREE_STi, NULL)
bx_define_opcode(BX_IA_FFREEP_STi, &BX_CPU_C::FFREEP_STi, NULL)
bx_define_opcode(BX_IA_F2XM1, &BX_CPU_C::F2XM1, NULL)
bx_define_opcode(BX_IA_FYL2X, &BX_CPU_C::FYL2X, NULL)
bx_define_opcode(BX_IA_FPTAN, &BX_CPU_C::FPTAN, NULL)
bx_define_opcode(BX_IA_FPATAN, &BX_CPU_C::FPATAN, NULL)
bx_define_opcode(BX_IA_FXTRACT, &BX_CPU_C::FXTRACT, NULL)
bx_define_opcode(BX_IA_FPREM1, &BX_CPU_C::FPREM1, NULL)
bx_define_opcode(BX_IA_FPREM, &BX_CPU_C::FPREM, NULL)
bx_define_opcode(BX_IA_FYL2XP1, &BX_CPU_C::FYL2XP1, NULL)
bx_define_opcode(BX_IA_FSQRT, &BX_CPU_C::FSQRT, NULL)
bx_define_opcode(BX_IA_FSINCOS, &BX_CPU_C::FSINCOS, NULL)
bx_define_opcode(BX_IA_FRNDINT, &BX_CPU_C::FRNDINT, NULL)
bx_define_opcode(BX_IA_FSCALE, &BX_CPU_C::FSCALE, NULL)
bx_define_opcode(BX_IA_FSIN, &BX_CPU_C::FSIN, NULL)
bx_define_opcode(BX_IA_FCOS, &BX_CPU_C::FCOS, NULL)
#else
bx_define_opcode(BX_IA_FPU_ESC, &BX_CPU_C::FPU_ESC, NULL)
#endif

// MMX
bx_define_opcode(BX_IA_PUNPCKLBW_PqQd, &BX_CPU_C::PUNPCKLBW_PqQd, NULL)
bx_define_opcode(BX_IA_PUNPCKLWD_PqQd, &BX_CPU_C::PUNPCKLWD_PqQd, NULL)
bx_define_opcode(BX_IA_PUNPCKLDQ_PqQd, &BX_CPU_C::PUNPCKLDQ_PqQd, NULL)
bx_define_opcode(BX_IA_PACKSSWB_PqQq, &BX_CPU_C::PACKSSWB_PqQq, NULL)
bx_define_opcode(BX_IA_PCMPGTB_PqQq, &BX_CPU_C::PCMPGTB_PqQq, NULL)
bx_define_opcode(BX_IA_PCMPGTW_PqQq, &BX_CPU_C::PCMPGTW_PqQq, NULL)
bx_define_opcode(BX_IA_PCMPGTD_PqQq, &BX_CPU_C::PCMPGTD_PqQq, NULL)
bx_define_opcode(BX_IA_PACKUSWB_PqQq, &BX_CPU_C::PACKUSWB_PqQq, NULL)
bx_define_opcode(BX_IA_PUNPCKHBW_PqQq, &BX_CPU_C::PUNPCKHBW_PqQq, NULL)
bx_define_opcode(BX_IA_PUNPCKHWD_PqQq, &BX_CPU_C::PUNPCKHWD_PqQq, NULL)
bx_define_opcode(BX_IA_PUNPCKHDQ_PqQq, &BX_CPU_C::PUNPCKHDQ_PqQq, NULL)
bx_define_opcode(BX_IA_PACKSSDW_PqQq, &BX_CPU_C::PACKSSDW_PqQq, NULL)
bx_define_opcode(BX_IA_MOVD_PqEd, &BX_CPU_C::MOVD_PqEd, NULL)
bx_define_opcode(BX_IA_MOVQ_PqQq, &BX_CPU_C::MOVQ_PqQq, NULL)
bx_define_opcode(BX_IA_PCMPEQB_PqQq, &BX_CPU_C::PCMPEQB_PqQq, NULL)
bx_define_opcode(BX_IA_PCMPEQW_PqQq, &BX_CPU_C::PCMPEQW_PqQq, NULL)
bx_define_opcode(BX_IA_PCMPEQD_PqQq, &BX_CPU_C::PCMPEQD_PqQq, NULL)
bx_define_opcode(BX_IA_EMMS, &BX_CPU_C::EMMS, NULL)
bx_define_opcode(BX_IA_MOVD_EdPd, &BX_CPU_C::MOVD_EdPd, NULL)
bx_define_opcode(BX_IA_MOVQ_QqPq, &BX_CPU_C::MOVQ_QqPq, NULL)
bx_define_opcode(BX_IA_PSRLW_PqQq, &BX_CPU_C::PSRLW_PqQq, NULL)
bx_define_opcode(BX_IA_PSRLD_PqQq, &BX_CPU_C::PSRLD_PqQq, NULL)
bx_define_opcode(BX_IA_PSRLQ_PqQq, &BX_CPU_C::PSRLQ_PqQq, NULL)
bx_define_opcode(BX_IA_PMULLW_PqQq, &BX_CPU_C::PMULLW_PqQq, NULL)
bx_define_opcode(BX_IA_PSUBUSB_PqQq, &BX_CPU_C::PSUBUSB_PqQq, NULL)
bx_define_opcode(BX_IA_PSUBUSW_PqQq, &BX_CPU_C::PSUBUSW_PqQq, NULL)
bx_define_opcode(BX_IA_PAND_PqQq, &BX_CPU_C::PAND_PqQq, NULL)
bx_define_opcode(BX_IA_PADDUSB_PqQq, &BX_CPU_C::PADDUSB_PqQq, NULL)
bx_define_opcode(BX_IA_PADDUSW_PqQq, &BX_CPU_C::PADDUSW_PqQq, NULL)
bx_define_opcode(BX_IA_PANDN_PqQq, &BX_CPU_C::PANDN_PqQq, NULL)
bx_define_opcode(BX_IA_PSRAW_PqQq, &BX_CPU_C::PSRAW_PqQq, NULL)
bx_define_opcode(BX_IA_PSRAD_PqQq, &BX_CPU_C::PSRAD_PqQq, NULL)
bx_define_opcode(BX_IA_PMULHW_PqQq, &BX_CPU_C::PMULHW_PqQq, NULL)
bx_define_opcode(BX_IA_PSUBSB_PqQq, &BX_CPU_C::PSUBSB_PqQq, NULL)
bx_define_opcode(BX_IA_PSUBSW_PqQq, &BX_CPU_C::PSUBSW_PqQq, NULL)
bx_define_opcode(BX_IA_POR_PqQq, &BX_CPU_C::POR_PqQq, NULL)
bx_define_opcode(BX_IA_PADDSB_PqQq, &BX_CPU_C::PADDSB_PqQq, NULL)
bx_define_opcode(BX_IA_PADDSW_PqQq, &BX_CPU_C::PADDSW_PqQq, NULL)
bx_define_opcode(BX_IA_PXOR_PqQq, &BX_CPU_C::PXOR_PqQq, NULL)
bx_define_opcode(BX_IA_PSLLW_PqQq, &BX_CPU_C::PSLLW_PqQq, NULL)
bx_define_opcode(BX_IA_PSLLD_PqQq, &BX_CPU_C::PSLLD_PqQq, NULL)
bx_define_opcode(BX_IA_PSLLQ_PqQq, &BX_CPU_C::PSLLQ_PqQq, NULL)
bx_define_opcode(BX_IA_PMADDWD_PqQq, &BX_CPU_C::PMADDWD_PqQq, NULL)
bx_define_opcode(BX_IA_PSUBB_PqQq, &BX_CPU_C::PSUBB_PqQq, NULL)
bx_define_opcode(BX_IA_PSUBW_PqQq, &BX_CPU_C::PSUBW_PqQq, NULL)
bx_define_opcode(BX_IA_PSUBD_PqQq, &BX_CPU_C::PSUBD_PqQq, NULL)
bx_define_opcode(BX_IA_PADDB_PqQq, &BX_CPU_C::PADDB_PqQq, NULL)
bx_define_opcode(BX_IA_PADDW_PqQq, &BX_CPU_C::PADDW_PqQq, NULL)
bx_define_opcode(BX_IA_PADDD_PqQq, &BX_CPU_C::PADDD_PqQq, NULL)
bx_define_opcode(BX_IA_PSRLW_PqIb, &BX_CPU_C::PSRLW_PqIb, NULL)
bx_define_opcode(BX_IA_PSRAW_PqIb, &BX_CPU_C::PSRAW_PqIb, NULL)
bx_define_opcode(BX_IA_PSLLW_PqIb, &BX_CPU_C::PSLLW_PqIb, NULL)
bx_define_opcode(BX_IA_PSRLD_PqIb, &BX_CPU_C::PSRLD_PqIb, NULL)
bx_define_opcode(BX_IA_PSRAD_PqIb, &BX_CPU_C::PSRAD_PqIb, NULL)
bx_define_opcode(BX_IA_PSLLD_PqIb, &BX_CPU_C::PSLLD_PqIb, NULL)
bx_define_opcode(BX_IA_PSRLQ_PqIb, &BX_CPU_C::PSRLQ_PqIb, NULL)
bx_define_opcode(BX_IA_PSLLQ_PqIb, &BX_CPU_C::PSLLQ_PqIb, NULL)
// MMX

bx_define_opcode(BX_IA_FEMMS, BX_3DNOW_ALIAS(&BX_CPU_C::EMMS), NULL)
#if BX_SUPPORT_3DNOW
bx_define_opcode(BX_IA_PF2ID_PqQq, &BX_CPU_C::PF2ID_PqQq, NULL)
bx_define_opcode(BX_IA_PF2IW_PqQq, &BX_CPU_C::PF2IW_PqQq, NULL)
bx_define_opcode(BX_IA_PFACC_PqQq, &BX_CPU_C::PFACC_PqQq, NULL)
bx_define_opcode(BX_IA_PFADD_PqQq, &BX_CPU_C::PFADD_PqQq, NULL)
bx_define_opcode(BX_IA_PFCMPEQ_PqQq, &BX_CPU_C::PFCMPEQ_PqQq, NULL)
bx_define_opcode(BX_IA_PFCMPGE_PqQq, &BX_CPU_C::PFCMPGE_PqQq, NULL)
bx_define_opcode(BX_IA_PFCMPGT_PqQq, &BX_CPU_C::PFCMPGT_PqQq, NULL)
bx_define_opcode(BX_IA_PFMAX_PqQq, &BX_CPU_C::PFMAX_PqQq, NULL)
bx_define_opcode(BX_IA_PFMIN_PqQq, &BX_CPU_C::PFMIN_PqQq, NULL)
bx_define_opcode(BX_IA_PFMUL_PqQq, &BX_CPU_C::PFMUL_PqQq, NULL)
bx_define_opcode(BX_IA_PFNACC_PqQq, &BX_CPU_C::PFNACC_PqQq, NULL)
bx_define_opcode(BX_IA_PFPNACC_PqQq, &BX_CPU_C::PFPNACC_PqQq, NULL)
bx_define_opcode(BX_IA_PFRCP_PqQq, &BX_CPU_C::PFRCP_PqQq, NULL)
bx_define_opcode(BX_IA_PFRCPIT1_PqQq, &BX_CPU_C::PFRCPIT1_PqQq, NULL)
bx_define_opcode(BX_IA_PFRCPIT2_PqQq, &BX_CPU_C::PFRCPIT2_PqQq, NULL)
bx_define_opcode(BX_IA_PFRSQIT1_PqQq, &BX_CPU_C::PFRSQIT1_PqQq, NULL)
bx_define_opcode(BX_IA_PFRSQRT_PqQq, &BX_CPU_C::PFRSQRT_PqQq, NULL)
bx_define_opcode(BX_IA_PFSUB_PqQq, &BX_CPU_C::PFSUB_PqQq, NULL)
bx_define_opcode(BX_IA_PFSUBR_PqQq, &BX_CPU_C::PFSUBR_PqQq, NULL)
bx_define_opcode(BX_IA_PI2FD_PqQq, &BX_CPU_C::PI2FD_PqQq, NULL)
bx_define_opcode(BX_IA_PI2FW_PqQq, &BX_CPU_C::PI2FW_PqQq, NULL)
bx_define_opcode(BX_IA_PMULHRW_PqQq, &BX_CPU_C::PMULHRW_PqQq, NULL)
bx_define_opcode(BX_IA_PSWAPD_PqQq, &BX_CPU_C::PSWAPD_PqQq, NULL)
#endif

// SSE
bx_define_opcode(BX_IA_FXSAVE, &BX_CPU_C::FXSAVE, NULL)
bx_define_opcode(BX_IA_FXRSTOR, &BX_CPU_C::FXRSTOR, NULL)
bx_define_opcode(BX_IA_LDMXCSR, &BX_CPU_C::LDMXCSR, NULL)
bx_define_opcode(BX_IA_STMXCSR, &BX_CPU_C::STMXCSR, NULL)
bx_define_opcode(BX_IA_PREFETCH, &BX_CPU_C::PREFETCH, NULL)
// SSE

// SSE
bx_define_opcode(BX_IA_ANDPS_VpsWps, &BX_CPU_C::ANDPS_VpsWps, NULL)
bx_define_opcode(BX_IA_ORPS_VpsWps, &BX_CPU_C::ORPS_VpsWps, NULL)
bx_define_opcode(BX_IA_XORPS_VpsWps, &BX_CPU_C::XORPS_VpsWps, NULL)
bx_define_opcode(BX_IA_ANDNPS_VpsWps, &BX_CPU_C::ANDNPS_VpsWps, NULL)
bx_define_opcode(BX_IA_MOVUPS_VpsWpsR, &BX_CPU_C::MOVAPS_VpsWpsR, NULL)
bx_define_opcode(BX_IA_MOVUPS_VpsWpsM, &BX_CPU_C::MOVUPS_VpsWpsM, NULL)
bx_define_opcode(BX_IA_MOVUPS_WpsVpsR, &BX_CPU_C::MOVAPS_WpsVpsR, NULL)
bx_define_opcode(BX_IA_MOVUPS_WpsVpsM, &BX_CPU_C::MOVUPS_WpsVpsM, NULL)
bx_define_opcode(BX_IA_MOVSS_VssWss, &BX_CPU_C::MOVSS_VssWss, NULL)
bx_define_opcode(BX_IA_MOVSS_WssVss, &BX_CPU_C::MOVSS_WssVss, NULL)
bx_define_opcode(BX_IA_MOVLPS_VpsMq, &BX_CPU_C::MOVLPS_VpsMq, NULL)
bx_define_opcode(BX_IA_MOVLPS_MqVps, &BX_CPU_C::MOVLPS_MqVps, NULL)
bx_define_opcode(BX_IA_MOVHPS_VpsMq, &BX_CPU_C::MOVHPS_VpsMq, NULL)
bx_define_opcode(BX_IA_MOVHPS_MqVps, &BX_CPU_C::MOVHPS_MqVps, NULL)
bx_define_opcode(BX_IA_MOVAPS_VpsWpsR, &BX_CPU_C::MOVAPS_VpsWpsR, NULL)
bx_define_opcode(BX_IA_MOVAPS_VpsWpsM, &BX_CPU_C::MOVAPS_VpsWpsM, NULL)
bx_define_opcode(BX_IA_MOVAPS_WpsVpsR, &BX_CPU_C::MOVAPS_WpsVpsR, NULL)
bx_define_opcode(BX_IA_MOVAPS_WpsVpsM, &BX_CPU_C::MOVAPS_WpsVpsM, NULL)
bx_define_opcode(BX_IA_CVTPI2PS_VpsQqR, &BX_CPU_C::CVTPI2PS_VpsQqR, NULL)
bx_define_opcode(BX_IA_CVTPI2PS_VpsQqM, &BX_CPU_C::CVTPI2PS_VpsQqM, NULL)
bx_define_opcode(BX_IA_CVTSI2SS_VssEdR, &BX_CPU_C::CVTSI2SS_VssEdR, NULL)
bx_define_opcode(BX_IA_CVTSI2SS_VssEdM, &BX_CPU_C::CVTSI2SS_VssEdM, NULL)
bx_define_opcode(BX_IA_MOVNTPS_MpsVps, &BX_CPU_C::MOVNTPS_MpsVps, NULL)
bx_define_opcode(BX_IA_CVTTPS2PI_PqWps, &BX_CPU_C::CVTTPS2PI_PqWps, NULL)
bx_define_opcode(BX_IA_CVTTSS2SI_GdWss, &BX_CPU_C::CVTTSS2SI_GdWss, NULL)
bx_define_opcode(BX_IA_CVTPS2PI_PqWps, &BX_CPU_C::CVTPS2PI_PqWps, NULL)
bx_define_opcode(BX_IA_CVTSS2SI_GdWss, &BX_CPU_C::CVTSS2SI_GdWss, NULL)
bx_define_opcode(BX_IA_UCOMISS_VssWss, &BX_CPU_C::UCOMISS_VssWss, NULL)
bx_define_opcode(BX_IA_COMISS_VpsWps, &BX_CPU_C::COMISS_VpsWps, NULL)
bx_define_opcode(BX_IA_MOVMSKPS_GdVRps, &BX_CPU_C::MOVMSKPS_GdVRps, NULL)
bx_define_opcode(BX_IA_SQRTPS_VpsWps, &BX_CPU_C::SQRTPS_VpsWps, NULL)
bx_define_opcode(BX_IA_SQRTSS_VssWss, &BX_CPU_C::SQRTSS_VssWss, NULL)
bx_define_opcode(BX_IA_RSQRTPS_VpsWps, &BX_CPU_C::RSQRTPS_VpsWps, NULL)
bx_define_opcode(BX_IA_RSQRTSS_VssWss, &BX_CPU_C::RSQRTSS_VssWss, NULL)
bx_define_opcode(BX_IA_RCPPS_VpsWps, &BX_CPU_C::RCPPS_VpsWps, NULL)
bx_define_opcode(BX_IA_RCPSS_VssWss, &BX_CPU_C::RCPSS_VssWss, NULL)
bx_define_opcode(BX_IA_ADDPS_VpsWps, &BX_CPU_C::ADDPS_VpsWps, NULL)
bx_define_opcode(BX_IA_ADDSS_VssWss, &BX_CPU_C::ADDSS_VssWss, NULL)
bx_define_opcode(BX_IA_MULPS_VpsWps, &BX_CPU_C::MULPS_VpsWps, NULL)
bx_define_opcode(BX_IA_MULSS_VssWss, &BX_CPU_C::MULSS_VssWss, NULL)
bx_define_opcode(BX_IA_SUBPS_VpsWps, &BX_CPU_C::SUBPS_VpsWps, NULL)
bx_define_opcode(BX_IA_SUBSS_VssWss, &BX_CPU_C::SUBSS_VssWss, NULL)
bx_define_opcode(BX_IA_MINPS_VpsWps, &BX_CPU_C::MINPS_VpsWps, NULL)
bx_define_opcode(BX_IA_MINSS_VssWss, &BX_CPU_C::MINSS_VssWss, NULL)
bx_define_opcode(BX_IA_DIVPS_VpsWps, &BX_CPU_C::DIVPS_VpsWps, NULL)
bx_define_opcode(BX_IA_DIVSS_VssWss, &BX_CPU_C::DIVSS_VssWss, NULL)
bx_define_opcode(BX_IA_MAXPS_VpsWps, &BX_CPU_C::MAXPS_VpsWps, NULL)
bx_define_opcode(BX_IA_MAXSS_VssWss, &BX_CPU_C::MAXSS_VssWss, NULL)
bx_define_opcode(BX_IA_PSHUFW_PqQqIb, &BX_CPU_C::PSHUFW_PqQqIb, NULL)
bx_define_opcode(BX_IA_PSHUFLW_VdqWdqIb, &BX_CPU_C::PSHUFLW_VdqWdqIb, NULL)
bx_define_opcode(BX_IA_CMPPS_VpsWpsIb, &BX_CPU_C::CMPPS_VpsWpsIb, NULL)
bx_define_opcode(BX_IA_CMPSS_VssWssIb, &BX_CPU_C::CMPSS_VssWssIb, NULL)
bx_define_opcode(BX_IA_PINSRW_PqEwIb, &BX_CPU_C::PINSRW_PqEwIb, NULL)
bx_define_opcode(BX_IA_PEXTRW_GdPqIb, &BX_CPU_C::PEXTRW_GdPqIb, NULL)
bx_define_opcode(BX_IA_SHUFPS_VpsWpsIb, &BX_CPU_C::SHUFPS_VpsWpsIb, NULL)
bx_define_opcode(BX_IA_PMOVMSKB_GdPRq, &BX_CPU_C::PMOVMSKB_GdPRq, NULL)
bx_define_opcode(BX_IA_PMINUB_PqQq, &BX_CPU_C::PMINUB_PqQq, NULL)
bx_define_opcode(BX_IA_PMAXUB_PqQq, &BX_CPU_C::PMAXUB_PqQq, NULL)
bx_define_opcode(BX_IA_PAVGB_PqQq, &BX_CPU_C::PAVGB_PqQq, NULL)
bx_define_opcode(BX_IA_PAVGW_PqQq, &BX_CPU_C::PAVGW_PqQq, NULL)
bx_define_opcode(BX_IA_PMULHUW_PqQq, &BX_CPU_C::PMULHUW_PqQq, NULL)
bx_define_opcode(BX_IA_MOVNTQ_MqPq, &BX_CPU_C::MOVNTQ_MqPq, NULL)
bx_define_opcode(BX_IA_PMINSW_PqQq, &BX_CPU_C::PMINSW_PqQq, NULL)
bx_define_opcode(BX_IA_PMAXSW_PqQq, &BX_CPU_C::PMAXSW_PqQq, NULL)
bx_define_opcode(BX_IA_PSADBW_PqQq, &BX_CPU_C::PSADBW_PqQq, NULL)
bx_define_opcode(BX_IA_MASKMOVQ_PqPRq, &BX_CPU_C::MASKMOVQ_PqPRq, NULL)
// SSE

// SSE2
bx_define_opcode(BX_IA_MOVSD_VsdWsd, &BX_CPU_C::MOVSD_VsdWsd, NULL)
bx_define_opcode(BX_IA_MOVSD_WsdVsd, &BX_CPU_C::MOVSD_WsdVsd, NULL)
bx_define_opcode(BX_IA_CVTPI2PD_VpdQqR, &BX_CPU_C::CVTPI2PD_VpdQqR, NULL)
bx_define_opcode(BX_IA_CVTPI2PD_VpdQqM, &BX_CPU_C::CVTPI2PD_VpdQqM, NULL)
bx_define_opcode(BX_IA_CVTSI2SD_VsdEdR, &BX_CPU_C::CVTSI2SD_VsdEdR, NULL)
bx_define_opcode(BX_IA_CVTSI2SD_VsdEdM, &BX_CPU_C::CVTSI2SD_VsdEdM, NULL)
bx_define_opcode(BX_IA_CVTTPD2PI_PqWpd, &BX_CPU_C::CVTTPD2PI_PqWpd, NULL)
bx_define_opcode(BX_IA_CVTTSD2SI_GdWsd, &BX_CPU_C::CVTTSD2SI_GdWsd, NULL)
bx_define_opcode(BX_IA_CVTPD2PI_PqWpd, &BX_CPU_C::CVTPD2PI_PqWpd, NULL)
bx_define_opcode(BX_IA_CVTSD2SI_GdWsd, &BX_CPU_C::CVTSD2SI_GdWsd, NULL)
bx_define_opcode(BX_IA_UCOMISD_VsdWsd, &BX_CPU_C::UCOMISD_VsdWsd, NULL)
bx_define_opcode(BX_IA_COMISD_VpdWpd, &BX_CPU_C::COMISD_VpdWpd, NULL)
bx_define_opcode(BX_IA_MOVMSKPD_GdVRpd, &BX_CPU_C::MOVMSKPD_GdVRpd, NULL)
bx_define_opcode(BX_IA_SQRTPD_VpdWpd, &BX_CPU_C::SQRTPD_VpdWpd, NULL)
bx_define_opcode(BX_IA_SQRTSD_VsdWsd, &BX_CPU_C::SQRTSD_VsdWsd, NULL)
bx_define_opcode(BX_IA_ADDPD_VpdWpd, &BX_CPU_C::ADDPD_VpdWpd, NULL)
bx_define_opcode(BX_IA_ADDSD_VsdWsd, &BX_CPU_C::ADDSD_VsdWsd, NULL)
bx_define_opcode(BX_IA_MULPD_VpdWpd, &BX_CPU_C::MULPD_VpdWpd, NULL)
bx_define_opcode(BX_IA_MULSD_VsdWsd, &BX_CPU_C::MULSD_VsdWsd, NULL)
bx_define_opcode(BX_IA_CVTPS2PD_VpsWps, &BX_CPU_C::CVTPS2PD_VpsWps, NULL)
bx_define_opcode(BX_IA_CVTPD2PS_VpdWpd, &BX_CPU_C::CVTPD2PS_VpdWpd, NULL)
bx_define_opcode(BX_IA_CVTSD2SS_VsdWsd, &BX_CPU_C::CVTSD2SS_VsdWsd, NULL)
bx_define_opcode(BX_IA_CVTSS2SD_VssWss, &BX_CPU_C::CVTSS2SD_VssWss, NULL)
bx_define_opcode(BX_IA_CVTDQ2PS_VpsWdq, &BX_CPU_C::CVTDQ2PS_VpsWdq, NULL)
bx_define_opcode(BX_IA_CVTPS2DQ_VdqWps, &BX_CPU_C::CVTPS2DQ_VdqWps, NULL)
bx_define_opcode(BX_IA_CVTTPS2DQ_VdqWps, &BX_CPU_C::CVTTPS2DQ_VdqWps, NULL)
bx_define_opcode(BX_IA_SUBPD_VpdWpd, &BX_CPU_C::SUBPD_VpdWpd, NULL)
bx_define_opcode(BX_IA_SUBSD_VsdWsd, &BX_CPU_C::SUBSD_VsdWsd, NULL)
bx_define_opcode(BX_IA_MINPD_VpdWpd, &BX_CPU_C::MINPD_VpdWpd, NULL)
bx_define_opcode(BX_IA_MINSD_VsdWsd, &BX_CPU_C::MINSD_VsdWsd, NULL)
bx_define_opcode(BX_IA_DIVPD_VpdWpd, &BX_CPU_C::DIVPD_VpdWpd, NULL)
bx_define_opcode(BX_IA_DIVSD_VsdWsd, &BX_CPU_C::DIVSD_VsdWsd, NULL)
bx_define_opcode(BX_IA_MAXPD_VpdWpd, &BX_CPU_C::MAXPD_VpdWpd, NULL)
bx_define_opcode(BX_IA_MAXSD_VsdWsd, &BX_CPU_C::MAXSD_VsdWsd, NULL)
bx_define_opcode(BX_IA_UNPCKHPD_VpdWdq, &BX_CPU_C::PUNPCKHQDQ_VdqWdq, NULL)
bx_define_opcode(BX_IA_UNPCKLPD_VpdWdq, &BX_CPU_C::PUNPCKLQDQ_VdqWdq, NULL)
bx_define_opcode(BX_IA_PUNPCKHDQ_VdqWdq, BX_SSE2_ALIAS(&BX_CPU_C::UNPCKHPS_VpsWdq), NULL)
bx_define_opcode(BX_IA_PUNPCKLDQ_VdqWdq, BX_SSE2_ALIAS(&BX_CPU_C::UNPCKLPS_VpsWdq), NULL)
bx_define_opcode(BX_IA_MOVAPD_VpdWpdR, BX_SSE2_ALIAS(&BX_CPU_C::MOVAPS_VpsWpsR), NULL)
bx_define_opcode(BX_IA_MOVAPD_VpdWpdM, BX_SSE2_ALIAS(&BX_CPU_C::MOVAPS_VpsWpsM), NULL)
bx_define_opcode(BX_IA_MOVAPD_WpdVpdR, BX_SSE2_ALIAS(&BX_CPU_C::MOVAPS_WpsVpsR), NULL)
bx_define_opcode(BX_IA_MOVAPD_WpdVpdM, BX_SSE2_ALIAS(&BX_CPU_C::MOVAPS_WpsVpsM), NULL)
bx_define_opcode(BX_IA_MOVDQA_VdqWdqR, BX_SSE2_ALIAS(&BX_CPU_C::MOVAPS_VpsWpsR), NULL)
bx_define_opcode(BX_IA_MOVDQA_VdqWdqM, BX_SSE2_ALIAS(&BX_CPU_C::MOVAPS_VpsWpsM), NULL)
bx_define_opcode(BX_IA_MOVDQA_WdqVdqR, BX_SSE2_ALIAS(&BX_CPU_C::MOVAPS_WpsVpsR), NULL)
bx_define_opcode(BX_IA_MOVDQA_WdqVdqM, BX_SSE2_ALIAS(&BX_CPU_C::MOVAPS_WpsVpsM), NULL)
bx_define_opcode(BX_IA_MOVDQU_VdqWdqR, BX_SSE2_ALIAS(&BX_CPU_C::MOVAPS_VpsWpsR), NULL)
bx_define_opcode(BX_IA_MOVDQU_VdqWdqM, BX_SSE2_ALIAS(&BX_CPU_C::MOVUPS_VpsWpsM), NULL)
bx_define_opcode(BX_IA_MOVDQU_WdqVdqR, BX_SSE2_ALIAS(&BX_CPU_C::MOVAPS_WpsVpsR), NULL)
bx_define_opcode(BX_IA_MOVDQU_WdqVdqM, BX_SSE2_ALIAS(&BX_CPU_C::MOVUPS_WpsVpsM), NULL)
bx_define_opcode(BX_IA_MOVHPD_MqVsd, BX_SSE2_ALIAS(&BX_CPU_C::MOVHPS_MqVps), NULL)
bx_define_opcode(BX_IA_MOVHPD_VsdMq, BX_SSE2_ALIAS(&BX_CPU_C::MOVHPS_VpsMq), NULL)
bx_define_opcode(BX_IA_MOVLPD_MqVsd, BX_SSE2_ALIAS(&BX_CPU_C::MOVLPS_MqVps), NULL)
bx_define_opcode(BX_IA_MOVLPD_VsdMq, BX_SSE2_ALIAS(&BX_CPU_C::MOVLPS_VpsMq), NULL)
bx_define_opcode(BX_IA_MOVNTDQ_MdqVdq, BX_SSE2_ALIAS(&BX_CPU_C::MOVNTPS_MpsVps), NULL)
bx_define_opcode(BX_IA_MOVNTPD_MpdVpd, BX_SSE2_ALIAS(&BX_CPU_C::MOVNTPS_MpsVps), NULL)
bx_define_opcode(BX_IA_MOVUPD_VpdWpdR, BX_SSE2_ALIAS(&BX_CPU_C::MOVAPS_VpsWpsR), NULL)
bx_define_opcode(BX_IA_MOVUPD_VpdWpdM, BX_SSE2_ALIAS(&BX_CPU_C::MOVUPS_VpsWpsM), NULL)
bx_define_opcode(BX_IA_MOVUPD_WpdVpdR, BX_SSE2_ALIAS(&BX_CPU_C::MOVAPS_WpsVpsR), NULL)
bx_define_opcode(BX_IA_MOVUPD_WpdVpdM, BX_SSE2_ALIAS(&BX_CPU_C::MOVUPS_WpsVpsM), NULL)
bx_define_opcode(BX_IA_ANDNPD_VpdWpd, BX_SSE2_ALIAS(&BX_CPU_C::ANDNPS_VpsWps), NULL)
bx_define_opcode(BX_IA_ANDPD_VpdWpd, BX_SSE2_ALIAS(&BX_CPU_C::ANDPS_VpsWps), NULL)
bx_define_opcode(BX_IA_ORPD_VpdWpd, BX_SSE2_ALIAS(&BX_CPU_C::ORPS_VpsWps), NULL)
bx_define_opcode(BX_IA_PAND_VdqWdq, BX_SSE2_ALIAS(&BX_CPU_C::ANDPS_VpsWps), NULL)
bx_define_opcode(BX_IA_PANDN_VdqWdq, BX_SSE2_ALIAS(&BX_CPU_C::ANDNPS_VpsWps), NULL)
bx_define_opcode(BX_IA_POR_VdqWdq, BX_SSE2_ALIAS(&BX_CPU_C::ORPS_VpsWps), NULL)
bx_define_opcode(BX_IA_PXOR_VdqWdq, BX_SSE2_ALIAS(&BX_CPU_C::XORPS_VpsWps), NULL)
bx_define_opcode(BX_IA_XORPD_VpdWpd, BX_SSE2_ALIAS(&BX_CPU_C::XORPS_VpsWps), NULL)
bx_define_opcode(BX_IA_PUNPCKLBW_VdqWdq, &BX_CPU_C::PUNPCKLBW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PUNPCKLWD_VdqWdq, &BX_CPU_C::PUNPCKLWD_VdqWdq, NULL)
bx_define_opcode(BX_IA_UNPCKLPS_VpsWdq, &BX_CPU_C::UNPCKLPS_VpsWdq, NULL)
bx_define_opcode(BX_IA_PACKSSWB_VdqWdq, &BX_CPU_C::PACKSSWB_VdqWdq, NULL)
bx_define_opcode(BX_IA_PCMPGTB_VdqWdq, &BX_CPU_C::PCMPGTB_VdqWdq, NULL)
bx_define_opcode(BX_IA_PCMPGTW_VdqWdq, &BX_CPU_C::PCMPGTW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PCMPGTD_VdqWdq, &BX_CPU_C::PCMPGTD_VdqWdq, NULL)
bx_define_opcode(BX_IA_PACKUSWB_VdqWdq, &BX_CPU_C::PACKUSWB_VdqWdq, NULL)
bx_define_opcode(BX_IA_PUNPCKHBW_VdqWdq, &BX_CPU_C::PUNPCKHBW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PUNPCKHWD_VdqWdq, &BX_CPU_C::PUNPCKHWD_VdqWdq, NULL)
bx_define_opcode(BX_IA_UNPCKHPS_VpsWdq, &BX_CPU_C::UNPCKHPS_VpsWdq, NULL)
bx_define_opcode(BX_IA_PACKSSDW_VdqWdq, &BX_CPU_C::PACKSSDW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PUNPCKLQDQ_VdqWdq, &BX_CPU_C::PUNPCKLQDQ_VdqWdq, NULL)
bx_define_opcode(BX_IA_PUNPCKHQDQ_VdqWdq, &BX_CPU_C::PUNPCKHQDQ_VdqWdq, NULL)
bx_define_opcode(BX_IA_MOVD_VdqEd, &BX_CPU_C::MOVD_VdqEd, NULL)
bx_define_opcode(BX_IA_PSHUFD_VdqWdqIb, &BX_CPU_C::PSHUFD_VdqWdqIb, NULL)
bx_define_opcode(BX_IA_PSHUFHW_VdqWdqIb, &BX_CPU_C::PSHUFHW_VdqWdqIb, NULL)
bx_define_opcode(BX_IA_PCMPEQB_VdqWdq, &BX_CPU_C::PCMPEQB_VdqWdq, NULL)
bx_define_opcode(BX_IA_PCMPEQW_VdqWdq, &BX_CPU_C::PCMPEQW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PCMPEQD_VdqWdq, &BX_CPU_C::PCMPEQD_VdqWdq, NULL)
bx_define_opcode(BX_IA_MOVD_EdVd, &BX_CPU_C::MOVD_EdVd, NULL)
bx_define_opcode(BX_IA_MOVQ_VqWq, &BX_CPU_C::MOVQ_VqWq, NULL)
bx_define_opcode(BX_IA_CMPPD_VpdWpdIb, &BX_CPU_C::CMPPD_VpdWpdIb, NULL)
bx_define_opcode(BX_IA_CMPSD_VsdWsdIb, &BX_CPU_C::CMPSD_VsdWsdIb, NULL)
bx_define_opcode(BX_IA_MOVNTI_MdGd, &BX_CPU_C::MOVNTI_MdGd, NULL)
bx_define_opcode(BX_IA_PINSRW_VdqEwIb, &BX_CPU_C::PINSRW_VdqEwIb, NULL)
bx_define_opcode(BX_IA_PEXTRW_GdUdqIb, &BX_CPU_C::PEXTRW_GdUdqIb, NULL)
bx_define_opcode(BX_IA_SHUFPD_VpdWpdIb, &BX_CPU_C::SHUFPD_VpdWpdIb, NULL)
bx_define_opcode(BX_IA_PSRLW_VdqWdq, &BX_CPU_C::PSRLW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PSRLD_VdqWdq, &BX_CPU_C::PSRLD_VdqWdq, NULL)
bx_define_opcode(BX_IA_PSRLQ_VdqWdq, &BX_CPU_C::PSRLQ_VdqWdq, NULL)
bx_define_opcode(BX_IA_PADDQ_PqQq, &BX_CPU_C::PADDQ_PqQq, NULL)
bx_define_opcode(BX_IA_PADDQ_VdqWdq, &BX_CPU_C::PADDQ_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMULLW_VdqWdq, &BX_CPU_C::PMULLW_VdqWdq, NULL)
bx_define_opcode(BX_IA_MOVQ_WqVq, &BX_CPU_C::MOVQ_WqVq, NULL)
bx_define_opcode(BX_IA_MOVDQ2Q_PqVRq, &BX_CPU_C::MOVDQ2Q_PqVRq, NULL)
bx_define_opcode(BX_IA_MOVQ2DQ_VdqQq, &BX_CPU_C::MOVQ2DQ_VdqQq, NULL)
bx_define_opcode(BX_IA_PMOVMSKB_GdUdq, &BX_CPU_C::PMOVMSKB_GdUdq, NULL)
bx_define_opcode(BX_IA_PSUBUSB_VdqWdq, &BX_CPU_C::PSUBUSB_VdqWdq, NULL)
bx_define_opcode(BX_IA_PSUBUSW_VdqWdq, &BX_CPU_C::PSUBUSW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMINUB_VdqWdq, &BX_CPU_C::PMINUB_VdqWdq, NULL)
bx_define_opcode(BX_IA_PADDUSB_VdqWdq, &BX_CPU_C::PADDUSB_VdqWdq, NULL)
bx_define_opcode(BX_IA_PADDUSW_VdqWdq, &BX_CPU_C::PADDUSW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMAXUB_VdqWdq, &BX_CPU_C::PMAXUB_VdqWdq, NULL)
bx_define_opcode(BX_IA_PAVGB_VdqWdq, &BX_CPU_C::PAVGB_VdqWdq, NULL)
bx_define_opcode(BX_IA_PSRAW_VdqWdq, &BX_CPU_C::PSRAW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PSRAD_VdqWdq, &BX_CPU_C::PSRAD_VdqWdq, NULL)
bx_define_opcode(BX_IA_PAVGW_VdqWdq, &BX_CPU_C::PAVGW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMULHUW_VdqWdq, &BX_CPU_C::PMULHUW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMULHW_VdqWdq, &BX_CPU_C::PMULHW_VdqWdq, NULL)
bx_define_opcode(BX_IA_CVTTPD2DQ_VqWpd, &BX_CPU_C::CVTTPD2DQ_VqWpd, NULL)
bx_define_opcode(BX_IA_CVTPD2DQ_VqWpd, &BX_CPU_C::CVTPD2DQ_VqWpd, NULL)
bx_define_opcode(BX_IA_CVTDQ2PD_VpdWq, &BX_CPU_C::CVTDQ2PD_VpdWq, NULL)
bx_define_opcode(BX_IA_PSUBSB_VdqWdq, &BX_CPU_C::PSUBSB_VdqWdq, NULL)
bx_define_opcode(BX_IA_PSUBSW_VdqWdq, &BX_CPU_C::PSUBSW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMINSW_VdqWdq, &BX_CPU_C::PMINSW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PADDSB_VdqWdq, &BX_CPU_C::PADDSB_VdqWdq, NULL)
bx_define_opcode(BX_IA_PADDSW_VdqWdq, &BX_CPU_C::PADDSW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMAXSW_VdqWdq, &BX_CPU_C::PMAXSW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PSLLW_VdqWdq, &BX_CPU_C::PSLLW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PSLLD_VdqWdq, &BX_CPU_C::PSLLD_VdqWdq, NULL)
bx_define_opcode(BX_IA_PSLLQ_VdqWdq, &BX_CPU_C::PSLLQ_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMULUDQ_PqQq, &BX_CPU_C::PMULUDQ_PqQq, NULL)
bx_define_opcode(BX_IA_PMULUDQ_VdqWdq, &BX_CPU_C::PMULUDQ_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMADDWD_VdqWdq, &BX_CPU_C::PMADDWD_VdqWdq, NULL)
bx_define_opcode(BX_IA_PSADBW_VdqWdq, &BX_CPU_C::PSADBW_VdqWdq, NULL)
bx_define_opcode(BX_IA_MASKMOVDQU_VdqUdq, &BX_CPU_C::MASKMOVDQU_VdqUdq, NULL)
bx_define_opcode(BX_IA_PSUBB_VdqWdq, &BX_CPU_C::PSUBB_VdqWdq, NULL)
bx_define_opcode(BX_IA_PSUBW_VdqWdq, &BX_CPU_C::PSUBW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PSUBD_VdqWdq, &BX_CPU_C::PSUBD_VdqWdq, NULL)
bx_define_opcode(BX_IA_PSUBQ_PqQq, &BX_CPU_C::PSUBQ_PqQq, NULL)
bx_define_opcode(BX_IA_PSUBQ_VdqWdq, &BX_CPU_C::PSUBQ_VdqWdq, NULL)
bx_define_opcode(BX_IA_PADDB_VdqWdq, &BX_CPU_C::PADDB_VdqWdq, NULL)
bx_define_opcode(BX_IA_PADDW_VdqWdq, &BX_CPU_C::PADDW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PADDD_VdqWdq, &BX_CPU_C::PADDD_VdqWdq, NULL)
bx_define_opcode(BX_IA_PSRLW_UdqIb, &BX_CPU_C::PSRLW_UdqIb, NULL)
bx_define_opcode(BX_IA_PSRAW_UdqIb, &BX_CPU_C::PSRAW_UdqIb, NULL)
bx_define_opcode(BX_IA_PSLLW_UdqIb, &BX_CPU_C::PSLLW_UdqIb, NULL)
bx_define_opcode(BX_IA_PSRLD_UdqIb, &BX_CPU_C::PSRLD_UdqIb, NULL)
bx_define_opcode(BX_IA_PSRAD_UdqIb, &BX_CPU_C::PSRAD_UdqIb, NULL)
bx_define_opcode(BX_IA_PSLLD_UdqIb, &BX_CPU_C::PSLLD_UdqIb, NULL)
bx_define_opcode(BX_IA_PSRLQ_UdqIb, &BX_CPU_C::PSRLQ_UdqIb, NULL)
bx_define_opcode(BX_IA_PSRLDQ_UdqIb, &BX_CPU_C::PSRLDQ_UdqIb, NULL)
bx_define_opcode(BX_IA_PSLLQ_UdqIb, &BX_CPU_C::PSLLQ_UdqIb, NULL)
bx_define_opcode(BX_IA_PSLLDQ_UdqIb, &BX_CPU_C::PSLLDQ_UdqIb, NULL)
// SSE2

// SSE3
bx_define_opcode(BX_IA_MOVDDUP_VpdWq, &BX_CPU_C::MOVDDUP_VpdWq, NULL)
bx_define_opcode(BX_IA_MOVSLDUP_VpsWps, &BX_CPU_C::MOVSLDUP_VpsWps, NULL)
bx_define_opcode(BX_IA_MOVSHDUP_VpsWps, &BX_CPU_C::MOVSHDUP_VpsWps, NULL)
bx_define_opcode(BX_IA_HADDPD_VpdWpd, &BX_CPU_C::HADDPD_VpdWpd, NULL)
bx_define_opcode(BX_IA_HADDPS_VpsWps, &BX_CPU_C::HADDPS_VpsWps, NULL)
bx_define_opcode(BX_IA_HSUBPD_VpdWpd, &BX_CPU_C::HSUBPD_VpdWpd, NULL)
bx_define_opcode(BX_IA_HSUBPS_VpsWps, &BX_CPU_C::HSUBPS_VpsWps, NULL)
bx_define_opcode(BX_IA_ADDSUBPD_VpdWpd, &BX_CPU_C::ADDSUBPD_VpdWpd, NULL)
bx_define_opcode(BX_IA_ADDSUBPS_VpsWps, &BX_CPU_C::ADDSUBPS_VpsWps, NULL)
bx_define_opcode(BX_IA_LDDQU_VdqMdq, &BX_CPU_C::LDDQU_VdqMdq, NULL)
// SSE3

#if (BX_SUPPORT_SSE >= 4) || (BX_SUPPORT_SSE >= 3 && BX_SUPPORT_SSE_EXTENSION > 0)
// SSSE3
bx_define_opcode(BX_IA_PSHUFB_PqQq, &BX_CPU_C::PSHUFB_PqQq, NULL)
bx_define_opcode(BX_IA_PHADDW_PqQq, &BX_CPU_C::PHADDW_PqQq, NULL)
bx_define_opcode(BX_IA_PHADDD_PqQq, &BX_CPU_C::PHADDD_PqQq, NULL)
bx_define_opcode(BX_IA_PHADDSW_PqQq, &BX_CPU_C::PHADDSW_PqQq, NULL)
bx_define_opcode(BX_IA_PMADDUBSW_PqQq, &BX_CPU_C::PMADDUBSW_PqQq, NULL)
bx_define_opcode(BX_IA_PHSUBSW_PqQq, &BX_CPU_C::PHSUBSW_PqQq, NULL)
bx_define_opcode(BX_IA_PHSUBW_PqQq, &BX_CPU_C::PHSUBW_PqQq, NULL)
bx_define_opcode(BX_IA_PHSUBD_PqQq, &BX_CPU_C::PHSUBD_PqQq, NULL)
bx_define_opcode(BX_IA_PSIGNB_PqQq, &BX_CPU_C::PSIGNB_PqQq, NULL)
bx_define_opcode(BX_IA_PSIGNW_PqQq, &BX_CPU_C::PSIGNW_PqQq, NULL)
bx_define_opcode(BX_IA_PSIGND_PqQq, &BX_CPU_C::PSIGND_PqQq, NULL)
bx_define_opcode(BX_IA_PMULHRSW_PqQq, &BX_CPU_C::PMULHRSW_PqQq, NULL)
bx_define_opcode(BX_IA_PABSB_PqQq, &BX_CPU_C::PABSB_PqQq, NULL)
bx_define_opcode(BX_IA_PABSW_PqQq, &BX_CPU_C::PABSW_PqQq, NULL)
bx_define_opcode(BX_IA_PABSD_PqQq, &BX_CPU_C::PABSD_PqQq, NULL)
bx_define_opcode(BX_IA_PALIGNR_PqQqIb, &BX_CPU_C::PALIGNR_PqQqIb, NULL)
bx_define_opcode(BX_IA_PSHUFB_VdqWdq, &BX_CPU_C::PSHUFB_VdqWdq, NULL)
bx_define_opcode(BX_IA_PHADDW_VdqWdq, &BX_CPU_C::PHADDW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PHADDD_VdqWdq, &BX_CPU_C::PHADDD_VdqWdq, NULL)
bx_define_opcode(BX_IA_PHADDSW_VdqWdq, &BX_CPU_C::PHADDSW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMADDUBSW_VdqWdq, &BX_CPU_C::PMADDUBSW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PHSUBSW_VdqWdq, &BX_CPU_C::PHSUBSW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PHSUBW_VdqWdq, &BX_CPU_C::PHSUBW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PHSUBD_VdqWdq, &BX_CPU_C::PHSUBD_VdqWdq, NULL)
bx_define_opcode(BX_IA_PSIGNB_VdqWdq, &BX_CPU_C::PSIGNB_VdqWdq, NULL)
bx_define_opcode(BX_IA_PSIGNW_VdqWdq, &BX_CPU_C::PSIGNW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PSIGND_VdqWdq, &BX_CPU_C::PSIGND_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMULHRSW_VdqWdq, &BX_CPU_C::PMULHRSW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PABSB_VdqWdq, &BX_CPU_C::PABSB_VdqWdq, NULL)
bx_define_opcode(BX_IA_PABSW_VdqWdq, &BX_CPU_C::PABSW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PABSD_VdqWdq, &BX_CPU_C::PABSD_VdqWdq, NULL)
bx_define_opcode(BX_IA_PALIGNR_VdqWdqIb, &BX_CPU_C::PALIGNR_VdqWdqIb, NULL)
// SSSE3

// SSE4.1
bx_define_opcode(BX_IA_PBLENDVB_VdqWdq, &BX_CPU_C::PBLENDVB_VdqWdq, NULL)
bx_define_opcode(BX_IA_BLENDVPS_VpsWps, &BX_CPU_C::BLENDVPS_VpsWps, NULL)
bx_define_opcode(BX_IA_BLENDVPD_VpdWpd, &BX_CPU_C::BLENDVPD_VpdWpd, NULL)
bx_define_opcode(BX_IA_PTEST_VdqWdq, &BX_CPU_C::PTEST_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMULDQ_VdqWdq, &BX_CPU_C::PMULDQ_VdqWdq, NULL)
bx_define_opcode(BX_IA_PCMPEQQ_VdqWdq, &BX_CPU_C::PCMPEQQ_VdqWdq, NULL)
bx_define_opcode(BX_IA_PACKUSDW_VdqWdq, &BX_CPU_C::PACKUSDW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMOVSXBW_VdqWq, &BX_CPU_C::PMOVSXBW_VdqWq, NULL)
bx_define_opcode(BX_IA_PMOVSXBD_VdqWd, &BX_CPU_C::PMOVSXBD_VdqWd, NULL)
bx_define_opcode(BX_IA_PMOVSXBQ_VdqWw, &BX_CPU_C::PMOVSXBQ_VdqWw, NULL)
bx_define_opcode(BX_IA_PMOVSXWD_VdqWq, &BX_CPU_C::PMOVSXWD_VdqWq, NULL)
bx_define_opcode(BX_IA_PMOVSXWQ_VdqWd, &BX_CPU_C::PMOVSXWQ_VdqWd, NULL)
bx_define_opcode(BX_IA_PMOVSXDQ_VdqWq, &BX_CPU_C::PMOVSXDQ_VdqWq, NULL)
bx_define_opcode(BX_IA_PMOVZXBW_VdqWq, &BX_CPU_C::PMOVZXBW_VdqWq, NULL)
bx_define_opcode(BX_IA_PMOVZXBD_VdqWd, &BX_CPU_C::PMOVZXBD_VdqWd, NULL)
bx_define_opcode(BX_IA_PMOVZXBQ_VdqWw, &BX_CPU_C::PMOVZXBQ_VdqWw, NULL)
bx_define_opcode(BX_IA_PMOVZXWD_VdqWq, &BX_CPU_C::PMOVZXWD_VdqWq, NULL)
bx_define_opcode(BX_IA_PMOVZXWQ_VdqWd, &BX_CPU_C::PMOVZXWQ_VdqWd, NULL)
bx_define_opcode(BX_IA_PMOVZXDQ_VdqWq, &BX_CPU_C::PMOVZXDQ_VdqWq, NULL)
bx_define_opcode(BX_IA_PMINSB_VdqWdq, &BX_CPU_C::PMINSB_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMINSD_VdqWdq, &BX_CPU_C::PMINSD_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMINUW_VdqWdq, &BX_CPU_C::PMINUW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMINUD_VdqWdq, &BX_CPU_C::PMINUD_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMAXSB_VdqWdq, &BX_CPU_C::PMAXSB_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMAXSD_VdqWdq, &BX_CPU_C::PMAXSD_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMAXUW_VdqWdq, &BX_CPU_C::PMAXUW_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMAXUD_VdqWdq, &BX_CPU_C::PMAXUD_VdqWdq, NULL)
bx_define_opcode(BX_IA_PMULLD_VdqWdq, &BX_CPU_C::PMULLD_VdqWdq, NULL)
bx_define_opcode(BX_IA_PHMINPOSUW_VdqWdq, &BX_CPU_C::PHMINPOSUW_VdqWdq, NULL)
bx_define_opcode(BX_IA_ROUNDPS_VpsWpsIb, &BX_CPU_C::ROUNDPS_VpsWpsIb, NULL)
bx_define_opcode(BX_IA_ROUNDPD_VpdWpdIb, &BX_CPU_C::ROUNDPD_VpdWpdIb, NULL)
bx_define_opcode(BX_IA_ROUNDSS_VssWssIb, &BX_CPU_C::ROUNDSS_VssWssIb, NULL)
bx_define_opcode(BX_IA_ROUNDSD_VsdWsdIb, &BX_CPU_C::ROUNDSD_VsdWsdIb, NULL)
bx_define_opcode(BX_IA_BLENDPS_VpsWpsIb, &BX_CPU_C::BLENDPS_VpsWpsIb, NULL)
bx_define_opcode(BX_IA_BLENDPD_VpdWpdIb, &BX_CPU_C::BLENDPD_VpdWpdIb, NULL)
bx_define_opcode(BX_IA_PBLENDW_VdqWdqIb, &BX_CPU_C::PBLENDW_VdqWdqIb, NULL)
bx_define_opcode(BX_IA_PEXTRB_HbdUdqIb, &BX_CPU_C::PEXTRB_HbdUdqIb, NULL)
bx_define_opcode(BX_IA_PEXTRW_HwdUdqIb, &BX_CPU_C::PEXTRW_HwdUdqIb, NULL)
bx_define_opcode(BX_IA_PEXTRD_HdUdqIb, &BX_CPU_C::PEXTRD_HdUdqIb, NULL)
bx_define_opcode(BX_IA_EXTRACTPS_HdUpsIb, &BX_CPU_C::EXTRACTPS_HdUpsIb, NULL)
bx_define_opcode(BX_IA_PINSRB_VdqEbIb, &BX_CPU_C::PINSRB_VdqEbIb, NULL)
bx_define_opcode(BX_IA_INSERTPS_VpsWssIb, &BX_CPU_C::INSERTPS_VpsWssIb, NULL)
bx_define_opcode(BX_IA_PINSRD_VdqEdIb, &BX_CPU_C::PINSRD_VdqEdIb, NULL)
bx_define_opcode(BX_IA_DPPS_VpsWpsIb, &BX_CPU_C::DPPS_VpsWpsIb, NULL)
bx_define_opcode(BX_IA_DPPD_VpdWpdIb, &BX_CPU_C::DPPD_VpdWpdIb, NULL)
bx_define_opcode(BX_IA_MPSADBW_VdqWdqIb, &BX_CPU_C::MPSADBW_VdqWdqIb, NULL)
bx_define_opcode(BX_IA_MOVNTDQA_VdqMdq, &BX_CPU_C::MOVNTDQA_VdqMdq, NULL)
// SSE4.1

// SSE4.2
bx_define_opcode(BX_IA_CRC32_GdEb, &BX_CPU_C::CRC32_GdEb, NULL)
bx_define_opcode(BX_IA_CRC32_GdEw, &BX_CPU_C::CRC32_GdEw, NULL)
bx_define_opcode(BX_IA_CRC32_GdEd, &BX_CPU_C::CRC32_GdEd, NULL)
#if BX_SUPPORT_X86_64
bx_define_opcode(BX_IA_CRC32_GdEq, &BX_CPU_C::CRC32_GdEq, NULL)
#endif
bx_define_opcode(BX_IA_PCMPGTQ_VdqWdq, &BX_CPU_C::PCMPGTQ_VdqWdq, NULL)
bx_define_opcode(BX_IA_PCMPESTRM_VdqWdqIb, &BX_CPU_C::PCMPESTRM_VdqWdqIb, NULL)
bx_define_opcode(BX_IA_PCMPESTRI_VdqWdqIb, &BX_CPU_C::PCMPESTRI_VdqWdqIb, NULL)
bx_define_opcode(BX_IA_PCMPISTRM_VdqWdqIb, &BX_CPU_C::PCMPISTRM_VdqWdqIb, NULL)
bx_define_opcode(BX_IA_PCMPISTRI_VdqWdqIb, &BX_CPU_C::PCMPISTRI_VdqWdqIb, NULL)
// SSE4.2

// MOVBE instruction
bx_define_opcode(BX_IA_MOVBE_GwEw, &BX_CPU_C::MOVBE_GwEw, NULL)
bx_define_opcode(BX_IA_MOVBE_GdEd, &BX_CPU_C::MOVBE_GdEd, NULL)
bx_define_opcode(BX_IA_MOVBE_EwGw, &BX_CPU_C::MOVBE_EwGw, NULL)
bx_define_opcode(BX_IA_MOVBE_EdGd, &BX_CPU_C::MOVBE_EdGd, NULL)
#if BX_SUPPORT_X86_64
bx_define_opcode(BX_IA_MOVBE_GqEq, &BX_CPU_C::MOVBE_GqEq, NULL)
bx_define_opcode(BX_IA_MOVBE_EqGq, &BX_CPU_C::MOVBE_EqGq, NULL)
#endif
// MOVBE instruction
#endif

// XSAVE extensions
bx_define_opcode(BX_IA_XRSTOR, &BX_CPU_C::XRSTOR, NULL)
bx_define_opcode(BX_IA_XSAVE, &BX_CPU_C::XSAVE, NULL)
bx_define_opcode(BX_IA_XSETBV, &BX_CPU_C::XSETBV, NULL)
bx_define_opcode(BX_IA_XGETBV, &BX_CPU_C::XGETBV, NULL)

// AES instructions
bx_define_opcode(BX_IA_AESIMC_VdqWdq, &BX_CPU_C::AESIMC_VdqWdq, NULL)
bx_define_opcode(BX_IA_AESENC_VdqWdq, &BX_CPU_C::AESENC_VdqWdq, NULL)
bx_define_opcode(BX_IA_AESENCLAST_VdqWdq, &BX_CPU_C::AESENCLAST_VdqWdq, NULL)
bx_define_opcode(BX_IA_AESDEC_VdqWdq, &BX_CPU_C::AESDEC_VdqWdq, NULL)
bx_define_opcode(BX_IA_AESDECLAST_VdqWdq, &BX_CPU_C::AESDECLAST_VdqWdq, NULL)
bx_define_opcode(BX_IA_AESKEYGENASSIST_VdqWdqIb, &BX_CPU_C::AESKEYGENASSIST_VdqWdqIb, NULL)

#if BX_SUPPORT_X86_64
bx_define_opcode(BX_IA_ADD_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::ADD_GqEqR)
bx_define_opcode(BX_IA_OR_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::OR_GqEqR)
bx_define_opcode(BX_IA_ADC_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::ADC_GqEqR)
bx_define_opcode(BX_IA_SBB_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::SBB_GqEqR)
bx_define_opcode(BX_IA_AND_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::AND_GqEqR)
bx_define_opcode(BX_IA_SUB_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::SUB_GqEqR)
bx_define_opcode(BX_IA_XOR_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::XOR_GqEqR)
bx_define_opcode(BX_IA_CMP_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMP_GqEqR)
bx_define_opcode(BX_IA_ADD_GqEqR, &BX_CPU_C::ADD_GqEqR, NULL)
bx_define_opcode(BX_IA_OR_GqEqR, &BX_CPU_C::OR_GqEqR, NULL)
bx_define_opcode(BX_IA_ADC_GqEqR, &BX_CPU_C::ADC_GqEqR, NULL)
bx_define_opcode(BX_IA_SBB_GqEqR, &BX_CPU_C::SBB_GqEqR, NULL)
bx_define_opcode(BX_IA_AND_GqEqR, &BX_CPU_C::AND_GqEqR, NULL)
bx_define_opcode(BX_IA_SUB_GqEqR, &BX_CPU_C::SUB_GqEqR, NULL)
bx_define_opcode(BX_IA_XOR_GqEqR, &BX_CPU_C::XOR_GqEqR, NULL)
bx_define_opcode(BX_IA_CMP_GqEqR, &BX_CPU_C::CMP_GqEqR, NULL)
bx_define_opcode(BX_IA_ADD_RAXId, &BX_CPU_C::ADD_RAXId, NULL)
bx_define_opcode(BX_IA_OR_RAXId, &BX_CPU_C::OR_RAXId, NULL)
bx_define_opcode(BX_IA_ADC_RAXId, &BX_CPU_C::ADC_RAXId, NULL)
bx_define_opcode(BX_IA_SBB_RAXId, &BX_CPU_C::SBB_RAXId, NULL)
bx_define_opcode(BX_IA_AND_RAXId, &BX_CPU_C::AND_RAXId, NULL)
bx_define_opcode(BX_IA_SUB_RAXId, &BX_CPU_C::SUB_RAXId, NULL)
bx_define_opcode(BX_IA_XOR_RAXId, &BX_CPU_C::XOR_RAXId, NULL)
bx_define_opcode(BX_IA_CMP_RAXId, &BX_CPU_C::CMP_RAXId, NULL)
bx_define_opcode(BX_IA_ADD_EqGqM, &BX_CPU_C::ADD_EqGqM, NULL)
bx_define_opcode(BX_IA_OR_EqGqM, &BX_CPU_C::OR_EqGqM, NULL)
bx_define_opcode(BX_IA_ADC_EqGqM, &BX_CPU_C::ADC_EqGqM, NULL)
bx_define_opcode(BX_IA_SBB_EqGqM, &BX_CPU_C::SBB_EqGqM, NULL)
bx_define_opcode(BX_IA_AND_EqGqM, &BX_CPU_C::AND_EqGqM, NULL)
bx_define_opcode(BX_IA_SUB_EqGqM, &BX_CPU_C::SUB_EqGqM, NULL)
bx_define_opcode(BX_IA_XOR_EqGqM, &BX_CPU_C::XOR_EqGqM, NULL)
bx_define_opcode(BX_IA_CMP_EqGqM, &BX_CPU_C::CMP_EqGqM, NULL)
bx_define_opcode(BX_IA_ADD_EqIdM, &BX_CPU_C::ADD_EqIdM, NULL)
bx_define_opcode(BX_IA_OR_EqIdM, &BX_CPU_C::OR_EqIdM, NULL)
bx_define_opcode(BX_IA_ADC_EqIdM, &BX_CPU_C::ADC_EqIdM, NULL)
bx_define_opcode(BX_IA_SBB_EqIdM, &BX_CPU_C::SBB_EqIdM, NULL)
bx_define_opcode(BX_IA_AND_EqIdM, &BX_CPU_C::AND_EqIdM, NULL)
bx_define_opcode(BX_IA_SUB_EqIdM, &BX_CPU_C::SUB_EqIdM, NULL)
bx_define_opcode(BX_IA_XOR_EqIdM, &BX_CPU_C::XOR_EqIdM, NULL)
bx_define_opcode(BX_IA_CMP_EqIdM, &BX_CPU_C::CMP_EqIdM, NULL)
bx_define_opcode(BX_IA_ADD_EqIdR, &BX_CPU_C::ADD_EqIdR, NULL)
bx_define_opcode(BX_IA_OR_EqIdR, &BX_CPU_C::OR_EqIdR, NULL)
bx_define_opcode(BX_IA_ADC_EqIdR, &BX_CPU_C::ADC_EqIdR, NULL)
bx_define_opcode(BX_IA_SBB_EqIdR, &BX_CPU_C::SBB_EqIdR, NULL)
bx_define_opcode(BX_IA_AND_EqIdR, &BX_CPU_C::AND_EqIdR, NULL)
bx_define_opcode(BX_IA_SUB_EqIdR, &BX_CPU_C::SUB_EqIdR, NULL)
bx_define_opcode(BX_IA_XOR_EqIdR, &BX_CPU_C::XOR_EqIdR, NULL)
bx_define_opcode(BX_IA_CMP_EqIdR, &BX_CPU_C::CMP_EqIdR, NULL)
bx_define_opcode(BX_IA_TEST_EqGqR, &BX_CPU_C::TEST_EqGqR, NULL)
bx_define_opcode(BX_IA_TEST_EqGqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::TEST_EqGqR)
bx_define_opcode(BX_IA_TEST_RAXId, &BX_CPU_C::TEST_RAXId, NULL)
bx_define_opcode(BX_IA_XCHG_EqGqR, &BX_CPU_C::XCHG_EqGqR, NULL)
bx_define_opcode(BX_IA_XCHG_EqGqM, &BX_CPU_C::XCHG_EqGqM, NULL)
bx_define_opcode(BX_IA_LEA_GqM, &BX_CPU_C::LEA_GqM, NULL)
bx_define_opcode(BX_IA_MOV64_EdGdM, &BX_CPU_C::MOV64_EdGdM, NULL)
bx_define_opcode(BX_IA_MOV64_GdEdM, &BX_CPU_C::MOV64_GdEdM, NULL)
bx_define_opcode(BX_IA_MOV_RAXOq, &BX_CPU_C::MOV_RAXOq, NULL)
bx_define_opcode(BX_IA_MOV_OqRAX, &BX_CPU_C::MOV_OqRAX, NULL)
bx_define_opcode(BX_IA_MOV_EAXOq, &BX_CPU_C::MOV_EAXOq, NULL)
bx_define_opcode(BX_IA_MOV_OqEAX, &BX_CPU_C::MOV_OqEAX, NULL)
bx_define_opcode(BX_IA_MOV_AXOq, &BX_CPU_C::MOV_AXOq, NULL)
bx_define_opcode(BX_IA_MOV_OqAX, &BX_CPU_C::MOV_OqAX, NULL)
bx_define_opcode(BX_IA_MOV_ALOq, &BX_CPU_C::MOV_ALOq, NULL)
bx_define_opcode(BX_IA_MOV_OqAL, &BX_CPU_C::MOV_OqAL, NULL)
bx_define_opcode(BX_IA_MOV_EqGqM, &BX_CPU_C::MOV_EqGqM, NULL)
bx_define_opcode(BX_IA_MOV_GqEqR, &BX_CPU_C::MOV_GqEqR, NULL)
bx_define_opcode(BX_IA_MOV_GqEqM, &BX_CPU_C::MOV_GqEqM, NULL)
bx_define_opcode(BX_IA_MOV_EqIdR, &BX_CPU_C::MOV_EqIdR, NULL)
bx_define_opcode(BX_IA_MOV_EqIdM, &BX_CPU_C::MOV_EqIdM, NULL)
bx_define_opcode(BX_IA_REP_MOVSQ_XqYq, &BX_CPU_C::REP_MOVSQ_XqYq, NULL)
bx_define_opcode(BX_IA_REP_CMPSQ_XqYq, &BX_CPU_C::REP_CMPSQ_XqYq, NULL)
bx_define_opcode(BX_IA_REP_STOSQ_YqRAX, &BX_CPU_C::REP_STOSQ_YqRAX, NULL)
bx_define_opcode(BX_IA_REP_LODSQ_RAXXq, &BX_CPU_C::REP_LODSQ_RAXXq, NULL)
bx_define_opcode(BX_IA_REP_SCASQ_RAXXq, &BX_CPU_C::REP_SCASQ_RAXXq, NULL)
bx_define_opcode(BX_IA_CMPSB64_XbYb, &BX_CPU_C::CMPSB64_XbYb, NULL)
bx_define_opcode(BX_IA_CMPSW64_XwYw, &BX_CPU_C::CMPSW64_XwYw, NULL)
bx_define_opcode(BX_IA_CMPSD64_XdYd, &BX_CPU_C::CMPSD64_XdYd, NULL)
bx_define_opcode(BX_IA_SCASB64_ALXb, &BX_CPU_C::SCASB64_ALXb, NULL)
bx_define_opcode(BX_IA_SCASW64_AXXw, &BX_CPU_C::SCASW64_AXXw, NULL)
bx_define_opcode(BX_IA_SCASD64_EAXXd, &BX_CPU_C::SCASD64_EAXXd, NULL)
bx_define_opcode(BX_IA_LODSB64_ALXb, &BX_CPU_C::LODSB64_ALXb, NULL)
bx_define_opcode(BX_IA_LODSW64_AXXw, &BX_CPU_C::LODSW64_AXXw, NULL)
bx_define_opcode(BX_IA_LODSD64_EAXXd, &BX_CPU_C::LODSD64_EAXXd, NULL)
bx_define_opcode(BX_IA_STOSB64_YbAL, &BX_CPU_C::STOSB64_YbAL, NULL)
bx_define_opcode(BX_IA_STOSW64_YwAX, &BX_CPU_C::STOSW64_YwAX, NULL)
bx_define_opcode(BX_IA_STOSD64_YdEAX, &BX_CPU_C::STOSD64_YdEAX, NULL)
bx_define_opcode(BX_IA_MOVSB64_XbYb, &BX_CPU_C::MOVSB64_XbYb, NULL)
bx_define_opcode(BX_IA_MOVSW64_XwYw, &BX_CPU_C::MOVSW64_XwYw, NULL)
bx_define_opcode(BX_IA_MOVSD64_XdYd, &BX_CPU_C::MOVSD64_XdYd, NULL)
bx_define_opcode(BX_IA_CMPSQ32_XqYq, &BX_CPU_C::CMPSQ32_XqYq, NULL)
bx_define_opcode(BX_IA_CMPSQ64_XqYq, &BX_CPU_C::CMPSQ64_XqYq, NULL)
bx_define_opcode(BX_IA_SCASQ32_RAXXq, &BX_CPU_C::SCASQ32_RAXXq, NULL)
bx_define_opcode(BX_IA_SCASQ64_RAXXq, &BX_CPU_C::SCASQ64_RAXXq, NULL)
bx_define_opcode(BX_IA_LODSQ32_RAXXq, &BX_CPU_C::LODSQ32_RAXXq, NULL)
bx_define_opcode(BX_IA_LODSQ64_RAXXq, &BX_CPU_C::LODSQ64_RAXXq, NULL)
bx_define_opcode(BX_IA_STOSQ32_YqRAX, &BX_CPU_C::STOSQ32_YqRAX, NULL)
bx_define_opcode(BX_IA_STOSQ64_YqRAX, &BX_CPU_C::STOSQ64_YqRAX, NULL)
bx_define_opcode(BX_IA_MOVSQ32_XqYq, &BX_CPU_C::MOVSQ32_XqYq, NULL)
bx_define_opcode(BX_IA_MOVSQ64_XqYq, &BX_CPU_C::MOVSQ64_XqYq, NULL)
bx_define_opcode(BX_IA_CALL_Jq, &BX_CPU_C::CALL_Jq, NULL)
bx_define_opcode(BX_IA_JMP_Jq, &BX_CPU_C::JMP_Jq, NULL)
bx_define_opcode(BX_IA_JO_Jq, &BX_CPU_C::JO_Jq, NULL)
bx_define_opcode(BX_IA_JNO_Jq, &BX_CPU_C::JNO_Jq, NULL)
bx_define_opcode(BX_IA_JB_Jq, &BX_CPU_C::JB_Jq, NULL)
bx_define_opcode(BX_IA_JNB_Jq, &BX_CPU_C::JNB_Jq, NULL)
bx_define_opcode(BX_IA_JZ_Jq, &BX_CPU_C::JZ_Jq, NULL)
bx_define_opcode(BX_IA_JNZ_Jq, &BX_CPU_C::JNZ_Jq, NULL)
bx_define_opcode(BX_IA_JBE_Jq, &BX_CPU_C::JBE_Jq, NULL)
bx_define_opcode(BX_IA_JNBE_Jq, &BX_CPU_C::JNBE_Jq, NULL)
bx_define_opcode(BX_IA_JS_Jq, &BX_CPU_C::JS_Jq, NULL)
bx_define_opcode(BX_IA_JNS_Jq, &BX_CPU_C::JNS_Jq, NULL)
bx_define_opcode(BX_IA_JP_Jq, &BX_CPU_C::JP_Jq, NULL)
bx_define_opcode(BX_IA_JNP_Jq, &BX_CPU_C::JNP_Jq, NULL)
bx_define_opcode(BX_IA_JL_Jq, &BX_CPU_C::JL_Jq, NULL)
bx_define_opcode(BX_IA_JNL_Jq, &BX_CPU_C::JNL_Jq, NULL)
bx_define_opcode(BX_IA_JLE_Jq, &BX_CPU_C::JLE_Jq, NULL)
bx_define_opcode(BX_IA_JNLE_Jq, &BX_CPU_C::JNLE_Jq, NULL)
bx_define_opcode(BX_IA_ENTER64_IwIb, &BX_CPU_C::ENTER64_IwIb, NULL)
bx_define_opcode(BX_IA_LEAVE64, &BX_CPU_C::LEAVE64, NULL)
bx_define_opcode(BX_IA_IRET64, &BX_CPU_C::IRET64, NULL)
bx_define_opcode(BX_IA_MOV_CqRq, &BX_CPU_C::MOV_CqRq, NULL)
bx_define_opcode(BX_IA_MOV_DqRq, &BX_CPU_C::MOV_DqRq, NULL)
bx_define_opcode(BX_IA_MOV_RqCq, &BX_CPU_C::MOV_RqCq, NULL)
bx_define_opcode(BX_IA_MOV_RqDq, &BX_CPU_C::MOV_RqDq, NULL)
bx_define_opcode(BX_IA_SHLD_EqGqR, &BX_CPU_C::SHLD_EqGqR, NULL)
bx_define_opcode(BX_IA_SHLD_EqGqM, &BX_CPU_C::SHLD_EqGqM, NULL)
bx_define_opcode(BX_IA_SHRD_EqGqR, &BX_CPU_C::SHRD_EqGqR, NULL)
bx_define_opcode(BX_IA_SHRD_EqGqM, &BX_CPU_C::SHRD_EqGqM, NULL)
bx_define_opcode(BX_IA_IMUL_GqEqR, &BX_CPU_C::IMUL_GqEqR, NULL)
bx_define_opcode(BX_IA_IMUL_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::IMUL_GqEqR)
bx_define_opcode(BX_IA_IMUL_GqEqIdR, &BX_CPU_C::IMUL_GqEqIdR, NULL)
bx_define_opcode(BX_IA_IMUL_GqEqIdM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::IMUL_GqEqIdR)
bx_define_opcode(BX_IA_MOVZX_GqEbM, &BX_CPU_C::MOVZX_GqEbM, NULL)
bx_define_opcode(BX_IA_MOVZX_GqEwM, &BX_CPU_C::MOVZX_GqEwM, NULL)
bx_define_opcode(BX_IA_MOVSX_GqEbM, &BX_CPU_C::MOVSX_GqEbM, NULL)
bx_define_opcode(BX_IA_MOVSX_GqEwM, &BX_CPU_C::MOVSX_GqEwM, NULL)
bx_define_opcode(BX_IA_MOVSX_GqEdM, &BX_CPU_C::MOVSX_GqEdM, NULL)
bx_define_opcode(BX_IA_MOVZX_GqEbR, &BX_CPU_C::MOVZX_GqEbR, NULL)
bx_define_opcode(BX_IA_MOVZX_GqEwR, &BX_CPU_C::MOVZX_GqEwR, NULL)
bx_define_opcode(BX_IA_MOVSX_GqEbR, &BX_CPU_C::MOVSX_GqEbR, NULL)
bx_define_opcode(BX_IA_MOVSX_GqEwR, &BX_CPU_C::MOVSX_GqEwR, NULL)
bx_define_opcode(BX_IA_MOVSX_GqEdR, &BX_CPU_C::MOVSX_GqEdR, NULL)
bx_define_opcode(BX_IA_BSF_GqEqR, &BX_CPU_C::BSF_GqEqR, NULL)
bx_define_opcode(BX_IA_BSF_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::BSF_GqEqR)
bx_define_opcode(BX_IA_BSR_GqEqR, &BX_CPU_C::BSR_GqEqR, NULL)
bx_define_opcode(BX_IA_BSR_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::BSR_GqEqR)
bx_define_opcode(BX_IA_BT_EqGqM, &BX_CPU_C::BT_EqGqM, NULL)
bx_define_opcode(BX_IA_BTS_EqGqM, &BX_CPU_C::BTS_EqGqM, NULL)
bx_define_opcode(BX_IA_BTR_EqGqM, &BX_CPU_C::BTR_EqGqM, NULL)
bx_define_opcode(BX_IA_BTC_EqGqM, &BX_CPU_C::BTC_EqGqM, NULL)
bx_define_opcode(BX_IA_BT_EqGqR, &BX_CPU_C::BT_EqGqR, NULL)
bx_define_opcode(BX_IA_BTS_EqGqR, &BX_CPU_C::BTS_EqGqR, NULL)
bx_define_opcode(BX_IA_BTR_EqGqR, &BX_CPU_C::BTR_EqGqR, NULL)
bx_define_opcode(BX_IA_BTC_EqGqR, &BX_CPU_C::BTC_EqGqR, NULL)
bx_define_opcode(BX_IA_BT_EqIbM, &BX_CPU_C::BT_EqIbM, NULL)
bx_define_opcode(BX_IA_BTS_EqIbM, &BX_CPU_C::BTS_EqIbM, NULL)
bx_define_opcode(BX_IA_BTR_EqIbM, &BX_CPU_C::BTR_EqIbM, NULL)
bx_define_opcode(BX_IA_BTC_EqIbM, &BX_CPU_C::BTC_EqIbM, NULL)
bx_define_opcode(BX_IA_BT_EqIbR, &BX_CPU_C::BT_EqIbR, NULL)
bx_define_opcode(BX_IA_BTS_EqIbR, &BX_CPU_C::BTS_EqIbR, NULL)
bx_define_opcode(BX_IA_BTR_EqIbR, &BX_CPU_C::BTR_EqIbR, NULL)
bx_define_opcode(BX_IA_BTC_EqIbR, &BX_CPU_C::BTC_EqIbR, NULL)
bx_define_opcode(BX_IA_BSWAP_RRX, &BX_CPU_C::BSWAP_RRX, NULL)
bx_define_opcode(BX_IA_ROL_EqM, &BX_CPU_C::ROL_EqM, NULL)
bx_define_opcode(BX_IA_ROR_EqM, &BX_CPU_C::ROR_EqM, NULL)
bx_define_opcode(BX_IA_RCL_EqM, &BX_CPU_C::RCL_EqM, NULL)
bx_define_opcode(BX_IA_RCR_EqM, &BX_CPU_C::RCR_EqM, NULL)
bx_define_opcode(BX_IA_SHL_EqM, &BX_CPU_C::SHL_EqM, NULL)
bx_define_opcode(BX_IA_SHR_EqM, &BX_CPU_C::SHR_EqM, NULL)
bx_define_opcode(BX_IA_SAR_EqM, &BX_CPU_C::SAR_EqM, NULL)
bx_define_opcode(BX_IA_ROL_EqR, &BX_CPU_C::ROL_EqR, NULL)
bx_define_opcode(BX_IA_ROR_EqR, &BX_CPU_C::ROR_EqR, NULL)
bx_define_opcode(BX_IA_RCL_EqR, &BX_CPU_C::RCL_EqR, NULL)
bx_define_opcode(BX_IA_RCR_EqR, &BX_CPU_C::RCR_EqR, NULL)
bx_define_opcode(BX_IA_SHL_EqR, &BX_CPU_C::SHL_EqR, NULL)
bx_define_opcode(BX_IA_SHR_EqR, &BX_CPU_C::SHR_EqR, NULL)
bx_define_opcode(BX_IA_SAR_EqR, &BX_CPU_C::SAR_EqR, NULL)
bx_define_opcode(BX_IA_NOT_EqM, &BX_CPU_C::NOT_EqM, NULL)
bx_define_opcode(BX_IA_NEG_EqM, &BX_CPU_C::NEG_EqM, NULL)
bx_define_opcode(BX_IA_NOT_EqR, &BX_CPU_C::NOT_EqR, NULL)
bx_define_opcode(BX_IA_NEG_EqR, &BX_CPU_C::NEG_EqR, NULL)
bx_define_opcode(BX_IA_TEST_EqIdM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::TEST_EqIdR)
bx_define_opcode(BX_IA_TEST_EqIdR, &BX_CPU_C::TEST_EqIdR, NULL)
bx_define_opcode(BX_IA_MUL_RAXEqR, &BX_CPU_C::MUL_RAXEqR, NULL)
bx_define_opcode(BX_IA_MUL_RAXEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::MUL_RAXEqR)
bx_define_opcode(BX_IA_IMUL_RAXEqR, &BX_CPU_C::IMUL_RAXEqR, NULL)
bx_define_opcode(BX_IA_IMUL_RAXEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::IMUL_RAXEqR)
bx_define_opcode(BX_IA_DIV_RAXEqR, &BX_CPU_C::DIV_RAXEqR, NULL)
bx_define_opcode(BX_IA_DIV_RAXEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::DIV_RAXEqR)
bx_define_opcode(BX_IA_IDIV_RAXEqR, &BX_CPU_C::IDIV_RAXEqR, NULL)
bx_define_opcode(BX_IA_IDIV_RAXEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::IDIV_RAXEqR)
bx_define_opcode(BX_IA_INC_EqM, &BX_CPU_C::INC_EqM, NULL)
bx_define_opcode(BX_IA_DEC_EqM, &BX_CPU_C::DEC_EqM, NULL)
bx_define_opcode(BX_IA_INC_EqR, &BX_CPU_C::INC_EqR, NULL)
bx_define_opcode(BX_IA_DEC_EqR, &BX_CPU_C::DEC_EqR, NULL)
bx_define_opcode(BX_IA_CALL_EqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CALL_EqR)
bx_define_opcode(BX_IA_CALL_EqR, &BX_CPU_C::CALL_EqR, NULL)
bx_define_opcode(BX_IA_CALL64_Ep, &BX_CPU_C::CALL64_Ep, NULL)
bx_define_opcode(BX_IA_JMP_EqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::JMP_EqR)
bx_define_opcode(BX_IA_JMP_EqR, &BX_CPU_C::JMP_EqR, NULL)
bx_define_opcode(BX_IA_JMP64_Ep, &BX_CPU_C::JMP64_Ep, NULL)
bx_define_opcode(BX_IA_PUSHF_Fq, &BX_CPU_C::PUSHF_Fq, NULL)
bx_define_opcode(BX_IA_POPF_Fq, &BX_CPU_C::POPF_Fq, NULL)
bx_define_opcode(BX_IA_CMPXCHG_EqGqR, &BX_CPU_C::CMPXCHG_EqGqR, NULL)
bx_define_opcode(BX_IA_CMPXCHG_EqGqM, &BX_CPU_C::CMPXCHG_EqGqM, NULL)
bx_define_opcode(BX_IA_CDQE, &BX_CPU_C::CDQE, NULL)
bx_define_opcode(BX_IA_CQO, &BX_CPU_C::CQO, NULL)
bx_define_opcode(BX_IA_XADD_EqGqR, &BX_CPU_C::XADD_EqGqR, NULL)
bx_define_opcode(BX_IA_XADD_EqGqM, &BX_CPU_C::XADD_EqGqM, NULL)
bx_define_opcode(BX_IA_RETnear64_Iw, &BX_CPU_C::RETnear64_Iw, NULL)
bx_define_opcode(BX_IA_RETnear64, &BX_CPU_C::RETnear64, NULL)
bx_define_opcode(BX_IA_RETfar64_Iw, &BX_CPU_C::RETfar64_Iw, NULL)
bx_define_opcode(BX_IA_RETfar64, &BX_CPU_C::RETfar64_Iw, NULL)
bx_define_opcode(BX_IA_CMOVO_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVO_GqEqR)
bx_define_opcode(BX_IA_CMOVNO_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNO_GqEqR)
bx_define_opcode(BX_IA_CMOVB_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVB_GqEqR)
bx_define_opcode(BX_IA_CMOVNB_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNB_GqEqR)
bx_define_opcode(BX_IA_CMOVZ_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVZ_GqEqR)
bx_define_opcode(BX_IA_CMOVNZ_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNZ_GqEqR)
bx_define_opcode(BX_IA_CMOVBE_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVBE_GqEqR)
bx_define_opcode(BX_IA_CMOVNBE_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNBE_GqEqR)
bx_define_opcode(BX_IA_CMOVS_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVS_GqEqR)
bx_define_opcode(BX_IA_CMOVNS_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNS_GqEqR)
bx_define_opcode(BX_IA_CMOVP_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVP_GqEqR)
bx_define_opcode(BX_IA_CMOVNP_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNP_GqEqR)
bx_define_opcode(BX_IA_CMOVL_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVL_GqEqR)
bx_define_opcode(BX_IA_CMOVNL_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNL_GqEqR)
bx_define_opcode(BX_IA_CMOVLE_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVLE_GqEqR)
bx_define_opcode(BX_IA_CMOVNLE_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNLE_GqEqR)
bx_define_opcode(BX_IA_CMOVO_GqEqR, &BX_CPU_C::CMOVO_GqEqR, NULL)
bx_define_opcode(BX_IA_CMOVNO_GqEqR, &BX_CPU_C::CMOVNO_GqEqR, NULL)
bx_define_opcode(BX_IA_CMOVB_GqEqR, &BX_CPU_C::CMOVB_GqEqR, NULL)
bx_define_opcode(BX_IA_CMOVNB_GqEqR, &BX_CPU_C::CMOVNB_GqEqR, NULL)
bx_define_opcode(BX_IA_CMOVZ_GqEqR, &BX_CPU_C::CMOVZ_GqEqR, NULL)
bx_define_opcode(BX_IA_CMOVNZ_GqEqR, &BX_CPU_C::CMOVNZ_GqEqR, NULL)
bx_define_opcode(BX_IA_CMOVBE_GqEqR, &BX_CPU_C::CMOVBE_GqEqR, NULL)
bx_define_opcode(BX_IA_CMOVNBE_GqEqR, &BX_CPU_C::CMOVNBE_GqEqR, NULL)
bx_define_opcode(BX_IA_CMOVS_GqEqR, &BX_CPU_C::CMOVS_GqEqR, NULL)
bx_define_opcode(BX_IA_CMOVNS_GqEqR, &BX_CPU_C::CMOVNS_GqEqR, NULL)
bx_define_opcode(BX_IA_CMOVP_GqEqR, &BX_CPU_C::CMOVP_GqEqR, NULL)
bx_define_opcode(BX_IA_CMOVNP_GqEqR, &BX_CPU_C::CMOVNP_GqEqR, NULL)
bx_define_opcode(BX_IA_CMOVL_GqEqR, &BX_CPU_C::CMOVL_GqEqR, NULL)
bx_define_opcode(BX_IA_CMOVNL_GqEqR, &BX_CPU_C::CMOVNL_GqEqR, NULL)
bx_define_opcode(BX_IA_CMOVLE_GqEqR, &BX_CPU_C::CMOVLE_GqEqR, NULL)
bx_define_opcode(BX_IA_CMOVNLE_GqEqR, &BX_CPU_C::CMOVNLE_GqEqR, NULL)
bx_define_opcode(BX_IA_MOV_RRXIq, &BX_CPU_C::MOV_RRXIq, NULL)
bx_define_opcode(BX_IA_PUSH_EqM, &BX_CPU_C::PUSH_EqM, NULL)
bx_define_opcode(BX_IA_PUSH_EqR, &BX_CPU_C::PUSH_RRX, NULL)
bx_define_opcode(BX_IA_PUSH_RRX, &BX_CPU_C::PUSH_RRX, NULL)
bx_define_opcode(BX_IA_POP_EqM, &BX_CPU_C::POP_EqM, NULL)
bx_define_opcode(BX_IA_POP_EqR, &BX_CPU_C::POP_RRX, NULL)
bx_define_opcode(BX_IA_POP_RRX, &BX_CPU_C::POP_RRX, NULL)
bx_define_opcode(BX_IA_XCHG_RRXRAX, &BX_CPU_C::XCHG_RRXRAX, NULL)
bx_define_opcode(BX_IA_PUSH64_Id, &BX_CPU_C::PUSH64_Id, NULL)
bx_define_opcode(BX_IA_PUSH64_FS, &BX_CPU_C::PUSH64_FS, NULL)
bx_define_opcode(BX_IA_POP64_FS, &BX_CPU_C::POP64_FS, NULL)
bx_define_opcode(BX_IA_PUSH64_GS, &BX_CPU_C::PUSH64_GS, NULL)
bx_define_opcode(BX_IA_POP64_GS, &BX_CPU_C::POP64_GS, NULL)
bx_define_opcode(BX_IA_LSS_GqMp, &BX_CPU_C::LSS_GqMp, NULL)
bx_define_opcode(BX_IA_LFS_GqMp, &BX_CPU_C::LFS_GqMp, NULL)
bx_define_opcode(BX_IA_LGS_GqMp, &BX_CPU_C::LGS_GqMp, NULL)
bx_define_opcode(BX_IA_SGDT64_Ms, &BX_CPU_C::SGDT64_Ms, NULL)
bx_define_opcode(BX_IA_SIDT64_Ms, &BX_CPU_C::SIDT64_Ms, NULL)
bx_define_opcode(BX_IA_LGDT64_Ms, &BX_CPU_C::LGDT64_Ms, NULL)
bx_define_opcode(BX_IA_LIDT64_Ms, &BX_CPU_C::LIDT64_Ms, NULL)
bx_define_opcode(BX_IA_SYSCALL, &BX_CPU_C::SYSCALL, NULL)
bx_define_opcode(BX_IA_SYSRET, &BX_CPU_C::SYSRET, NULL)
bx_define_opcode(BX_IA_SWAPGS, &BX_CPU_C::SWAPGS, NULL)
bx_define_opcode(BX_IA_RDTSCP, &BX_CPU_C::RDTSCP, NULL)
bx_define_opcode(BX_IA_CMPXCHG16B, &BX_CPU_C::CMPXCHG16B, NULL)
bx_define_opcode(BX_IA_LOOPNE64_Jb, &BX_CPU_C::LOOPNE64_Jb, NULL)
bx_define_opcode(BX_IA_LOOPE64_Jb, &BX_CPU_C::LOOPE64_Jb, NULL)
bx_define_opcode(BX_IA_LOOP64_Jb, &BX_CPU_C::LOOP64_Jb, NULL)
bx_define_opcode(BX_IA_JRCXZ_Jb, &BX_CPU_C::JRCXZ_Jb, NULL)
bx_define_opcode(BX_IA_MOVQ_EqPq, &BX_CPU_C::MOVQ_EqPq, NULL)
bx_define_opcode(BX_IA_MOVQ_EqVq, &BX_CPU_C::MOVQ_EqVq, NULL)
bx_define_opcode(BX_IA_MOVQ_PqEqR, &BX_CPU_C::MOVQ_PqEqR, NULL)
bx_define_opcode(BX_IA_MOVQ_PqEqM, &BX_CPU_C::MOVQ_PqEqM, NULL)
bx_define_opcode(BX_IA_MOVQ_VdqEq, &BX_CPU_C::MOVQ_VdqEq, NULL)
bx_define_opcode(BX_IA_MOVNTI_MqGq, &BX_CPU_C::MOVNTI_MqGq, NULL)
bx_define_opcode(BX_IA_POPCNT_GqEqR, &BX_CPU_C::POPCNT_GqEqR, NULL)
bx_define_opcode(BX_IA_POPCNT_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::POPCNT_GqEqR)
#endif

// VMX
bx_define_opcode(BX_IA_VMXON_Mq, &BX_CPU_C::VMXON, NULL)
bx_define_opcode(BX_IA_VMXOFF, &BX_CPU_C::VMXOFF, NULL)
bx_define_opcode(BX_IA_VMCALL, &BX_CPU_C::VMCALL, NULL)
bx_define_opcode(BX_IA_VMLAUNCH, &BX_CPU_C::VMLAUNCH, NULL)
bx_define_opcode(BX_IA_VMRESUME, &BX_CPU_C::VMLAUNCH, NULL)
bx_define_opcode(BX_IA_VMCLEAR_Mq, &BX_CPU_C::VMCLEAR, NULL)
bx_define_opcode(BX_IA_VMPTRLD_Mq, &BX_CPU_C::VMPTRLD, NULL)
bx_define_opcode(BX_IA_VMPTRST_Mq, &BX_CPU_C::VMPTRST, NULL)
bx_define_opcode(BX_IA_VMREAD_EdGd, &BX_CPU_C::VMREAD, NULL)
bx_define_opcode(BX_IA_VMWRITE_GdEd, &BX_CPU_C::VMWRITE, NULL)
#if BX_SUPPORT_X86_64
bx_define_opcode(BX_IA_VMREAD_EqGq, &BX_CPU_C::VMREAD, NULL)
bx_define_opcode(BX_IA_VMWRITE_GqEq, &BX_CPU_C::VMWRITE, NULL)
#endif
// VMX
