// Copyright 2003 Regents of the University of California

// SETI_BOINC is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2, or (at your option) any later
// version.

// SETI_BOINC is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
// more details.

// You should have received a copy of the GNU General Public License along
// with SETI_BOINC; see the file COPYING.  If not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// In addition, as a special exception, the Regents of the University of
// California give permission to link the code of this program with libraries
// that provide specific optimized fast Fourier transform (FFT) functions and
// distribute a linked executable.  You must obey the GNU General Public 
// License in all respects for all of the code used other than the FFT library
// itself.  Any modification required to support these libraries must be
// distributed in source code form.  If you modify this file, you may extend 
// this exception to your version of the file, but you are not obligated to 
// do so. If you do not wish to do so, delete this exception statement from 
// your version.

// $Id: s_util.h,v 1.12.2.4 2005/10/11 22:44:17 korpela Exp $
#ifndef _UTIL_H
#define _UTIL_H

#include <cstdio>
#include <sys/types.h>
#include <string>
#include "track_mem.h"

typedef float sah_complex[2];

// The following is a complete list of #defines used in the code:
// TEXT_UI
// textual UI using printf, scanf
// NOTE: the above are not mutually exclusive
// _WIN32
// windows environment.  does not imply GUI
// _WIN_NT_98
// Win NT or 98 environment
// TEST_VERSION
// include extra command-line options
// HAVE_*
// (POSIX only) presence or absence of functions, .h files
// as generated by configure script

// client file names
#define OUTFILE_FILENAME "result.sah"
#define STATE_FILENAME  "state.sah"
#define WU_FILENAME  "work_unit.sah"
#define CFFT_FILENAME  "cfft.sah"

#define INF 0x7fffffff
#define ROUND(a) ((a) - (long)(a) > .5 ? (long)(a) + 1 : (long)(a))

#define TASK_SETI 2

class seti_error {
  public:
    typedef enum {
      success=0,
      cant_create_file,
      read_failed,
      write_failed,
      malloc_failed,
      fopen_failed,
      bad_header,
      bad_decode,
      bad_bin_read,
      result_overflow,
      unhandled_signal,
      atexit_failure,
      floating_point_fail
    } errors;
    static const char * const message[];
    seti_error(int e, const char *s=0) : value(-e), data(s) {};
    seti_error(int e, const char *f, int l, const char *s=0) : value(-e), file(f), line(l), data(s) {};
    seti_error(const seti_error &e) : value(e.value), file(e.file), line(e.line), data(e.data) {};
    operator int() const { return -value; };
    void print() const;  
  private:
    int value;
    std::string file;
    int line;
    std::string data;
};
  
   

// error codes
#define SUCCESS				0
#define CANT_CREATE_FILE	(-seti_error::cant_create_file)
#define READ_FAILED 		(-seti_error::read_failed)
#define WRITE_FAILED		(-seti_error::write_failed)
#define MALLOC_FAILED		(-seti_error::malloc_failed)
#define FOPEN_FAILED		(-seti_error::fopen_failed)
#define BAD_HEADER			(-seti_error::bad_header)
#define BAD_DECODE			(-seti_error::bad_decode)
#define BAD_BIN_READ		(-seti_error::bad_bin_read)
#define RESULT_OVERFLOW		(-seti_error::result_overflow)
#define UNHANDLED_SIGNAL	(-seti_error::unhandled_signal)
#define FP_ERROR         	(-seti_error::floating_point_fail)
#define ATEXIT_FAILURE         	(-seti_error::atexit_failure)


// macro so we can get file and line info.
#define SETIERROR( err, errmsg ) \
	throw seti_error( err, __FILE__, __LINE__, errmsg  )


#define CHECKPOINT_SKIPPED	(0)

//#include "seti_header.h"

extern void strip_cr(char*p );

extern void encode(unsigned char* bin, int nbytes, FILE* f);
extern int decode(unsigned char* bin, int nbytes, FILE* f);
extern int read_bin_data(unsigned char* bin, int nbytes, FILE* f);
extern void bits_to_floats(unsigned char* raw, sah_complex *data, int nsamples);
extern int float_to_uchar(
    float float_element[], unsigned char char_element[],
    long num_elements, float scale_factor
  );
extern char* error_string(int);

#endif
