
#include "bomberclone.h"
#include "network.h"
#include "packets.h"

int debug;

void d_gamedetail (char *head) {
	d_playerdetail (head);
	
    d_printf ("p_nr = %d          ", bman.p_nr);
    d_printf ("p_servnr = %d     \n", bman.p_servnr);
    d_printf ("players_nr = %d    ", bman.players_nr);
    d_printf ("players_nr_s = %d \n", bman.players_nr_s);
    d_printf ("gametype = %d      ", bman.gametype);
    d_printf ("state = %d\n", bman.state);
};


void d_printsdlrect (char *text, SDL_Rect *rect) {
	d_printf ("%s  [x=%4d, y=%4d, w=%4d, h=%4d]\n", text, rect->x, rect->y, rect->w, rect->h);	
};

void d_printf (char *fmt,...) {
	va_list args;
	
	if (debug == 0)
		return;
	
	va_start (args, fmt);
	fprintf (stdout, "[%8d] :", timestamp);
	vfprintf (stdout, fmt, args);
	va_end (args);
};


void d_playerdetail (char *head) {
	int i;

	d_printf ("---------------> %s\n", head);
	d_printf ("Nr Name              GFX Sta Pkt Win [Addr] net_flag\n");
	for (i = 0; i < MAX_PLAYERS; i++)
		d_printf ("%2d %16s %3d %3d %3d %3d [%s:%s] %d\n",i, players[i].name, players[i].gfx_nr, players[i].state, players[i].points, players[i].wins, players[i].net.addr.host, players[i].net.addr.port, players[i].net.flags);
};


void d_bitprint (int bits, int nr) {
	int i;

	for (i = nr-1; i >= 0; i--)
		if ((bits & (1 << i)) == 0)
			printf ("-");
		else 
			printf ("X");
	printf (" ");
};


void d_fatal (char *fmt,...) {
	va_list args;
	
	va_start (args, fmt);
	fprintf (stdout, "FATAL:");
	vfprintf (stdout, fmt, args);
	va_end (args);
}


void debug_ingameinfo() {
	int i;
	char text[255];
	
	for (i = 0; i < map.size.x; i++)
		stonelist_add (i, map.size.y-1);

	redraw_logo (0, gfx.res.y-font[0].size.y * 2, gfx.res.y, gfx.res.x);
	sprintf (text, "TDiff: %2.3f TFactor: %2.3f", timediff, timefactor);	
	font_gfxdraw (0, gfx.res.y-font[0].size.y, text, 0, 0, (map.size.y*256)+10);
	
	
	sprintf (text, "P:");
	for (i = 0; i < MAX_PLAYERS; i++)
		if (PS_IS_playing (players[i].state)) {
			sprintf (text, "%s Pos:%f,%f ", text, players[i].pos.x, players[i].pos.y);
		}
	font_gfxdraw (0, gfx.res.y-font[0].size.y*2, text, 0, 0, (map.size.y*256)+10);

	sprintf (text, "Move: %d | %d", players[bman.p_nr].m, players[bman.p2_nr].m);	
	font_gfxdraw (350, gfx.res.y-font[0].size.y, text, 0, 0, (map.size.y*256)+10);
};
