/* $Id: main.c,v 1.26 2004/05/25 22:22:29 stpohle Exp $ */

#include "basic.h"
#include "bomberclone.h"
#include "network.h"
#include "gfx.h"
#include "menu.h"
#include "player.h"
#include "single.h"

_bomberclone bman;              // Holds GameData
_player *players;						 // holds all Playerdata

Uint32 timestamp;				// timestamp
float timefactor = 0.0f;		/* factor for the time time of the last loop
								   1.0f would be 20ms */
float timediff = 0.0f;			/* last loop timedifference in seconds */
int firstrun = 1;						// flag for the first menuloop

int
main (int argc, char **argv)
{
	int menuselect = 0;
	_menu *menu;
	
	players = malloc (sizeof (_player) * MAX_PLAYERS);
	gfxengine_init ();
	
    if (SDL_Init (SDL_INIT_VIDEO| SDL_INIT_NOPARACHUTE) != 0) {
        d_printf ("Unable to init SDL: %s\n", SDL_GetError ());
        return (1);
    }

	SDL_EnableUNICODE(1);
	
	config_init (argc, argv);
	while (menuselect != -1 && bman.state != GS_quit) {

		menu = menu_new ("Bomberclone", 400, 230);
		menu_create_button (menu, "Single Game", -1, 70, 200, 0); 
		menu_create_button (menu, "Multiplayer Game", -1, 100, 200, 1); 
		menu_create_button (menu, "Options", -1, 130, 200, 2);
		menu_create_button (menu, "Manual", -1, 160, 200, 3);
		menu_create_button (menu, "Quit Game", -1, 190, 200, 4); 
		menuselect = menu_loop (menu);
		menu_delete (menu);		
		switch (menuselect) {
			case (0) : // Singleplayer
				single_menu ();
				break;
			case (1) : // Multiplayer
				netmenu();
				break;
			case (2) : // Options
				config_menu ();
				break;
			case (3) : // Manual
				help ();
				break;
			case (4) : // Quit
				bman.state = GS_quit;
				break;
		}
	}

    gfx_shutdown ();

    return 0;
};
