/* $Id: multiwait.c,v 1.42 2004/05/25 22:22:29 stpohle Exp $
   multiwait.c - this manages only the network screen where
   everyone have to select it's players and where even the basic chat is inside
*/

#include "bomberclone.h"
#include "network.h"
#include "packets.h"
#include "gfx.h"
#include "chat.h"
#include "menu.h"
#include "single.h"
#include "keyb.h"

extern int UpdateRects_nr;
extern int blitdb_nr;

static int mw_num_readyplayers;				// number of players who are ready
static int mw_num_players_x;				// number of players in the x
static int mw_num_players_y;				// number of players in the y

#define MW_PLAYERSCR_X 250
#define MW_PLAYERSCR_Y 64
#define MW_TITLE_Y 50

/* this will load some graphics and so other stuff */
void
mw_init ()
{
    draw_logo ();

    menu_displaytext ("Please Wait", "Loading GFX Data");

    gfx_load_players (32, 32);
    network_loop ();
	mw_num_readyplayers = 0;
    bman.updatestatusbar = 1;
	
	gfx_blitdraw ();
    draw_logo ();
	
	/*
	 * do some calculations to setup everything on the screen
	 */
	mw_num_players_x = gfx.res.x / MW_PLAYERSCR_X;
	mw_num_players_y = MAX_PLAYERS / mw_num_players_x;

	d_printf ("mw_num_players_x : %d, mw_num_players_y : %d\n", mw_num_players_x, mw_num_players_y);
	
	chat_show (8, MW_TITLE_Y + MW_PLAYERSCR_Y * mw_num_players_y, gfx.res.x - 16, gfx.res.y - (8 + MW_TITLE_Y + MW_PLAYERSCR_Y * mw_num_players_y));
	chat.active = 1;
};


/* free all grafics */
void mw_shutdown () {
    chat_show (-1, -1, -1, -1);
	gfx_blitdraw ();
	draw_logo ();

    gfx_free_players ();

	SDL_Flip (gfx.screen);
};


/*
 * check if the players are ready
 */
void mw_check_players () {
	int i;

	mw_num_readyplayers = 0;
	
	if (GT_MP_PTPS)		/* only the master can start the game */
		return;
	
	for (i = 0; i < MAX_PLAYERS; i++) {
		if (players[i].gfx_nr >= 0 && players[i].gfx_nr < MAX_PLAYERS)
			mw_num_readyplayers++;
	}
}



/*
 * draw only the givin player
 */
void mw_draw_player (_player *player, int pos) {
	_point p;
	char text[255];
	SDL_Rect src;
	SDL_Rect dest;
	
	p.x = ((pos % mw_num_players_x) * MW_PLAYERSCR_X) + (gfx.res.x - mw_num_players_x * MW_PLAYERSCR_X) / 2;
	p.y = (pos / mw_num_players_x) * MW_PLAYERSCR_Y + MW_TITLE_Y;

	if (PS_IS_used (player->state)) {
		/*
		 * player is used
		 */
		if (player->gfx_nr >= 0 && player->gfx_nr < MAX_PLAYERS) {
			/* player is used and selected a gfx */
			dest.x = p.x;
			dest.y = p.y + (MW_PLAYERSCR_Y - GFX_IMGSIZE) / 2;
			src.w = dest.w = gfx.players[player->gfx_nr].ani.w;
			src.h = dest.h = gfx.players[player->gfx_nr].ani.h;
			src.x = down * gfx.players[player->gfx_nr].ani.w;
			src.y = 0;
			gfx_blit (gfx.players[player->gfx_nr].ani.image, &src, gfx.screen, &dest, 10001);
		}
		
		font_gfxdraw (p.x + GFX_IMGSIZE, p.y, player->name, 2, COLOR_yellow, 10002);
		sprintf (text,"Victorys:%2d(%d)", player->wins, player->points);
		font_gfxdraw (p.x + GFX_IMGSIZE, p.y + font[2].size.y - 4, text, 0, COLOR_white, 10002);
		if (debug && PS_IS_used (player->state)) {
			sprintf (text, "%s:%s [%d]", player->net.addr.host, player->net.addr.port, player->state);
			if (player->net.flags & NETF_firewall)
				sprintf (text,"%s Firewall", text);
			font_gfxdraw (p.x + GFX_IMGSIZE, p.y + font[0].size.y + font[2].size.y - 4, text, 0, COLOR_white, 10002);
		}
	}
	
	else {
		/*
		 * player is free
		 */
		font_gfxdraw (p.x + GFX_IMGSIZE, p.y, "No Player" , 0, COLOR_gray, 10002);
	}
		
};



/*
 * clear the player screen
 */
void mw_clear_playerscreen () {
	SDL_Rect src, dest;
	
	src.x = dest.x = 0;
	src.y = dest.y = MW_TITLE_Y;
	src.w = dest.w = gfx.res.x;
	src.h = dest.h = mw_num_players_y * MW_PLAYERSCR_Y;
	gfx_blit (gfx.logo, &src, gfx.screen, &dest, 1);
};


/*
 * draw all player informations
 */
void mw_draw_all_player () {
	int i;
	
	mw_clear_playerscreen ();
	
	for (i = 0; i < MAX_PLAYERS; i++) { /* we do not sort the players */
		mw_draw_player (&players[i], i);
	}
};


/*
 * check if one key is pressed
 */
void mw_keys_loop () {
	if (GT_MP_PTPM && mw_num_readyplayers >= 2 && keyb_gamekeys.state[BCK_pause] && !keyb_gamekeys.old[BCK_pause]) {
		/* min 2 players are ready for the game and 
		 * the start key has pressed */
        bman.state = GS_ready;
        bman.updatestatusbar = 1; // force an update
    }

	if (keyb_gamekeys.state[BCK_fullscreen]  && !keyb_gamekeys.old[BCK_fullscreen]) {
        /* Switch Fullscreen */
		SDL_WM_ToggleFullScreen(gfx.screen);
		gfx.fullscreen = !gfx.fullscreen;
        bman.updatestatusbar = 1; // force an update
    }

	if (keyb_gamekeys.state[BCK_esc] && !keyb_gamekeys.old[BCK_esc]) {
		/* ESCAPE key was pressed */
        bman.state = GS_startup;
    }

	if ((keyb_gamekeys.state[BCPK_drop] && !keyb_gamekeys.old[BCPK_drop])
		|| ((!IS_LPLAYER2) && keyb_gamekeys.state[BCPK_max + BCPK_drop] && !keyb_gamekeys.old[BCPK_max + BCPK_drop])) {
		/* player 1 want to select a new gfx */
		playermenu_selgfx (bman.p_nr);
		net_change_playerid (bman.p_nr, 1);
		keyb_loop (NULL);	// to reload the current keys
	}

	if (IS_LPLAYER2 && keyb_gamekeys.state[BCPK_max + BCPK_drop] && !keyb_gamekeys.old[BCPK_max + BCPK_drop]) {
		/* player 2 want to select a new gfx */
		playermenu_selgfx (bman.p2_nr);
		net_change_playerid (bman.p2_nr, 1);
		keyb_loop (NULL);	// to reload the current keys
	}

	if (keyb_gamekeys.state[BCK_mapmenu] && !keyb_gamekeys.old[BCK_mapmenu] && GT_MP_PTPM) {
		/* mapmenu */
		mapmenu ();
		keyb_loop (NULL);	// to reload the current keys
	}

	if (keyb_gamekeys.state[BCK_playermenu] && !keyb_gamekeys.old[BCK_playermenu]) {
		/* playermenu */
		playermenu ();
		keyb_loop (NULL);	// to reload the current keys
	}
};



/* the loop itself */
void wait_for_players () {
    SDL_Event event;

	mw_init ();
	
	do {
        if (SDL_PollEvent (&event) != 0)
            switch (event.type) {
	            case (SDL_QUIT):
    	            bman.state = GS_quit;
					break;
            }

		/*
		 * check some little things and do the network stuff
		 */
		mw_check_players ();
		network_loop ();
				
		/*
		 * the drawing stuff
		 */
		mw_draw_all_player ();
		gfx_blitdraw ();
		
		/*
		 *	input handling 
		 */
		keyb_loop (&event);
		mw_keys_loop ();

		chat_loop (&event);
		chat.active = 1;
		
		s_calctimesync ();
	} while (bman.state == GS_wait);

    mw_shutdown ();
};
