/***************************************************************************
 *            bonfire-uri-container.h
 *
 *  lun mai 22 08:54:18 2006
 *  Copyright  2006  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef BONFIRE_URI_CONTAINER_H
#define BONFIRE_URI_CONTAINER_H

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

#define BONFIRE_TYPE_URI_CONTAINER         (bonfire_uri_container_get_type ())
#define BONFIRE_URI_CONTAINER(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_URI_CONTAINER, BonfireURIContainer))
#define BONFIRE_IS_URI_CONTAINER(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_URI_CONTAINER))
#define BONFIRE_URI_CONTAINER_GET_IFACE(o) (G_TYPE_INSTANCE_GET_INTERFACE ((o), BONFIRE_TYPE_URI_CONTAINER, BonfireURIContainerIFace))


typedef struct _BonfireURIContainer BonfireURIContainer;

typedef struct {
	GTypeInterface g_iface;

	/* signals */
	void		(*uri_selected)		(BonfireURIContainer *container);
	void		(*uri_activated)	(BonfireURIContainer *container);

	/* virtual functions */
	char*		(*get_selected_uri)	(BonfireURIContainer *container);
	char**		(*get_selected_uris)	(BonfireURIContainer *container);

} BonfireURIContainerIFace;


GType bonfire_uri_container_get_type();

char *
bonfire_uri_container_get_selected_uri (BonfireURIContainer *container);
char **
bonfire_uri_container_get_selected_uris (BonfireURIContainer *container);

void
bonfire_uri_container_uri_selected (BonfireURIContainer *container);
void
bonfire_uri_container_uri_activated (BonfireURIContainer *container);

#endif /* BONFIRE_URI_CONTAINER_H */
