/***************************************************************************
 *            job.h
 *
 *  dim jan 22 10:40:26 2006
 *  Copyright  2006  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef JOB_H
#define JOB_H

#include <glib.h>
#include <glib-object.h>

#include "burn-basics.h"

G_BEGIN_DECLS

#define BONFIRE_TYPE_JOB         (bonfire_job_get_type ())
#define BONFIRE_JOB(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_JOB, BonfireJob))
#define BONFIRE_JOB_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_JOB, BonfireJobClass))
#define BONFIRE_IS_JOB(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_JOB))
#define BONFIRE_IS_JOB_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_JOB))
#define BONFIRE_JOB_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_JOB, BonfireJobClass))

typedef struct BonfireJobPrivate BonfireJobPrivate;

typedef struct {
	GObject parent;
	BonfireJobPrivate *priv;
} BonfireJob;

typedef struct {
	GObjectClass parent_class;

	/* virtual functions */

	BonfireBurnResult	(*start_init)		(BonfireJob *job,
							 gboolean has_master,
							 GError **error);

	BonfireBurnResult	(*start)		(BonfireJob *job,
							 int in_fd,
							 int *out_fd,
							 GError **error);

	BonfireBurnResult	(*stop)			(BonfireJob *job,
							 BonfireBurnResult retval);

	BonfireBurnResult	(*set_source)		(BonfireJob *job,
							 const BonfireTrackSource *source,
							 GError **error);

	BonfireBurnResult	(*set_rate)		(BonfireJob *job,
							 gint64 rate);

	BonfireBurnResult	(*get_action_string)	(BonfireJob *job,
							 BonfireBurnAction action,
							 char **string);
	/* signals */
	void			(*progress_changed)	(BonfireJob *job,
							 double fraction,
							 long remaining_time);
	void			(*action_changed)	(BonfireJob *job,
							 int action);
	void			(*animation_changed)	(BonfireJob *job,
							 gboolean spinning);
	BonfireBurnResult	(*error)		(BonfireJob *job,
							 BonfireBurnError error);
} BonfireJobClass;

GType bonfire_job_get_type();

BonfireBurnResult
bonfire_job_run (BonfireJob *last_job,
		 GError **error);

BonfireBurnResult
bonfire_job_cancel (BonfireJob *job,
		    gboolean protect);

BonfireBurnResult
bonfire_job_set_source (BonfireJob *job,
			const BonfireTrackSource *source,
			GError **error);

BonfireBurnResult
bonfire_job_set_rate (BonfireJob *job,
		      gint64 rate);

gboolean
bonfire_job_is_running (BonfireJob *job);

/* The following functions are for implementation purpose */
void
bonfire_job_set_dangerous (BonfireJob *job, gboolean value);
void
bonfire_job_set_debug (BonfireJob *job, gboolean value);
void
bonfire_job_debug_message (BonfireJob *job, const char *format, ...);

BonfireBurnResult
bonfire_job_finished (BonfireJob *job);
BonfireBurnResult
bonfire_job_error (BonfireJob *job, GError *error);

void bonfire_job_progress_changed (BonfireJob *job,
				   gdouble progress,
				   long remaining_time);
void 
bonfire_job_animation_changed (BonfireJob *job, gboolean spinning);
void
bonfire_job_action_changed (BonfireJob *job,
			    BonfireBurnAction action,
			    gboolean force);

BonfireBurnAction
bonfire_job_get_current_action (BonfireJob *job);

BonfireBurnResult
bonfire_job_get_action_string (BonfireJob *job,
			       BonfireBurnAction action,
			       char **string);

BonfireBurnResult
bonfire_job_set_slave (BonfireJob *master, BonfireJob *slave);
BonfireJob *
bonfire_job_get_slave (BonfireJob *master);
void
bonfire_job_set_run_slave (BonfireJob *job, gboolean run_slave);
void
bonfire_job_set_relay_slave_signals (BonfireJob *job, gboolean relay);
#endif /* JOB_H */
