/***************************************************************************
 *            burn-options-dialog.h
 *
 *  mer mar 29 13:47:56 2006
 *  Copyright  2006  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef BURN_OPTIONS_DIALOG_H
#define BURN_OPTIONS_DIALOG_H

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtkwindow.h>
#include <gtk/gtkdialog.h>

#include "burn-basics.h"

G_BEGIN_DECLS

#define BONFIRE_TYPE_BURN_OPTION_DIALOG         (bonfire_burn_option_dialog_get_type ())
#define BONFIRE_BURN_OPTION_DIALOG(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_BURN_OPTION_DIALOG, BonfireBurnOptionDialog))
#define BONFIRE_BURN_OPTION_DIALOG_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_BURN_OPTION_DIALOG, BonfireBurnOptionDialogClass))
#define BONFIRE_IS_BURN_OPTION_DIALOG(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_BURN_OPTION_DIALOG))
#define BONFIRE_IS_BURN_OPTION_DIALOG_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_BURN_OPTION_DIALOG))
#define BONFIRE_BURN_OPTION_DIALOG_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_BURN_OPTION_DIALOG, BonfireBurnOptionDialogClass))

typedef struct BonfireBurnOptionDialogPrivate BonfireBurnOptionDialogPrivate;

typedef struct {
	GtkDialog parent;
	BonfireBurnOptionDialogPrivate *priv;
} BonfireBurnOptionDialog;

typedef struct {
	GtkDialogClass parent_class;
} BonfireBurnOptionDialogClass;

GType bonfire_burn_option_dialog_get_type ();

GtkWidget *bonfire_burn_option_dialog_new (const BonfireTrackSource *track,
					    gboolean overburn);

#endif /* BURN_OPTIONS_DIALOG_H */
