/***************************************************************************
 *            process.h
 *
 *  dim jan 22 10:39:50 2006
 *  Copyright  2006  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PROCESS_H
#define PROCESS_H

#include <glib.h>
#include <glib-object.h>

#include "burn-basics.h"
#include "burn-job.h"

G_BEGIN_DECLS

#define BONFIRE_TYPE_PROCESS         (bonfire_process_get_type ())
#define BONFIRE_PROCESS(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_PROCESS, BonfireProcess))
#define BONFIRE_PROCESS_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_PROCESS, BonfireProcessClass))
#define BONFIRE_IS_PROCESS(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_PROCESS))
#define BONFIRE_IS_PROCESS_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_PROCESS))
#define BONFIRE_PROCESS_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_PROCESS, BonfireProcessClass))

typedef struct BonfireProcessPrivate BonfireProcessPrivate;

typedef struct {
	BonfireJob parent;
	BonfireProcessPrivate *priv;
} BonfireProcess;

typedef struct {
	BonfireJobClass parent_class;

	/* virtual functions */
	BonfireBurnResult	(*stdout_func)	(BonfireProcess *process,
						 const char *line);
	BonfireBurnResult	(*stderr_func)	(BonfireProcess *process,
						 const char *line);
	BonfireBurnResult	(*set_argv)	(BonfireProcess *process,
						 GPtrArray *argv,
						 gboolean has_master,
						 GError **error);
	BonfireBurnResult      (*post)         (BonfireProcess *process,
					          BonfireBurnResult retval);
} BonfireProcessClass;

GType bonfire_process_get_type();

#endif /* PROCESS_H */
