/***************************************************************************
 *            disc.h
 *
 *  dim nov 27 14:58:13 2005
 *  Copyright  2005  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef DISC_H
#define DISC_H

#include <glib.h>
#include <glib-object.h>

#include "burn-basics.h"

G_BEGIN_DECLS

#define BONFIRE_TYPE_DISC         (bonfire_disc_get_type ())
#define BONFIRE_DISC(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_DISC, BonfireDisc))
#define BONFIRE_IS_DISC(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_DISC))
#define BONFIRE_DISC_GET_IFACE(o) (G_TYPE_INSTANCE_GET_INTERFACE ((o), BONFIRE_TYPE_DISC, BonfireDiscIface))

typedef enum {
	BONFIRE_DISC_OK = 0,
	BONFIRE_DISC_NOT_IN_TREE,
	BONFIRE_DISC_NOT_READY,
	BONFIRE_DISC_LOADING,
	BONFIRE_DISC_BROKEN_SYMLINK,
	BONFIRE_DISC_CANCELLED,
	BONFIRE_DISC_ERROR_SIZE,
	BONFIRE_DISC_ERROR_EMPTY_SELECTION,
	BONFIRE_DISC_ERROR_FILE_NOT_FOUND,
	BONFIRE_DISC_ERROR_UNREADABLE,
	BONFIRE_DISC_ERROR_ALREADY_IN_TREE,
	BONFIRE_DISC_ERROR_FILE_TYPE,
	BONFIRE_DISC_ERROR_THREAD,
	BONFIRE_DISC_ERROR_UNKNOWN
} BonfireDiscResult;

typedef enum {
	BONFIRE_DISC_TRACK_NONE,
	BONFIRE_DISC_TRACK_AUDIO,
	BONFIRE_DISC_TRACK_DATA,
	BONFIRE_DISC_TRACK_SOURCE
} BonfireDiscTrackType;

typedef struct {
	BonfireDiscTrackType type;

	union  {
		struct {
			char *label;
			GSList *grafts;
			GSList *unreadable;
			GSList *restored;
		} data;

		GSList *uris;

		BonfireTrackSource *src;
	} contents;
} BonfireDiscTrack;

typedef struct _BonfireDisc        BonfireDisc;
typedef struct _BonfireDiscIface   BonfireDiscIface;

struct _BonfireDiscIface {
	GTypeInterface g_iface;

	/* signals */
	void	(*selection_changed)			(BonfireDisc *disc);
	void	(*contents_changed)			(BonfireDisc *disc,
							 int nb_files);
	void	(*size_changed)				(BonfireDisc *disc,
							 double size,
							 char *string);
	/* virtual functions */
	BonfireDiscResult	(*get_status)		(BonfireDisc *disc);
	BonfireDiscResult	(*get_track)		(BonfireDisc *disc,
							 BonfireDiscTrack *track,
							 gboolean src_format);
	BonfireDiscResult	(*load_track)		(BonfireDisc *disc,
							 BonfireDiscTrack *track);
	BonfireDiscResult	(*add_uri)		(BonfireDisc *disc,
							 const char *uri);

	char *			(*get_selected_uri)	(BonfireDisc *disc);

	void			(*delete_selected)	(BonfireDisc *disc);
	void			(*clear)		(BonfireDisc *disc);
	void			(*reset)		(BonfireDisc *disc);
};

GType bonfire_disc_get_type();

BonfireDiscResult
bonfire_disc_add_uri (BonfireDisc *disc, const char *uri);
char *
bonfire_disc_get_selected_uri (BonfireDisc *disc);
void
bonfire_disc_delete_selected (BonfireDisc *disc);
void
bonfire_disc_clear (BonfireDisc *disc);
void
bonfire_disc_reset (BonfireDisc *disc);

BonfireDiscResult
bonfire_disc_get_status (BonfireDisc *disc);

BonfireDiscResult
bonfire_disc_get_track (BonfireDisc *disc,
			BonfireDiscTrack *track,
			gboolean src_format);
BonfireDiscResult
bonfire_disc_load_track (BonfireDisc *disc,
			 BonfireDiscTrack *track);

void
bonfire_disc_size_changed (BonfireDisc *disc,
			   double size,
			   const char *string);
void
bonfire_disc_contents_changed (BonfireDisc *disc,
			       int nb_files);
void
bonfire_disc_selection_changed (BonfireDisc *disc);

void
bonfire_track_clear (BonfireDiscTrack *track);
void
bonfire_track_free (BonfireDiscTrack *track);

#endif /* DISC_H */
