/***************************************************************************
 *            player-bacon.h
 *
 *  ven déc 30 11:29:33 2005
 *  Copyright  2005  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PLAYER_BACON_H
#define PLAYER_BACON_H

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

#define BONFIRE_TYPE_PLAYER_BACON         (bonfire_player_bacon_get_type ())
#define BONFIRE_PLAYER_BACON(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_PLAYER_BACON, BonfirePlayerBacon))
#define BONFIRE_PLAYER_BACON_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_PLAYER_BACON, BonfirePlayerBaconClass))
#define BONFIRE_IS_PLAYER_BACON(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_PLAYER_BACON))
#define BONFIRE_IS_PLAYER_BACON_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_PLAYER_BACON))
#define BONFIRE_PLAYER_BACON_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_PLAYER_BACON, BonfirePlayerBaconClass))

#define	PLAYER_BACON_WIDTH 120
#define	PLAYER_BACON_HEIGHT 90

typedef struct BonfirePlayerBaconPrivate BonfirePlayerBaconPrivate;

typedef enum {
	BACON_STATE_ERROR,
	BACON_STATE_READY,
	BACON_STATE_PAUSED,
	BACON_STATE_PLAYING
} BonfirePlayerBaconState;

typedef struct {
	GtkWidget parent;
	BonfirePlayerBaconPrivate *priv;
} BonfirePlayerBacon;

typedef struct {
	GtkWidgetClass parent_class;

	void	(*state_changed)	(BonfirePlayerBacon *bacon,
					 BonfirePlayerBaconState state);

	void	(*eof)			(BonfirePlayerBacon *bacon);

} BonfirePlayerBaconClass;

GType bonfire_player_bacon_get_type (void);
GtkWidget *bonfire_player_bacon_new (void);

void bonfire_player_bacon_set_uri (BonfirePlayerBacon *bacon, const char *uri);
gboolean bonfire_player_bacon_play (BonfirePlayerBacon *bacon);
gboolean bonfire_player_bacon_stop (BonfirePlayerBacon *bacon);
gboolean bonfire_player_bacon_set_pos (BonfirePlayerBacon *bacon, gdouble pos);
gboolean bonfire_player_bacon_get_pos (BonfirePlayerBacon *bacon, gint64 *pos);
gboolean bonfire_player_bacon_get_length (BonfirePlayerBacon *bacon, gint64 *length);

#endif /* PLAYER_BACON_H */
