﻿#region license
// Copyright (c) 2003, 2004, 2005 Rodrigo B. de Oliveira (rbo@acm.org)
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
//     * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//     * Neither the name of Rodrigo B. de Oliveira nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#endregion

//
// DO NOT EDIT THIS FILE!
//
// This file was generated automatically by
// astgenerator.boo on 29/6/2005 15:54:04
//

namespace Boo.Lang.Compiler.Ast.Impl
{	
	using Boo.Lang.Compiler.Ast;
	using System.Collections;
	using System.Runtime.Serialization;
	
	[System.Serializable]
	public abstract class ExplicitMemberInfoImpl : Node
	{

		protected SimpleTypeReference _interfaceType;

		protected ExplicitMemberInfoImpl()
		{
			InitializeFields();
		}
		
		protected ExplicitMemberInfoImpl(LexicalInfo info) : base(info)
		{
			InitializeFields();
		}
		

		protected ExplicitMemberInfoImpl(SimpleTypeReference interfaceType)
		{
			InitializeFields();
			InterfaceType = interfaceType;
		}
			
		protected ExplicitMemberInfoImpl(LexicalInfo lexicalInfo, SimpleTypeReference interfaceType) : base(lexicalInfo)
		{
			InitializeFields();
			InterfaceType = interfaceType;
		}
			
		new public ExplicitMemberInfo CloneNode()
		{
			return Clone() as ExplicitMemberInfo;
		}

		override public NodeType NodeType
		{
			get
			{
				return NodeType.ExplicitMemberInfo;
			}
		}

		override public bool Replace(Node existing, Node newNode)
		{
			if (base.Replace(existing, newNode))
			{
				return true;
			}

			if (_interfaceType == existing)
			{
				this.InterfaceType = (SimpleTypeReference)newNode;
				return true;
			}

			return false;
		}

		override public object Clone()
		{
			ExplicitMemberInfo clone = FormatterServices.GetUninitializedObject(typeof(ExplicitMemberInfo)) as ExplicitMemberInfo;
			clone._lexicalInfo = _lexicalInfo;
			clone._endSourceLocation = _endSourceLocation;
			clone._documentation = _documentation;
			clone._entity = _entity;
			clone._annotations = null != _annotations ? (Hashtable)_annotations.Clone() : null;
			

			if (null != _interfaceType)
			{
				clone._interfaceType = _interfaceType.Clone() as SimpleTypeReference;
				clone._interfaceType.InitializeParent(clone);
			}
			
			return clone;
		}
			
		override public void ClearTypeSystemBindings()
		{
			_annotations = null;
			_entity = null;
			

			if (null != _interfaceType)
			{
				_interfaceType.ClearTypeSystemBindings();
			}

		}

		[System.Xml.Serialization.XmlElement]
		public SimpleTypeReference InterfaceType
		{
			get
			{
				return _interfaceType;
			}
			

			set
			{
				if (_interfaceType != value)
				{
					_interfaceType = value;
					if (null != _interfaceType)
					{
						_interfaceType.InitializeParent(this);

					}
				}
			}
			

		}
		

		private void InitializeFields()
		{

		}
	}
}
