#region license
// Copyright (c) 2003, 2004, 2005 Rodrigo B. de Oliveira (rbo@acm.org)
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
//     * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//     * Neither the name of Rodrigo B. de Oliveira nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#endregion

//
// DO NOT EDIT THIS FILE!
//
// This file was generated automatically by astgen.boo.
//

namespace Boo.Lang.Compiler.Ast.Impl
{	
	using Boo.Lang.Compiler.Ast;
	using System.Collections;
	using System.Runtime.Serialization;
	
	[System.Serializable]
	public abstract class EventImpl : TypeMember
	{
		protected Method _add;

		protected Method _remove;

		protected Method _raise;

		protected TypeReference _type;

		protected EventImpl()
		{
			InitializeFields();
		}
		
		protected EventImpl(LexicalInfo info) : base(info)
		{
			InitializeFields();
		}
		
		protected EventImpl(Method add, Method remove, Method raise, TypeReference type)
		{
			InitializeFields();
			Add = add;
			Remove = remove;
			Raise = raise;
			Type = type;
		}
			
		protected EventImpl(LexicalInfo lexicalInfo, Method add, Method remove, Method raise, TypeReference type) : base(lexicalInfo)
		{
			InitializeFields();
			Add = add;
			Remove = remove;
			Raise = raise;
			Type = type;
		}

		new public Event CloneNode()
		{
			return Clone() as Event;
		}

		override public NodeType NodeType
		{
			get
			{
				return NodeType.Event;
			}
		}
		
		override public bool Matches(Node node)
		{	
			Event other = node as Event;
			if (null == other) return false;
			if (_modifiers != other._modifiers) return false;
			if (_name != other._name) return false;
			if (!Node.Matches(_attributes, other._attributes)) return false;
			if (!Node.Matches(_add, other._add)) return false;
			if (!Node.Matches(_remove, other._remove)) return false;
			if (!Node.Matches(_raise, other._raise)) return false;
			if (!Node.Matches(_type, other._type)) return false;
			return true;
		}
	
		override public bool Replace(Node existing, Node newNode)
		{
			if (base.Replace(existing, newNode))
			{
				return true;
			}
			if (_attributes != null)
			{
				Attribute item = existing as Attribute;
				if (null != item)
				{
					Attribute newItem = (Attribute)newNode;
					if (_attributes.Replace(item, newItem))
					{
						return true;
					}
				}
			}
			if (_add == existing)
			{
				this.Add = (Method)newNode;
				return true;
			}
			if (_remove == existing)
			{
				this.Remove = (Method)newNode;
				return true;
			}
			if (_raise == existing)
			{
				this.Raise = (Method)newNode;
				return true;
			}
			if (_type == existing)
			{
				this.Type = (TypeReference)newNode;
				return true;
			}
			return false;
		}
		
		override public object Clone()
		{
			Event clone = (Event)FormatterServices.GetUninitializedObject(typeof(Event));
			clone._lexicalInfo = _lexicalInfo;
			clone._endSourceLocation = _endSourceLocation;
			clone._documentation = _documentation;
			//clone._entity = _entity;
			clone._annotations = (Hashtable)_annotations.Clone();
		
			clone._modifiers = _modifiers;
			clone._name = _name;
			if (null != _attributes)
			{
				clone._attributes = _attributes.Clone() as AttributeCollection;
				clone._attributes.InitializeParent(clone);
			}
			if (null != _add)
			{
				clone._add = _add.Clone() as Method;
				clone._add.InitializeParent(clone);
			}
			if (null != _remove)
			{
				clone._remove = _remove.Clone() as Method;
				clone._remove.InitializeParent(clone);
			}
			if (null != _raise)
			{
				clone._raise = _raise.Clone() as Method;
				clone._raise.InitializeParent(clone);
			}
			if (null != _type)
			{
				clone._type = _type.Clone() as TypeReference;
				clone._type.InitializeParent(clone);
			}
			return clone;
		}
		
		override internal void ClearTypeSystemBindings()
		{
			_annotations.Clear();
			//_entity = null;
			if (null != _attributes)
			{
				_attributes.ClearTypeSystemBindings();
			}
			if (null != _add)
			{
				_add.ClearTypeSystemBindings();
			}
			if (null != _remove)
			{
				_remove.ClearTypeSystemBindings();
			}
			if (null != _raise)
			{
				_raise.ClearTypeSystemBindings();
			}
			if (null != _type)
			{
				_type.ClearTypeSystemBindings();
			}

		}
	

		[System.Xml.Serialization.XmlElement]
		public Method Add
		{
			get
			{
				return _add;
			}

			set
			{
				if (_add != value)
				{
					_add = value;
					if (null != _add)
					{
						_add.InitializeParent(this);
					}
				}
			}

		}
		

		[System.Xml.Serialization.XmlElement]
		public Method Remove
		{
			get
			{
				return _remove;
			}

			set
			{
				if (_remove != value)
				{
					_remove = value;
					if (null != _remove)
					{
						_remove.InitializeParent(this);
					}
				}
			}

		}
		

		[System.Xml.Serialization.XmlElement]
		public Method Raise
		{
			get
			{
				return _raise;
			}

			set
			{
				if (_raise != value)
				{
					_raise = value;
					if (null != _raise)
					{
						_raise.InitializeParent(this);
					}
				}
			}

		}
		

		[System.Xml.Serialization.XmlElement]
		public TypeReference Type
		{
			get
			{
				return _type;
			}

			set
			{
				if (_type != value)
				{
					_type = value;
					if (null != _type)
					{
						_type.InitializeParent(this);
					}
				}
			}

		}
		
		private void InitializeFields()
		{

		}
	}
}

