[-- template default.template --]
[-- define title=Compiling BookmarkBridge From Source --]
[-- define chapter_title=3. How BookmarkBridge Works --]
[-- define prev_link=theory_of_operation.html --]
[-- define prev_title=Theory of Operation --]
[-- define next_link=source_code_roadmap.html --]
[-- define next_title=Source Code Roadmap --]

<p>
Since BookmarkBridge is a multi-platform program, the instructions for compiling from
the source code differ a bit between platforms.  Even though the procedure for compiling
BookmarkBridge may differ between platforms, the source code itself is exactly the
same, whether for Windows or Unix.  All files necessary for compiling it for all
supported platforms are present in the source distribution.
</p>

<h3>Development Pre-requisites</h3>
<p>
BookmarkBridge was written using a few open-source toolkits.  Before compiling
BookmarkBridge under Windows or Unix, you must ensure these development kits are
available on your computer.
<dl>
	<dt>Qt</dt>
	<dd>
		Qt is a multi-platform GUI development framework available for Windows,
		Unix (X11), and Macintosh.  For Unix you need to make sure you have
		the <b>Qt/X11 Free Edition</b>.  For Windows you need to obtain the
		<b>2.3.0 Non-Commercial Edition</b>.  Both are available free from
		TrollTech at www.trolltech.com.
		BookmarkBridge will compile with 2.3.0 or 3.0.X.  <b>For Windows, make
		sure you download the non-commercial edition!</b>
	</dd>
	<dt>Libxml</dt>
	<dd>
		Libxml is an off-shoot of the Gnome Desktop Environment.  It is a
		toolkit used for reading and writing XML and HTML files.
		BookmarkBridge is written to use libxml2.  You can download a
		development toolkit at www.xmlsoft.org.
	</dd>
</dl>
</p>

<h3>Compiling BookmarkBridge for Windows</h3>
<p>
I developed the Windows portions of BookmarkBridge using Microsoft Visual Studio 6.0.
The Qt 2.3.0 NC edition does not work with Visual Studio .NET 2002, which I also have.
I have had limited success compiling BookmarkBridge under Visual Studio .NET and even
got it to link once but BookmarkBridge seemed somewhat unstable.  I make no promises
that BookmarkBridge will work with VS .NET and probably will not be very helpful with
questions or support for those who wish to try it.
</p>

<p>
As part of the source distribution I provide a .pro file.  The easiest way to start
a project in MSVC 6.0 is to use the Qt integration to import bookmarkbridge.pro.  The
.pro file is a project file describing BookmarkBridge's compilation procedure.  For
those wishing to compile BookmarkBridge from the command line, the tmake utility,
included with the Qt development toolkit can read a .pro file and convert it to a
Makefile suitable for use with Microsoft Nmake.  Before compiling, either in the visual
development environment or through the command line, you need to be sure the include
path is set up correctly for Libxml2.  If compiling from the command line, edit the
bookmarkbridge.pro file and change the include path.  If using the visual development
environment, change your project settings (from the Project menu).
</p>

<h3>Compiling BookmarkBridge for Unix</h3>
<p>
On Unix, BookmarkBridge uses the standard GNU build procedure.  Just run the following
commands at a shell prompt:
</p>

<pre>
#: ./configure --enable-mt
#: make
#: make install
</pre>

<p>
</p>

<p>
If you get this error message <b>configure: error: Qt (>= 2.2.2) (headers and
libraries) not found. Please check your installation!</b> while running configure, it
means that configure could not locate the Qt development files, discussed in the
<b>Development Pre-requisites</b> section, above.  You can tell configure where to find
these files by typing:
</p>

<pre>#: ./configure --with-qt-dir=/usr/lib/qt2</pre>

<p>In this case,</p>

<pre>/usr/lib/qt2</pre>

<p>
is the directory where configure can expect to find the include directory and
lib directory for Qt. If this still does not work, try adding
</p>

<pre>--enable-mt</pre>

<p>to the command line for configure.</p>

<p>
If you receive an error message during compilation that the file
<b>&lt;libxml/parser.h&gt;</b> is missing, then you can tell configure
where to find the files.  As discussed in the <b>Development Pre-requisites</b>
section above, you must have the development files for libxml2 installed.  The default is <b>/usr/include/libxml2</b>, but you can use the following:

<pre>#: ./configure --with-libxml2-include=/usr/local/include/libxml2</pre>

<p>Is this case,</p>

<pre>/usr/local/include/libxml2</pre>

<p>
is the directory where the compiler can expect to find the libxml directory containing
the include files for libxml2.
</p>


</p>
