#!/bin/sh

# usage (local mode): mini-iso.sh <flavour>
# usage (fetch mode): mini-iso.sh <flavour> <mirror> [yes|no]

# Goal: get boot floppies from the nearest ftp/http mirror,
#   prepare them for the CD and create a netinst iso image.
# If a mirror is specified, the boot-floppy images will be 
#   downloaded from it first. The mirror string has the normal 
#   format, like:   http://ftp.at.debian.org/debian

# Add "yes" to download basedebs.tar. If omitted, script will 
#   look for already-downloaded ./basedebs.tar and use it, 
#   if available. Add "no" to prevent use of basedebs.tar.
# 
# Requirements: wget, mkisofs, hfsutils, CD-RW recorder

# This is a ppc version of Eduard's original i386 script.
#   For powerpc, you also need hfsutils, who insists that
#   you must run this script as root or sudo.

# Valid flavours are powermac (2.2 kernel) and new-powermac (2.4).
#   When you run the powerpc script, it creates a subfolder for
#   the flavor you are working on, downloads the needed files 
#   there, then creates the iso called boot-${flavour}.iso in 
#   the folder you ran from. basedebs.tar is also kept in the 
#   script folder if you asked for it.

# With this CD in a NewWorld CD Drive, you should be able to 
#   boot from OpenFirmware with:   
#   0 > boot cd:,yaboot
# It might even boot just holding the C key, or possibly the 
#   key combination Command/Option/Shift/Delete at startup. For
#   an OldWorld, you'll have to use BootX (which is on the CD)
#   to boot linux.bin with root.bin as the ramdisk.

flavour=$1
if [ x$flavour = "x" ] ; then 
   echo Flavour not supplied, aborting!
   cat $0 | head -n 36 | tail -n 35
   exit 1
fi

suite=woody
arch=powerpc
path=$2/dists/$suite/main/disks-$arch/current/$flavour/

test -f common.sh && . ./common.sh

mkdir -p ${flavour}
cd ${flavour}
tmpdir=${tmpdir:-$HOME/.tmp}
mkdir -p $tmpdir 2>/dev/null || true

if [ "$2" ] ; then

   if [ $flavour = "powermac" ] ; then
     wget -N $path/BootX_1.2.2.sit
     wget -N $path/bootargs
     wget -N $path/bootvars1.3b.sit.hqx
     wget -N $path/images-1.44/boot-floppy-hfs.img
   fi
   wget -N $path/drivers.tgz
   wget -N $path/install.txt
   wget -N $path/linux.bin
   wget -N $path/images-1.44/root.bin
   wget -N $path/sysmap.gz
   wget -N $path/yaboot
   wget -N $path/yaboot.conf
   wget -N $2/dists/$suite/Release
 
# no language pack for powerpc yet
#   if [ -e xlp.tgz ] ; then
#      echo xlp.tgz found, not downloading.
#   else
#      echo "Downloading language pack..."
#      wget -N $path/xlp.tgz
#   fi

   if [ "$3" = "yes" ] ; then
      if [ -e ../basedebs.tar ] ; then
         # basedebs is in the script folder, but move it in here
         # for the size measurement we need
         mv ../basedebs.tar .
      else
         wget -N $2/dists/$suite/main/disks-$arch/base-images-current/basedebs.tar || rm basedebs.tar
      fi   
   fi

   if [ $flavour = "powermac" ] ; then
      wget -N $path/images-1.44/rescue.bin
   else
      wget -N $path/images-2.88/rescue.bin
   fi

fi

# Base check

if [ -e rescue.bin -a -e drivers.tgz ] ; then
   true
else
   cd ../
   echo Required files missing, aborting!
   cat $0 | head -n 36 | tail -n 35
   exit 1
fi

# CD mastering
# For powerpc, we have to master in an hfsutils mount to use hattrib

# fake files hcopy can use later
touch info kernel_installable base_installable

CD=${tmpdir}/minicd.hfs
# add a fudge factor cuz hfs uses more filespace for the same content
dd if=/dev/zero of=fudge bs=1k count=700
dd if=/dev/zero of=${CD} bs=1k count=`du -s | sed 's/\.//'`
hformat -l K9 ${CD}

# Bring all the useful stuff up to the root level of the CD
# ofboot.b?
hcopy -r linux.bin root.bin yaboot yaboot.conf :
hattrib -t DDim -c ddsk root.bin
# this type makes yaboot the 'System'
hattrib -t tbxi yaboot

hmkdir install
hcd install
hcopy -r install.txt :
hattrib -t TEXT -c ttxt install.txt

if [ $flavour = "powermac" ] ; then
   hcopy -r BootX_1.2.2.sit bootargs boot-floppy-hfs.img :
   # hcopy makes _ into a space
   hrename "BootX 1.2.2.sit" BootX_1.2.2.sit
   hattrib -t SIT! -c SIT! BootX_1.2.2.sit
   hattrib -t DDim -c ddsk boot-floppy-hfs.img
   hcopy -b bootvars1.3b.sit.hqx :
fi

hcd
hmkdir dists 
hcd dists
hmkdir ${suite}
hcd ${suite}
hcopy -r Release :
hmkdir main
hcd main
hmkdir disks-${arch}
hcd disks-${arch}
hmkdir base-images-current
hmkdir current
hcd current
hmkdir ${flavour}
hcd ${flavour}
hcopy -r drivers.tgz :
hcopy -r sysmap.gz :

hmkdir images-1.44
hmkdir images-2.88
if [ $flavour = "powermac" ] ; then
  hcopy -r rescue.bin :images-1.44
else
  hcopy -r rescue.bin :images-2.88
fi

if [ -e basedebs.tar -a "$3" != "no" ] ; then
   echo Found basedebs.tar, installing it...
   hcd K9:dists:${suite}:main:disks-${arch}:base-images-current
   hcopy -r basedebs.tar :
fi

hcd
hmkdir .disk
hcd .disk
hcopy info kernel_installable :
if [ -e basedebs.tar -a "$3" != "no" ] ; then
  hcopy base_installable :
fi

if [ -f xlp.tgz ]; then
  hcd
  hmkdir .xlp
  hcd .xlp
  #  don't bother yet
  #  gzip -dc xlp.tgz | ( cd ${CD}/.xlp; tar xf - )
fi

humount
mkdir -p hfsmount
mount -t hfs -o loop ${CD} hfsmount
isoname=${tmpdir}/minicd.iso
( cd hfsmount; mkisofs -hfs -part -hfs-volid "Debian GNU/Linux Mini-ISO" --cap -l -L -allow-multidot -relaxed-filenames -T -hfs-unlock -o ${isoname} . )
# Options used:
#   -hfs: Hybrid HFS/ISO9660 cd
#   -part: single partition with partition map
#   -hfs-volid: name that appears in MacOS
#   --cap: use creators/types from hfs master files
#   -l: use long filenames (31 characters)
#   -L: allow leading dot in filenames (e.g. .disk)
#   -allow-multidot: allow more than one dot in a filename (e.g. install.en.txt)
#   -relaxed-filenames: allow all 7-bit ascii characters (e.g. images-1.44)
#   -T: create TRANS.TBL directory tables (they might be useful to someone)
#   -hfs-unlock: leave cd unlocked so we can bless it below
#   -hfs-bless: if it worked, we could use this
# FIXME: for prep usage, add -prep-boot prep_boot_file
umount hfsmount

# one last time for the blessing, until mkisofs gets their blessing code fixed
hmount ${isoname}
hattrib -b :
humount

if [ -e basedebs.tar -a "$3" = "yes" ] ; then
      mv ${isoname} ../boot-${flavour}-base.iso
else
      mv ${isoname} ../boot-${flavour}.iso
fi

if [ -e basedebs.tar ] ; then
   mv basedebs.tar ../
fi
rm -rf "${CD}"
