#DESC: lcs: OSA-2 Token Ring/Ethernet or OSA-Express Fast Ethernet (non-QDIO)

# initial network setup for s390 installation
#
# written by Stefan Gybas and Frank Kirschner
# maintained by the boot-floppies team, debian-boot@lists.debian.org
# copyright (c) 2001
# This is free software under the GNU General Public License.

get_chantype $network_module
chantype=$ans
devno_list=`print_chandevnos $chantype | cut -d\  -f2`
list_length $devno_list
devno_count=$?

if [ $devno_count -eq 2 ]; then
  element_from_list 1 $devno_list
  read_devno=$element
  element_from_list 2 $devno_list
  write_devno=$element
else
  read_devno=""
  write_devno=""
fi

if [ $devno_count -ge 1 ]; then
  print_chandevheader
  print_chandevnos $chantype
else
  cat <<__EOF__
No OSA-2 or OSA-Express cards were detected. If you are running VM please make
sure that your card is attached to this guest. If you want to use HiperSockets
or an OSA-Express card in QDIO mode please use the qeth driver instead.
__EOF__
  return 1
fi

while :; do

  cat <<__EOF__
The following device numbers might belong to OSA-2 or OSA-Express cards, but
please note that CTC/ESCON devives might also be listed here:
__EOF__
  echo $devno_list

  cat <<__EOF__

Please enter the read device numbers for your device in hexadecimal notation
preceeded by 0x, e.g. "0x1000" or "auto" for automatic probing. However,
auto probing might not work because CTC/ESCON uses the same device type.
Note: The read device numer must be an even number and the write device 
number must be the following number.
Advanced users may also enter all chandev parameters for the lcs module, e.g.
"lcs0,0x1000,0x1001,0,0,0,0". See the chapter about the "Channel device layer"
in "LINUX for S/390: Device Drivers and Installation Commands" for details.
__EOF__

  readln "lcs read device number: " $read_devno
  if [ "$ans" = "auto" ]; then
    module_parm=""
    chandev_parm=""
    chandev_module_parm=""
    break;
  fi

  # Test if it's a complete lcs chandev parameter line
  echo $ans | grep -q '^lcs.*,0x.*,0x.*'
  if [ $? = 0 ]; then
    module_parm=""
    chandev_parm="noauto"
    chandev_module_parm="$ans"
    break;
  fi

  # It must be the read device number then...
  echo $ans | grep -q '^0x[0-9a-f]*'
  if [ $? -eq 0 ]; then
    read_devno=$ans
    # ash does not support hexadecimal numbers, so convert to decimal first
    ans=`printf "%d" $ans`
    write_devno=`printf "0x%x" $(($ans + 1))`

    echo "Please enter the relative port number to use on your card (0 or 1)"
    readln "lcs port number: " 0

    module_parm=""
    chandev_parm="noauto"
    chandev_module_parm="${network_module}-1,$read_devno,$write_devno,0,$ans"
    break;
  fi

  echo ""
  echo "Your answer is not valid. Please retry!"
done

# If not in auto mode, test if the device numbers are in the list
echo $chandev_module_parm | grep -q '^lcs'
if [ $? -eq 0 ]; then
  read_devno=`echo $chandev_module_parm | cut -d, -f2`
  write_devno=`echo $chandev_module_parm | cut -d, -f3`
  # TODO: test if devices are in list
fi
