#include <stdio.h>
#include <dirent.h>
#include <string.h>
#include <sys/sysmacros.h>
#include <sys/stat.h>
#include <unistd.h>
#include "dbootstrap.h"
#include "lang.h"

static dev_t my_device;
static char *my_device_name;

static int match_mount(const char *source, struct stat *i) {
	if ( S_ISBLK(i->st_mode) 
	 && (i->st_rdev == my_device)) {
		my_device_name=strdup(source);
		return -1; /*found one*/
	} else
		return 0;
}

int is_nfs_root (const char *name)
{
  FILE *proc;
  int match = FALSE;
  char dev[80], dir[80], type[80];

  if (name[0] != '/' && name[1] != '\0')
    return FALSE;

  proc = fopen ("/proc/mounts", "r");
  if ( proc ==  NULL )
  {
    perrorBox(_("Can't read /proc/mounts"));
    return -1;
  }

  /* Can't use is_fstype() from baseconfig.c because that one doesn't
     compare the type.  -Joey
  */
  while ( EOF != fscanf (proc, "%s %s %s %*s %*i %*i\n",
                 dev, dir, type))
  {
    if (!strncmp ("/dev/root", dev, 79)
	&& !strncmp (name, dir, 79)
	&& !strncmp ("nfs", type, 79))
    {
      match = TRUE;
      break;
    }
  }

  fclose (proc);

  return match;
}

char *block_device(char *name)
{
  struct stat s;
  char *buf;
  
 if(stat(name, &s))
   return (char *) NULL; /* non-existent */

  my_device=s.st_dev;
  my_device_name=NULL;
      /* recurse /dev to find the appropriate device for *name */  
  recursiveAction("/dev", TRUE, FALSE, FALSE, match_mount, NULL);
  
  if (!my_device_name && is_nfs_root (name) == TRUE) {
    my_device_name = strdup ("/dev/root");
  }

  if(my_device_name) {
    buf=strdup(my_device_name);
    free(my_device_name);
    return buf;
  }

	return (char *) NULL;
}
