/*
 * Description  Net-fetch interface.
 * CVS          $Id: net-fetch.h,v 1.5 2001/10/15 22:28:27 dwhedon Exp $
 * Author       Marcel Harkema <marcel@debian.org>
 *
 * Copyright (C) 1999, 2000 Marcel Harkema
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __NET_FETCH_H__
#define __NET_FETCH_H__


int   nf_install_os      (void);
int   nf_install_base    (void);
int   nf_select_server   (void);
void  nf_initialize      (void);

struct _nf_endpoint {
  char                *hostname;
  unsigned short int   port;
};

struct _nf_state {
  char                 initialized;
  char                *method;
  struct _nf_endpoint  server;
  struct _nf_endpoint  proxy;
  char                *path;        /* debian/dists/potato/ ... */
};
extern struct _nf_state nf_state;

#endif /* __NET_FETCH_H__ */
